/*
 * Decompiled with CFR 0.152.
 */
package oshi.jna.platform.unix;

import com.sun.jna.Native;
import java.nio.ByteBuffer;
import oshi.jna.platform.unix.CLibrary;
import oshi.util.FileUtil;

public interface AixLibc
extends CLibrary {
    public static final AixLibc INSTANCE = Native.load("c", AixLibc.class);
    public static final int PRCLSZ = 8;
    public static final int PRFNSZ = 16;
    public static final int PRARGSZ = 80;

    public int thread_self();

    public static class Timestruc {
        public long tv_sec;
        public int tv_nsec;
        public int pad;

        public Timestruc(ByteBuffer byteBuffer) {
            this.tv_sec = FileUtil.readLongFromBuffer(byteBuffer);
            this.tv_nsec = FileUtil.readIntFromBuffer(byteBuffer);
            this.pad = FileUtil.readIntFromBuffer(byteBuffer);
        }
    }

    public static class AixLwpsInfo {
        public long pr_lwpid;
        public long pr_addr;
        public long pr_wchan;
        public int pr_flag;
        public byte pr_wtype;
        public byte pr_state;
        public byte pr_sname;
        public byte pr_nice;
        public int pr_pri;
        public int pr_policy;
        public byte[] pr_clname = new byte[8];
        public int pr_onpro;
        public int pr_bindpro;

        public AixLwpsInfo(ByteBuffer byteBuffer) {
            this.pr_lwpid = FileUtil.readLongFromBuffer(byteBuffer);
            this.pr_addr = FileUtil.readLongFromBuffer(byteBuffer);
            this.pr_wchan = FileUtil.readLongFromBuffer(byteBuffer);
            this.pr_flag = FileUtil.readIntFromBuffer(byteBuffer);
            this.pr_wtype = FileUtil.readByteFromBuffer(byteBuffer);
            this.pr_state = FileUtil.readByteFromBuffer(byteBuffer);
            this.pr_sname = FileUtil.readByteFromBuffer(byteBuffer);
            this.pr_nice = FileUtil.readByteFromBuffer(byteBuffer);
            this.pr_pri = FileUtil.readIntFromBuffer(byteBuffer);
            this.pr_policy = FileUtil.readIntFromBuffer(byteBuffer);
            FileUtil.readByteArrayFromBuffer(byteBuffer, this.pr_clname);
            this.pr_onpro = FileUtil.readIntFromBuffer(byteBuffer);
            this.pr_bindpro = FileUtil.readIntFromBuffer(byteBuffer);
        }
    }

    public static class AixPsInfo {
        public int pr_flag;
        public int pr_flag2;
        public int pr_nlwp;
        public int pr__pad1;
        public long pr_uid;
        public long pr_euid;
        public long pr_gid;
        public long pr_egid;
        public long pr_pid;
        public long pr_ppid;
        public long pr_pgid;
        public long pr_sid;
        public long pr_ttydev;
        public long pr_addr;
        public long pr_size;
        public long pr_rssize;
        public Timestruc pr_start;
        public Timestruc pr_time;
        public short pr_cid;
        public short pr__pad2;
        public int pr_argc;
        public long pr_argv;
        public long pr_envp;
        public byte[] pr_fname = new byte[16];
        public byte[] pr_psargs = new byte[80];
        public long[] pr__pad = new long[8];
        public AixLwpsInfo pr_lwp;

        public AixPsInfo(ByteBuffer byteBuffer) {
            this.pr_flag = FileUtil.readIntFromBuffer(byteBuffer);
            this.pr_flag2 = FileUtil.readIntFromBuffer(byteBuffer);
            this.pr_nlwp = FileUtil.readIntFromBuffer(byteBuffer);
            this.pr__pad1 = FileUtil.readIntFromBuffer(byteBuffer);
            this.pr_uid = FileUtil.readLongFromBuffer(byteBuffer);
            this.pr_euid = FileUtil.readLongFromBuffer(byteBuffer);
            this.pr_gid = FileUtil.readLongFromBuffer(byteBuffer);
            this.pr_egid = FileUtil.readLongFromBuffer(byteBuffer);
            this.pr_pid = FileUtil.readLongFromBuffer(byteBuffer);
            this.pr_ppid = FileUtil.readLongFromBuffer(byteBuffer);
            this.pr_pgid = FileUtil.readLongFromBuffer(byteBuffer);
            this.pr_sid = FileUtil.readLongFromBuffer(byteBuffer);
            this.pr_ttydev = FileUtil.readLongFromBuffer(byteBuffer);
            this.pr_addr = FileUtil.readLongFromBuffer(byteBuffer);
            this.pr_size = FileUtil.readLongFromBuffer(byteBuffer);
            this.pr_rssize = FileUtil.readLongFromBuffer(byteBuffer);
            this.pr_start = new Timestruc(byteBuffer);
            this.pr_time = new Timestruc(byteBuffer);
            this.pr_cid = FileUtil.readShortFromBuffer(byteBuffer);
            this.pr__pad2 = FileUtil.readShortFromBuffer(byteBuffer);
            this.pr_argc = FileUtil.readIntFromBuffer(byteBuffer);
            this.pr_argv = FileUtil.readLongFromBuffer(byteBuffer);
            this.pr_envp = FileUtil.readLongFromBuffer(byteBuffer);
            FileUtil.readByteArrayFromBuffer(byteBuffer, this.pr_fname);
            FileUtil.readByteArrayFromBuffer(byteBuffer, this.pr_psargs);
            for (int i = 0; i < this.pr__pad.length; ++i) {
                this.pr__pad[i] = FileUtil.readLongFromBuffer(byteBuffer);
            }
            this.pr_lwp = new AixLwpsInfo(byteBuffer);
        }
    }
}

