/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils.helper;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.SecurityHelper;
import pro.gravit.utils.helper.SecurityHelper$DigestAlgorithm;

public final class UnpackHelper {
    public static void unpack(URL uRL, Path path) {
        if (IOHelper.isFile(path) && UnpackHelper.matches(path, uRL)) {
            return;
        }
        Files.deleteIfExists(path);
        IOHelper.createParentDirs(path);
        try (InputStream inputStream = IOHelper.newInput(uRL);){
            IOHelper.transfer(inputStream, path);
        }
    }

    private static boolean matches(Path path, URL uRL) {
        try {
            return Arrays.equals(SecurityHelper.digest(SecurityHelper$DigestAlgorithm.SHA256, uRL), SecurityHelper.digest(SecurityHelper$DigestAlgorithm.SHA256, path));
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean unpackZipNoCheck(URL uRL, Path path) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            return false;
        }
        Files.deleteIfExists(path);
        Files.createDirectory(path, new FileAttribute[0]);
        try (ZipInputStream zipInputStream = IOHelper.newZipInput(uRL);){
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                if (!zipEntry.isDirectory()) {
                    IOHelper.transfer((InputStream)zipInputStream, path.resolve(IOHelper.toPath(zipEntry.getName())));
                }
                zipEntry = zipInputStream.getNextEntry();
            }
        }
        return true;
    }

    public static void unpackZipNoCheck(String string, Path path) {
        try {
            if (Files.isDirectory(path, new LinkOption[0])) {
                return;
            }
            Files.deleteIfExists(path);
            Files.createDirectory(path, new FileAttribute[0]);
            try (ZipInputStream zipInputStream = IOHelper.newZipInput(IOHelper.getResourceURL(string));){
                ZipEntry zipEntry = zipInputStream.getNextEntry();
                while (zipEntry != null) {
                    if (!zipEntry.isDirectory()) {
                        IOHelper.transfer((InputStream)zipInputStream, path.resolve(IOHelper.toPath(zipEntry.getName())));
                    }
                    zipEntry = zipInputStream.getNextEntry();
                }
            }
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
    }
}

