/*
 * Decompiled with CFR 0.152.
 */
package oshi.driver.unix.solaris.kstat;

import com.sun.jna.platform.unix.solaris.LibKstat;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.software.os.unix.solaris.SolarisOperatingSystem;
import oshi.util.platform.unix.solaris.KstatUtil;
import oshi.util.tuples.Pair;

@ThreadSafe
public final class SystemPages {
    private SystemPages() {
    }

    public static Pair<Long, Long> queryAvailableTotal() {
        if (SolarisOperatingSystem.HAS_KSTAT2) {
            return SystemPages.queryAvailableTotal2();
        }
        long l = 0L;
        long l2 = 0L;
        try (KstatUtil.KstatChain kstatChain = KstatUtil.openChain();){
            LibKstat.Kstat kstat = kstatChain.lookup(null, -1, "system_pages");
            if (kstat != null && kstatChain.read(kstat)) {
                l = KstatUtil.dataLookupLong(kstat, "availrmem");
                l2 = KstatUtil.dataLookupLong(kstat, "physmem");
            }
        }
        return new Pair<Long, Long>(l, l2);
    }

    private static Pair<Long, Long> queryAvailableTotal2() {
        Object[] objectArray = KstatUtil.queryKstat2("kstat:/pages/unix/system_pages", "availrmem", "physmem");
        long l = objectArray[0] == null ? 0L : (Long)objectArray[0];
        long l2 = objectArray[1] == null ? 0L : (Long)objectArray[1];
        return new Pair<Long, Long>(l, l2);
    }
}

