/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.gui.recipes;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.drawable.IScalableDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawablesView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.inputs.IJeiGuiEventListener;
import mezz.jei.api.gui.inputs.IJeiInputHandler;
import mezz.jei.api.gui.inputs.RecipeSlotUnderMouse;
import mezz.jei.api.gui.placement.IPlaceable;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.IRecipeWidget;
import mezz.jei.api.gui.widgets.IScrollBoxWidget;
import mezz.jei.api.gui.widgets.IScrollGridWidget;
import mezz.jei.api.gui.widgets.ISlottedRecipeWidget;
import mezz.jei.api.gui.widgets.ITextWidget;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryDecorator;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.JeiTooltip;
import mezz.jei.common.gui.elements.DrawableAnimated;
import mezz.jei.common.gui.elements.DrawableCombined;
import mezz.jei.common.gui.elements.DrawableNineSliceTexture;
import mezz.jei.common.gui.elements.OffsetDrawable;
import mezz.jei.common.gui.elements.TextWidget;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.util.ImmutablePoint2i;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.MathUtil;
import mezz.jei.library.gui.ingredients.CycleTicker;
import mezz.jei.library.gui.recipes.RecipeLayoutInputHandler;
import mezz.jei.library.gui.recipes.ShapelessIcon;
import mezz.jei.library.gui.recipes.layout.builder.RecipeLayoutBuilder;
import mezz.jei.library.gui.widgets.ScrollBoxRecipeWidget;
import mezz.jei.library.gui.widgets.ScrollGridRecipeWidget;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_768;
import net.minecraft.class_8029;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class RecipeLayout<R>
implements IRecipeLayoutDrawable<R>,
IRecipeExtrasBuilder {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int DEFAULT_RECIPE_BORDER_PADDING = 4;
    public static final int RECIPE_BUTTON_SIZE = 13;
    public static final int RECIPE_BUTTON_SPACING = 2;
    private final IRecipeCategory<R> recipeCategory;
    private final Collection<IRecipeCategoryDecorator<R>> recipeCategoryDecorators;
    private final List<IRecipeSlotDrawable> recipeCategorySlots;
    private final @Unmodifiable List<IRecipeSlotDrawable> allSlots;
    private final List<IDrawable> drawables;
    private final List<ISlottedRecipeWidget> slottedWidgets;
    private final CycleTicker cycleTicker;
    private final IFocusGroup focuses;
    private final List<IRecipeWidget> allWidgets;
    private final R recipe;
    private final IScalableDrawable recipeBackground;
    private final int recipeBorderPadding;
    private final ImmutableRect2i recipeTransferButtonArea;
    @Nullable
    private final ShapelessIcon shapelessIcon;
    private final RecipeLayoutInputHandler<R> inputHandler;
    private ImmutableRect2i area;

    public static <T> Optional<IRecipeLayoutDrawable<T>> create(IRecipeCategory<T> recipeCategory, Collection<IRecipeCategoryDecorator<T>> decorators, T recipe, IFocusGroup focuses, IIngredientManager ingredientManager) {
        DrawableNineSliceTexture recipeBackground = Internal.getTextures().getRecipeBackground();
        return RecipeLayout.create(recipeCategory, decorators, recipe, focuses, ingredientManager, recipeBackground, 4);
    }

    public static <T> Optional<IRecipeLayoutDrawable<T>> create(IRecipeCategory<T> recipeCategory, Collection<IRecipeCategoryDecorator<T>> decorators, T recipe, IFocusGroup focuses, IIngredientManager ingredientManager, IScalableDrawable recipeBackground, int recipeBorderPadding) {
        RecipeLayoutBuilder<T> builder = new RecipeLayoutBuilder<T>(recipeCategory, recipe, ingredientManager);
        try {
            recipeCategory.setRecipe(builder, recipe, focuses);
            RecipeLayout<T> recipeLayout = builder.buildRecipeLayout(focuses, decorators, recipeBackground, recipeBorderPadding);
            recipeCategory.createRecipeExtras(recipeLayout, recipe, focuses);
            return Optional.of(recipeLayout);
        }
        catch (LinkageError | RuntimeException e) {
            LOGGER.error("Error caught from Recipe Category: {}", recipeCategory.getRecipeType(), (Object)e);
            return Optional.empty();
        }
    }

    public RecipeLayout(IRecipeCategory<R> recipeCategory, Collection<IRecipeCategoryDecorator<R>> recipeCategoryDecorators, R recipe, IScalableDrawable recipeBackground, int recipeBorderPadding, @Nullable ShapelessIcon shapelessIcon, ImmutablePoint2i recipeTransferButtonPos, List<IRecipeSlotDrawable> recipeCategorySlots, List<IRecipeSlotDrawable> allSlots, CycleTicker cycleTicker, IFocusGroup focuses) {
        this.recipeCategory = recipeCategory;
        this.recipeCategoryDecorators = recipeCategoryDecorators;
        this.drawables = new ArrayList<IDrawable>();
        this.slottedWidgets = new ArrayList<ISlottedRecipeWidget>();
        this.allWidgets = new ArrayList<IRecipeWidget>();
        this.cycleTicker = cycleTicker;
        this.focuses = focuses;
        this.inputHandler = new RecipeLayoutInputHandler(this);
        this.recipeCategorySlots = recipeCategorySlots;
        this.allSlots = Collections.unmodifiableList(allSlots);
        this.recipeBorderPadding = recipeBorderPadding;
        this.area = new ImmutableRect2i(0, 0, recipeCategory.getWidth(), recipeCategory.getHeight());
        this.recipeTransferButtonArea = new ImmutableRect2i(recipeTransferButtonPos.x(), recipeTransferButtonPos.y(), 13, 13);
        this.recipe = recipe;
        this.recipeBackground = recipeBackground;
        this.shapelessIcon = shapelessIcon;
        recipeCategory.onDisplayedIngredientsUpdate(recipe, Collections.unmodifiableList(recipeCategorySlots), focuses);
    }

    @Override
    public void setPosition(int posX, int posY) {
        this.area = this.area.setPosition(posX, posY);
    }

    @Override
    public void drawRecipe(class_332 guiGraphics, int mouseX, int mouseY) {
        IDrawable background = this.recipeCategory.getBackground();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.recipeBackground.draw(guiGraphics, this.getRectWithBorder());
        double recipeMouseX = mouseX - this.area.getX();
        double recipeMouseY = mouseY - this.area.getY();
        IRecipeSlotsView recipeCategorySlotsView = () -> Collections.unmodifiableList(this.recipeCategorySlots);
        class_4587 poseStack = guiGraphics.method_51448();
        poseStack.method_22903();
        poseStack.method_46416((float)this.area.getX(), (float)this.area.getY(), 0.0f);
        if (background != null) {
            background.draw(guiGraphics);
        }
        poseStack.method_22903();
        this.recipeCategory.draw(this.recipe, recipeCategorySlotsView, guiGraphics, recipeMouseX, recipeMouseY);
        for (IRecipeSlotDrawable iRecipeSlotDrawable : this.recipeCategorySlots) {
            iRecipeSlotDrawable.draw(guiGraphics);
        }
        for (IRecipeWidget iRecipeWidget : this.allWidgets) {
            class_8029 position = iRecipeWidget.getPosition();
            poseStack.method_22903();
            poseStack.method_46416((float)position.comp_1193(), (float)position.comp_1194(), 0.0f);
            iRecipeWidget.drawWidget(guiGraphics, recipeMouseX - (double)position.comp_1193(), recipeMouseY - (double)position.comp_1194());
            poseStack.method_22909();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.method_22909();
        for (IDrawable iDrawable : this.drawables) {
            poseStack.method_22903();
            iDrawable.draw(guiGraphics);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStack.method_22909();
        }
        for (IRecipeCategoryDecorator iRecipeCategoryDecorator : this.recipeCategoryDecorators) {
            poseStack.method_22903();
            iRecipeCategoryDecorator.draw(this.recipe, this.recipeCategory, recipeCategorySlotsView, guiGraphics, recipeMouseX, recipeMouseY);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStack.method_22909();
        }
        if (this.shapelessIcon != null) {
            this.shapelessIcon.draw(guiGraphics);
        }
        poseStack.method_22909();
        RenderSystem.disableBlend();
    }

    @Override
    public void drawOverlays(class_332 guiGraphics, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int recipeMouseX = mouseX - this.area.getX();
        int recipeMouseY = mouseY - this.area.getY();
        RenderSystem.disableBlend();
        IRecipeSlotsView recipeCategorySlotsView = () -> Collections.unmodifiableList(this.recipeCategorySlots);
        RecipeSlotUnderMouse hoveredSlotResult = this.getSlotUnderMouse(mouseX, mouseY).orElse(null);
        class_4587 poseStack = guiGraphics.method_51448();
        if (hoveredSlotResult != null) {
            IRecipeSlotDrawable hoveredSlot = hoveredSlotResult.slot();
            poseStack.method_22903();
            class_8029 offset = hoveredSlotResult.offset();
            poseStack.method_46416((float)offset.comp_1193(), (float)offset.comp_1194(), 0.0f);
            hoveredSlot.drawHoverOverlays(guiGraphics);
            poseStack.method_22909();
            JeiTooltip tooltip = new JeiTooltip();
            hoveredSlot.getTooltip(tooltip);
            tooltip.draw(guiGraphics, mouseX, mouseY);
        } else if (this.isMouseOver(mouseX, mouseY)) {
            JeiTooltip tooltip = new JeiTooltip();
            this.recipeCategory.getTooltip(tooltip, this.recipe, recipeCategorySlotsView, recipeMouseX, recipeMouseY);
            for (IRecipeCategoryDecorator<R> decorator : this.recipeCategoryDecorators) {
                decorator.decorateTooltips(tooltip, this.recipe, this.recipeCategory, recipeCategorySlotsView, recipeMouseX, recipeMouseY);
            }
            for (IRecipeWidget widget : this.allWidgets) {
                class_8029 position = widget.getPosition();
                widget.getTooltip(tooltip, recipeMouseX - position.comp_1193(), recipeMouseY - position.comp_1194());
            }
            if (tooltip.isEmpty() && this.shapelessIcon != null && this.shapelessIcon.isMouseOver(recipeMouseX, recipeMouseY)) {
                this.shapelessIcon.addTooltip(tooltip);
            }
            tooltip.draw(guiGraphics, mouseX, mouseY);
        }
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        return MathUtil.contains(this.area, mouseX, mouseY);
    }

    @Override
    public class_768 getRect() {
        return this.area.toMutable();
    }

    @Override
    public class_768 getRectWithBorder() {
        return this.area.expandBy(this.recipeBorderPadding).toMutable();
    }

    @Override
    public <T> Optional<T> getIngredientUnderMouse(int mouseX, int mouseY, IIngredientType<T> ingredientType) {
        return this.getSlotUnderMouse(mouseX, mouseY).map(RecipeSlotUnderMouse::slot).flatMap(slot -> slot.getDisplayedIngredient(ingredientType));
    }

    @Override
    public Optional<IRecipeSlotDrawable> getRecipeSlotUnderMouse(double mouseX, double mouseY) {
        return this.getSlotUnderMouse(mouseX, mouseY).map(RecipeSlotUnderMouse::slot);
    }

    @Override
    public Optional<RecipeSlotUnderMouse> getSlotUnderMouse(double mouseX, double mouseY) {
        double recipeMouseX = mouseX - (double)this.area.getX();
        double recipeMouseY = mouseY - (double)this.area.getY();
        for (ISlottedRecipeWidget widget : this.slottedWidgets) {
            double relativeMouseY;
            class_8029 position;
            double relativeMouseX;
            Optional<RecipeSlotUnderMouse> slotResult = widget.getSlotUnderMouse(relativeMouseX = recipeMouseX - (double)(position = widget.getPosition()).comp_1193(), relativeMouseY = recipeMouseY - (double)position.comp_1194());
            if (!slotResult.isPresent()) continue;
            return slotResult.map(slot -> slot.addOffset(this.area.x(), this.area.y()));
        }
        for (IRecipeSlotDrawable slot2 : this.recipeCategorySlots) {
            if (!slot2.isMouseOver(recipeMouseX, recipeMouseY)) continue;
            return Optional.of(new RecipeSlotUnderMouse(slot2, this.area.getScreenPosition()));
        }
        return Optional.empty();
    }

    @Override
    public IRecipeCategory<R> getRecipeCategory() {
        return this.recipeCategory;
    }

    @Override
    public class_768 getRecipeTransferButtonArea() {
        return this.recipeTransferButtonArea.toMutable();
    }

    @Override
    public class_768 getRecipeBookmarkButtonArea() {
        class_768 area = this.getRecipeTransferButtonArea();
        area.method_35779(area.method_3321(), area.method_3322() - area.method_3320() - 2);
        return area;
    }

    @Override
    public IRecipeSlotsView getRecipeSlotsView() {
        return () -> Collections.unmodifiableList(this.allSlots);
    }

    @Override
    public IRecipeSlotDrawablesView getRecipeSlots() {
        return () -> Collections.unmodifiableList(this.recipeCategorySlots);
    }

    @Override
    public R getRecipe() {
        return this.recipe;
    }

    @Override
    public IJeiInputHandler getInputHandler() {
        return this.inputHandler;
    }

    @Override
    public void tick() {
        for (IRecipeWidget widget : this.allWidgets) {
            widget.tick();
        }
        if (this.cycleTicker.tick()) {
            for (IRecipeSlotDrawable slot : this.recipeCategorySlots) {
                slot.clearDisplayOverrides();
            }
            this.recipeCategory.onDisplayedIngredientsUpdate(this.recipe, this.recipeCategorySlots, this.focuses);
        }
    }

    @Override
    public void addDrawable(IDrawable drawable, int xPos, int yPos) {
        this.drawables.add(OffsetDrawable.create(drawable, xPos, yPos));
    }

    @Override
    public IPlaceable<?> addDrawable(IDrawable drawable) {
        OffsetDrawable offsetDrawable = new OffsetDrawable(drawable, 0, 0);
        this.drawables.add(offsetDrawable);
        return offsetDrawable;
    }

    @Override
    public void addWidget(IRecipeWidget widget) {
        this.allWidgets.add(widget);
        if (widget instanceof ISlottedRecipeWidget) {
            ISlottedRecipeWidget slottedWidget = (ISlottedRecipeWidget)widget;
            this.slottedWidgets.add(slottedWidget);
        }
    }

    @Override
    public void addSlottedWidget(ISlottedRecipeWidget widget, List<IRecipeSlotDrawable> slots) {
        this.allWidgets.add(widget);
        this.slottedWidgets.add(widget);
        this.recipeCategorySlots.removeAll(slots);
    }

    @Override
    public void addInputHandler(IJeiInputHandler inputHandler) {
        this.inputHandler.addInputHandler(inputHandler);
    }

    @Override
    public void addGuiEventListener(IJeiGuiEventListener guiEventListener) {
        this.inputHandler.addGuiEventListener(guiEventListener);
    }

    @Override
    public IScrollBoxWidget addScrollBoxWidget(int width, int height, int xPos, int yPos) {
        ScrollBoxRecipeWidget widget = new ScrollBoxRecipeWidget(width, height, xPos, yPos);
        this.addWidget(widget);
        this.addInputHandler(widget);
        return widget;
    }

    @Override
    public IScrollGridWidget addScrollGridWidget(List<IRecipeSlotDrawable> slots, int columns, int visibleRows) {
        ScrollGridRecipeWidget widget = ScrollGridRecipeWidget.create(slots, columns, visibleRows);
        this.addSlottedWidget(widget, slots);
        this.addInputHandler(widget);
        return widget;
    }

    @Override
    public IPlaceable<?> addRecipeArrow() {
        Textures textures = Internal.getTextures();
        IDrawableStatic drawable = textures.getRecipeArrow();
        return this.addDrawable(drawable);
    }

    @Override
    public IPlaceable<?> addRecipePlusSign() {
        Textures textures = Internal.getTextures();
        IDrawableStatic drawable = textures.getRecipePlusSign();
        return this.addDrawable(drawable);
    }

    @Override
    public IPlaceable<?> addAnimatedRecipeArrow(int ticksPerCycle) {
        Textures textures = Internal.getTextures();
        IDrawableStatic recipeArrowFilled = textures.getRecipeArrowFilled();
        DrawableAnimated animatedFill = new DrawableAnimated(recipeArrowFilled, ticksPerCycle, IDrawableAnimated.StartDirection.LEFT, false);
        DrawableCombined drawableCombined = new DrawableCombined(textures.getRecipeArrow(), animatedFill);
        OffsetDrawable offsetDrawable = new OffsetDrawable(drawableCombined, 0, 0);
        return this.addDrawable(offsetDrawable);
    }

    @Override
    public IPlaceable<?> addAnimatedRecipeFlame(int cookTime) {
        Textures textures = Internal.getTextures();
        IDrawableStatic flameIcon = textures.getFlameIcon();
        DrawableAnimated animatedFill = new DrawableAnimated(flameIcon, cookTime, IDrawableAnimated.StartDirection.TOP, true);
        DrawableCombined drawableCombined = new DrawableCombined(textures.getFlameEmptyIcon(), animatedFill);
        OffsetDrawable offsetDrawable = new OffsetDrawable(drawableCombined, 0, 0);
        return this.addDrawable(offsetDrawable);
    }

    @Override
    public ITextWidget addText(List<class_5348> text, int maxWidth, int maxHeight) {
        TextWidget textWidget = new TextWidget(text, 0, 0, maxWidth, maxHeight);
        this.addWidget(textWidget);
        return textWidget;
    }
}

