/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.chatplus.features;

import com.ebicep.chatplus.config.Config;
import com.ebicep.chatplus.events.EventBus;
import com.ebicep.chatplus.features.chatwindows.ChatWindow;
import com.ebicep.chatplus.features.chatwindows.TabSettings;
import com.ebicep.chatplus.hud.ChatRenderer;
import com.ebicep.chatplus.hud.ChatScreenCloseEvent;
import com.ebicep.chatplus.hud.ChatScreenInitPostEvent;
import com.ebicep.chatplus.hud.RenderValidateYEvent;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0004B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/ebicep/chatplus/features/InputBoxAutoAdjustChatWindow;", "", "<init>", "()V", "WindowState", "chatplus-common"})
@SourceDebugExtension(value={"SMAP\nInputBoxAutoAdjustChatWindow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InputBoxAutoAdjustChatWindow.kt\ncom/ebicep/chatplus/features/InputBoxAutoAdjustChatWindow\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 EventBus.kt\ncom/ebicep/chatplus/events/EventBus\n*L\n1#1,80:1\n1863#2,2:81\n216#3,2:83\n216#3,2:85\n57#4,5:87\n57#4,5:92\n57#4,5:97\n*S KotlinDebug\n*F\n+ 1 InputBoxAutoAdjustChatWindow.kt\ncom/ebicep/chatplus/features/InputBoxAutoAdjustChatWindow\n*L\n32#1:81,2\n60#1:83,2\n67#1:85,2\n21#1:87,5\n59#1:92,5\n66#1:97,5\n*E\n"})
public final class InputBoxAutoAdjustChatWindow {
    @NotNull
    public static final InputBoxAutoAdjustChatWindow INSTANCE;

    private InputBoxAutoAdjustChatWindow() {
    }

    private static final Unit _init_$lambda$1(Ref.ObjectRef $adjusted, ChatScreenInitPostEvent it) {
        boolean bottomBar;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!Config.INSTANCE.getValues().getInputBoxAutoAdjustChatWindowEnabled()) {
            return Unit.INSTANCE;
        }
        int inputBoxStartY = Config.INSTANCE.getValues().getInputBoxSettings().getCalculatedStartY();
        int inputBoxMaxBottomY = class_310.method_1551().method_22683().method_4502() - 10;
        boolean topBar = inputBoxStartY == 4;
        boolean bl = bottomBar = inputBoxStartY == inputBoxMaxBottomY;
        if (!topBar && !bottomBar) {
            return Unit.INSTANCE;
        }
        Iterable $this$forEach$iv = Config.INSTANCE.getValues().getChatWindows();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int topY;
            ChatWindow it2 = (ChatWindow)element$iv;
            boolean bl2 = false;
            ChatRenderer renderer = it2.getRenderer();
            int internalY = renderer.getInternalY();
            if (bottomBar) {
                if (it2.getTabSettings().getPosition() == TabSettings.Position.BOTTOM) {
                    internalY += 15;
                }
                if (internalY <= inputBoxStartY) continue;
                int oldY = renderer.getInternalY();
                renderer.setInternalY(renderer.getInternalY() - (internalY - inputBoxStartY + 4));
                renderer.setRescaledY((float)renderer.getInternalY() / renderer.getScale());
                ((Map)$adjusted.element).put(it2, new WindowState(oldY, renderer.getInternalY()));
                continue;
            }
            if (it2.getTabSettings().getPosition() == TabSettings.Position.TOP) {
                internalY -= 15;
            }
            if ((topY = internalY - MathKt.roundToInt((float)renderer.getTotalLineHeight(true))) >= 14) continue;
            int oldY = renderer.getInternalY();
            renderer.setInternalY(renderer.getInternalY() + (14 - topY));
            renderer.setRescaledY((float)renderer.getInternalY() / renderer.getScale());
            ((Map)$adjusted.element).put(it2, new WindowState(oldY, renderer.getInternalY()));
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(Ref.ObjectRef $adjusted, RenderValidateYEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Map $this$forEach$iv = (Map)$adjusted.element;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            ChatWindow chatWindow = (ChatWindow)entry.getKey();
            WindowState amount = (WindowState)entry.getValue();
            if (!Intrinsics.areEqual((Object)it.getRenderer(), (Object)chatWindow.getRenderer())) continue;
            it.setInternalY(amount.getOldY());
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$5(Ref.ObjectRef $adjusted, ChatScreenCloseEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Map $this$forEach$iv = (Map)$adjusted.element;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            ChatWindow chatWindow = (ChatWindow)entry.getKey();
            WindowState amount = (WindowState)entry.getValue();
            if (chatWindow.getRenderer().getInternalY() != amount.getNewY()) continue;
            chatWindow.getRenderer().setInternalY(amount.getOldY());
            chatWindow.getRenderer().setRescaledY((float)amount.getOldY() / chatWindow.getRenderer().getScale());
        }
        ((Map)$adjusted.element).clear();
        return Unit.INSTANCE;
    }

    static {
        EventBus $this$iv;
        INSTANCE = new InputBoxAutoAdjustChatWindow();
        Ref.ObjectRef adjusted = new Ref.ObjectRef();
        adjusted.element = new LinkedHashMap();
        EventBus eventBus = EventBus.INSTANCE;
        Function1 callback$iv = arg_0 -> InputBoxAutoAdjustChatWindow._init_$lambda$1(adjusted, arg_0);
        Function0 priority$iv = EventBus.register.1.INSTANCE;
        Function0 skipOtherCallbacks$iv = EventBus.register.2.INSTANCE;
        boolean $i$f$register = false;
        $this$iv.register((Function0<Integer>)priority$iv, (Function0<Boolean>)skipOtherCallbacks$iv, ChatScreenInitPostEvent.class, callback$iv);
        $this$iv = EventBus.INSTANCE;
        callback$iv = arg_0 -> InputBoxAutoAdjustChatWindow._init_$lambda$3(adjusted, arg_0);
        priority$iv = EventBus.register.1.INSTANCE;
        skipOtherCallbacks$iv = EventBus.register.2.INSTANCE;
        $i$f$register = false;
        $this$iv.register((Function0<Integer>)priority$iv, (Function0<Boolean>)skipOtherCallbacks$iv, RenderValidateYEvent.class, callback$iv);
        $this$iv = EventBus.INSTANCE;
        callback$iv = arg_0 -> InputBoxAutoAdjustChatWindow._init_$lambda$5(adjusted, arg_0);
        priority$iv = EventBus.register.1.INSTANCE;
        skipOtherCallbacks$iv = EventBus.register.2.INSTANCE;
        $i$f$register = false;
        $this$iv.register((Function0<Integer>)priority$iv, (Function0<Boolean>)skipOtherCallbacks$iv, ChatScreenCloseEvent.class, callback$iv);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\bJ$\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\u000e\u001a\u00020\r2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0010\u0010\bJ\u0010\u0010\u0012\u001a\u00020\u0011H\u00d6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0014\u001a\u0004\b\u0015\u0010\bR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0014\u001a\u0004\b\u0016\u0010\b\u00a8\u0006\u0017"}, d2={"Lcom/ebicep/chatplus/features/InputBoxAutoAdjustChatWindow$WindowState;", "", "", "oldY", "newY", "<init>", "(II)V", "component1", "()I", "component2", "copy", "(II)Lcom/ebicep/chatplus/features/InputBoxAutoAdjustChatWindow$WindowState;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "I", "getOldY", "getNewY", "chatplus-common"})
    public static final class WindowState {
        private final int oldY;
        private final int newY;

        public WindowState(int oldY, int newY) {
            this.oldY = oldY;
            this.newY = newY;
        }

        public final int getOldY() {
            return this.oldY;
        }

        public final int getNewY() {
            return this.newY;
        }

        public final int component1() {
            return this.oldY;
        }

        public final int component2() {
            return this.newY;
        }

        @NotNull
        public final WindowState copy(int oldY, int newY) {
            return new WindowState(oldY, newY);
        }

        public static /* synthetic */ WindowState copy$default(WindowState windowState, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = windowState.oldY;
            }
            if ((n3 & 2) != 0) {
                n2 = windowState.newY;
            }
            return windowState.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "WindowState(oldY=" + this.oldY + ", newY=" + this.newY + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.oldY);
            result = result * 31 + Integer.hashCode(this.newY);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof WindowState)) {
                return false;
            }
            WindowState windowState = (WindowState)other;
            if (this.oldY != windowState.oldY) {
                return false;
            }
            return this.newY == windowState.newY;
        }
    }
}

