/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.chatplus.config.migration;

import com.ebicep.chatplus.ChatPlus;
import com.ebicep.chatplus.config.Config;
import com.ebicep.chatplus.config.ConfigKt;
import com.ebicep.chatplus.config.ConfigVariables;
import com.ebicep.chatplus.config.migration.Migrator;
import com.ebicep.chatplus.config.migration.V1;
import com.ebicep.chatplus.config.migration.V2;
import com.ebicep.chatplus.config.migration.V2_1;
import com.ebicep.chatplus.config.migration.V2_5;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\b\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\r\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\u0004\b\r\u0010\u000eR\u001e\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/ebicep/chatplus/config/migration/MigrationManager;", "", "<init>", "()V", "Ljava/io/File;", "configDirectory", "currentConfig", "", "tryMigration", "(Ljava/io/File;Ljava/io/File;)Z", "file", "newFile", "", "copyFile", "(Ljava/io/File;Ljava/io/File;)V", "", "Lcom/ebicep/chatplus/config/migration/Migrator;", "migrators", "Ljava/util/List;", "chatplus-common"})
@SourceDebugExtension(value={"SMAP\nMigrationManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MigrationManager.kt\ncom/ebicep/chatplus/config/migration/MigrationManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,54:1\n1863#2,2:55\n*S KotlinDebug\n*F\n+ 1 MigrationManager.kt\ncom/ebicep/chatplus/config/migration/MigrationManager\n*L\n22#1:55,2\n*E\n"})
public final class MigrationManager {
    @NotNull
    public static final MigrationManager INSTANCE = new MigrationManager();
    @NotNull
    private static final List<Migrator<?>> migrators;

    private MigrationManager() {
    }

    public final boolean tryMigration(@NotNull File configDirectory, @NotNull File currentConfig) {
        Intrinsics.checkNotNullParameter((Object)configDirectory, (String)"configDirectory");
        Intrinsics.checkNotNullParameter((Object)currentConfig, (String)"currentConfig");
        ChatPlus.INSTANCE.getLOGGER().info("Checking for config migration");
        Iterable $this$forEach$iv = migrators;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Migrator it = (Migrator)element$iv;
            boolean bl = false;
            String oldConfigFileName = it.getFileNameVersion() + ".json";
            File oldConfig = new File(configDirectory, oldConfigFileName);
            if (!oldConfig.exists()) continue;
            ChatPlus.INSTANCE.getLOGGER().info("Migrating config from " + oldConfigFileName + " to chatplus-v2.7.0.json");
            Config.INSTANCE.setValues((ConfigVariables)ConfigKt.getJson().decodeFromString((DeserializationStrategy)ConfigVariables.Companion.serializer(), FilesKt.readText$default((File)oldConfig, null, (int)1, null)));
            Object oldConfigValues = ConfigKt.getJson().decodeFromString((DeserializationStrategy)it.getSerializer(), FilesKt.readText$default((File)oldConfig, null, (int)1, null));
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.ebicep.chatplus.config.migration.Migrator<kotlin.Any?>");
            it.migrate(oldConfigValues);
            FilesKt.writeText$default((File)currentConfig, (String)ConfigKt.getJson().encodeToString((SerializationStrategy)ConfigVariables.Companion.serializer(), (Object)Config.INSTANCE.getValues()), null, (int)2, null);
            return true;
        }
        return false;
    }

    public final void copyFile(@NotNull File file, @NotNull File newFile) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)newFile, (String)"newFile");
        FilesKt.copyTo$default((File)file, (File)newFile, (boolean)false, (int)0, (int)6, null);
    }

    static {
        Object[] objectArray = new Migrator[]{V2_5.INSTANCE, V2_1.INSTANCE, V2.INSTANCE, V1.INSTANCE};
        migrators = CollectionsKt.listOf((Object[])objectArray);
    }
}

