/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.chatplus.config;

import com.ebicep.chatplus.ChatPlus;
import com.ebicep.chatplus.ChatPlusPlatformInit;
import com.ebicep.chatplus.config.ConfigDirectory;
import com.ebicep.chatplus.config.ConfigKt;
import com.ebicep.chatplus.config.ConfigVariables;
import com.ebicep.chatplus.config.migration.MigrationManager;
import com.ebicep.chatplus.features.FilterMessages;
import com.ebicep.chatplus.features.chatwindows.ChatWindowsManager;
import com.ebicep.chatplus.features.internal.MessageFilter;
import com.ebicep.chatplus.features.internal.MessageFilterFormatted;
import com.ebicep.chatplus.features.speechtotext.MicrophoneThread;
import com.ebicep.chatplus.features.speechtotext.SpeechToText;
import com.ebicep.chatplus.translator.Language;
import com.ebicep.chatplus.translator.LanguageManager;
import java.io.File;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\r\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0003J\u000f\u0010\u0007\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\u0003J\u000f\u0010\b\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\b\u0010\u0003R\"\u0010\n\u001a\u00020\t8F@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\"\u0010\u0011\u001a\u00020\u00108\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/ebicep/chatplus/config/Config;", "", "<init>", "()V", "", "save", "load", "loadValues", "correctValues", "Lcom/ebicep/chatplus/config/ConfigVariables;", "values", "Lcom/ebicep/chatplus/config/ConfigVariables;", "getValues", "()Lcom/ebicep/chatplus/config/ConfigVariables;", "setValues", "(Lcom/ebicep/chatplus/config/ConfigVariables;)V", "", "loaded", "Z", "getLoaded", "()Z", "setLoaded", "(Z)V", "chatplus-common"})
@SourceDebugExtension(value={"SMAP\nConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Config.kt\ncom/ebicep/chatplus/config/Config\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,317:1\n1863#2,2:318\n1863#2,2:320\n1863#2,2:322\n1#3:324\n*S KotlinDebug\n*F\n+ 1 Config.kt\ncom/ebicep/chatplus/config/Config\n*L\n92#1:318,2\n95#1:320,2\n100#1:322,2\n*E\n"})
public final class Config {
    @NotNull
    public static final Config INSTANCE = new Config();
    @NotNull
    private static ConfigVariables values = new ConfigVariables(false, false, false, false, false, false, 0, 0, 0, null, 0, 0, null, null, null, false, false, false, null, false, null, false, null, false, false, false, 0, null, null, null, null, null, false, false, 0, 0, null, false, false, false, 0, false, false, false, false, false, false, null, false, false, null, 0, 0, false, null, false, null, null, null, null, null, false, false, 0, null, false, 0, null, 0, false, 0, 0, null, false, null, null, false, false, false, false, 0, null, null, false, null, 0, false, false, null, null, false, null, null, false, 0.0f, false, false, false, null, 0, null, null, null, null, false, false, false, false, false, false, false, null, null, null, null, false, null, null, false, false, false, null, null, null, false, false, null, false, 0, null, -1, -1, -1, -1, 3, null);
    private static boolean loaded;

    private Config() {
    }

    @NotNull
    public final ConfigVariables getValues() {
        if (!ChatPlus.INSTANCE.getInitialized()) {
            ChatPlusPlatformInit.platformInit();
        }
        return values;
    }

    public final void setValues(@NotNull ConfigVariables configVariables) {
        Intrinsics.checkNotNullParameter((Object)configVariables, (String)"<set-?>");
        values = configVariables;
    }

    public final boolean getLoaded() {
        return loaded;
    }

    public final void setLoaded(boolean bl) {
        loaded = bl;
    }

    public final void save() {
        File configDirectory = new File(ConfigKt.getConfigDirectoryPath());
        if (!configDirectory.exists()) {
            configDirectory.mkdir();
        }
        File configFile = new File(configDirectory, "chatplus-v2.7.0.json");
        FilesKt.writeText$default((File)configFile, (String)ConfigKt.getJson().encodeToString((SerializationStrategy)ConfigVariables.Companion.serializer(), (Object)this.getValues()), null, (int)2, null);
    }

    public final void load() {
        File configFile;
        ChatPlus.INSTANCE.getLOGGER().info("Config Directory: " + ConfigDirectory.getConfigDirectory().toAbsolutePath().normalize() + "/chatplus");
        File configDirectory = new File(ConfigKt.getConfigDirectoryPath());
        if (!configDirectory.exists()) {
            configDirectory.mkdir();
        }
        if (!(configFile = new File(configDirectory, "chatplus-v2.7.0.json")).exists()) {
            ChatPlus.INSTANCE.getLOGGER().info("No config file found, checking migration");
            if (!MigrationManager.INSTANCE.tryMigration(configDirectory, configFile)) {
                ChatPlus.INSTANCE.getLOGGER().info("No migration found, creating new config");
                configFile.createNewFile();
                FilesKt.writeText$default((File)configFile, (String)ConfigKt.getJson().encodeToString((SerializationStrategy)ConfigVariables.Companion.serializer(), (Object)this.getValues()), null, (int)2, null);
            } else {
                ChatPlus.INSTANCE.getLOGGER().info("Reading migrated config");
                values = (ConfigVariables)ConfigKt.getJson().decodeFromString((DeserializationStrategy)ConfigVariables.Companion.serializer(), FilesKt.readText$default((File)configFile, null, (int)1, null));
            }
        } else {
            values = (ConfigVariables)ConfigKt.getJson().decodeFromString((DeserializationStrategy)ConfigVariables.Companion.serializer(), FilesKt.readText$default((File)configFile, null, (int)1, null));
        }
        this.correctValues();
        this.loadValues();
        loaded = true;
        ChatPlus.INSTANCE.getLOGGER().info("Config Loaded");
    }

    private final void loadValues() {
        MessageFilter it;
        Iterable $this$forEach$iv = this.getValues().getFilterMessagesPatterns();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (FilterMessages.Filter)element$iv;
            boolean bl = false;
            it.updateRegex();
        }
        $this$forEach$iv = this.getValues().getAutoBookMarkPatterns();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (MessageFilterFormatted)element$iv;
            boolean bl = false;
            it.updateRegex();
        }
        LanguageManager.INSTANCE.updateTranslateLanguages();
        SpeechToText.INSTANCE.updateTranslateLanguage();
        $this$forEach$iv = this.getValues().getSpeechToTextReplace();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (MicrophoneThread.SpeechToTextReplace)element$iv;
            boolean bl = false;
            it.updateRegex();
        }
        try {
            Intrinsics.checkNotNullExpressionValue((Object)Charset.forName(this.getValues().getSpeechToTextCharset()), (String)"forName(...)");
        }
        catch (Exception exception) {
            this.getValues().setSpeechToTextCharset("UTF-8");
        }
    }

    private final void correctValues() {
        this.getValues().setMaxCommandSuggestions(class_3532.method_15340((int)this.getValues().getMaxCommandSuggestions(), (int)10, (int)30));
        this.getValues().getInputBoxSettings().setMaxInputBoxInputLength(Math.max(1, this.getValues().getInputBoxSettings().getMaxInputBoxInputLength()));
        if (this.getValues().getChatWindows().isEmpty()) {
            this.getValues().getChatWindows().add(ChatWindowsManager.INSTANCE.createDefaultWindow());
        }
        Language it = LanguageManager.INSTANCE.findLanguageFromName(this.getValues().getTranslateTo());
        boolean bl = false;
        if (it == null) {
            INSTANCE.getValues().setTranslateTo("Auto Detect");
        }
        it = LanguageManager.INSTANCE.findLanguageFromName(this.getValues().getTranslateSelf());
        boolean bl2 = false;
        if (it == null) {
            INSTANCE.getValues().setTranslateSelf("Auto Detect");
        }
        it = LanguageManager.INSTANCE.findLanguageFromName(this.getValues().getTranslateSpeak());
        boolean bl3 = false;
        if (it == null) {
            INSTANCE.getValues().setTranslateSpeak("English");
        }
        it = LanguageManager.INSTANCE.findLanguageFromName(this.getValues().getSpeechToTextTranslateLang());
        boolean bl4 = false;
        if (it == null) {
            INSTANCE.getValues().setSpeechToTextTranslateLang("English");
        }
        this.save();
    }
}

