/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.rei.transfer;

import appeng.integration.modules.jeirei.EncodingHelper;
import appeng.menu.AEBaseMenu;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.SimpleGridMenuDisplay;
import net.minecraft.class_1860;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTransferHandler<T extends AEBaseMenu>
implements TransferHandler {
    protected static final int CRAFTING_GRID_WIDTH = 3;
    protected static final int CRAFTING_GRID_HEIGHT = 3;
    private static final CategoryIdentifier<?> CRAFTING = CategoryIdentifier.of((String)"minecraft", (String)"plugins/crafting");
    private final Class<T> containerClass;

    AbstractTransferHandler(Class<T> containerClass) {
        this.containerClass = containerClass;
    }

    protected abstract TransferHandler.Result transferRecipe(T var1, @Nullable class_1860<?> var2, Display var3, boolean var4);

    public final TransferHandler.Result handle(TransferHandler.Context context) {
        if (!this.containerClass.isInstance(context.getMenu())) {
            return TransferHandler.Result.createNotApplicable();
        }
        Display display = context.getDisplay();
        AEBaseMenu menu = (AEBaseMenu)((Object)this.containerClass.cast(context.getMenu()));
        class_1860<?> recipe = this.getRecipe(display);
        return this.transferRecipe(menu, recipe, display, context.isActuallyCrafting());
    }

    @Nullable
    private class_1860<?> getRecipe(Display display) {
        class_1860 recipe;
        Object origin = DisplayRegistry.getInstance().getDisplayOrigin(display);
        return origin instanceof class_1860 ? (recipe = (class_1860)origin) : null;
    }

    protected final boolean isCraftingRecipe(class_1860<?> recipe, Display display) {
        return EncodingHelper.isSupportedCraftingRecipe(recipe) || display.getCategoryIdentifier().equals(CRAFTING);
    }

    protected final boolean fitsIn3x3Grid(class_1860<?> recipe, Display display) {
        if (recipe != null) {
            return recipe.method_8113(3, 3);
        }
        if (display instanceof SimpleGridMenuDisplay) {
            SimpleGridMenuDisplay gridDisplay = (SimpleGridMenuDisplay)display;
            return gridDisplay.getWidth() <= 3 && gridDisplay.getHeight() <= 3;
        }
        return true;
    }
}

