/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jei;

import appeng.api.integrations.jei.IngredientConverter;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import java.util.Optional;
import mezz.jei.api.fabric.constants.FabricTypes;
import mezz.jei.api.fabric.ingredients.fluids.IJeiFluidIngredient;
import mezz.jei.api.ingredients.IIngredientType;
import net.minecraft.class_2487;
import net.minecraft.class_3611;
import org.jetbrains.annotations.Nullable;

public class FluidIngredientConverter
implements IngredientConverter<IJeiFluidIngredient> {
    @Override
    public IIngredientType<IJeiFluidIngredient> getIngredientType() {
        return FabricTypes.FLUID_STACK;
    }

    @Override
    @Nullable
    public IJeiFluidIngredient getIngredientFromStack(GenericStack stack) {
        AEKey aEKey = stack.what();
        if (aEKey instanceof AEFluidKey) {
            AEFluidKey fluidKey = (AEFluidKey)aEKey;
            return new Ingredient(fluidKey, Math.max(1L, stack.amount()));
        }
        return null;
    }

    @Override
    @Nullable
    public GenericStack getStackFromIngredient(IJeiFluidIngredient ingredient) {
        AEFluidKey key = AEFluidKey.of(ingredient.getFluid(), ingredient.getTag().orElse(null));
        return new GenericStack(key, ingredient.getAmount());
    }

    record Ingredient(AEFluidKey key, long amount) implements IJeiFluidIngredient
    {
        public class_3611 getFluid() {
            return this.key.getFluid();
        }

        public long getAmount() {
            return this.amount;
        }

        public Optional<class_2487> getTag() {
            return Optional.ofNullable(this.key.getTag());
        }
    }
}

