/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.cablebus;

import com.google.common.base.Preconditions;
import java.util.EnumMap;
import java.util.EnumSet;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.minecraft.class_1058;
import net.minecraft.class_2350;
import net.minecraft.class_765;
import org.joml.Vector4f;

@Environment(value=EnvType.CLIENT)
public class CubeBuilder {
    private final EnumMap<class_2350, class_1058> textures = new EnumMap(class_2350.class);
    private EnumSet<class_2350> drawFaces = EnumSet.allOf(class_2350.class);
    private final EnumMap<class_2350, Vector4f> customUv = new EnumMap(class_2350.class);
    private final byte[] uvRotations = new byte[class_2350.values().length];
    private final boolean[] flipU = new boolean[class_2350.values().length];
    private final boolean[] flipV = new boolean[class_2350.values().length];
    private int color = -1;
    private boolean emissiveMaterial;
    private final QuadEmitter emitter;

    public CubeBuilder(QuadEmitter emitter) {
        this.emitter = emitter;
    }

    public void addCube(float x1, float y1, float z1, float x2, float y2, float z2) {
        x1 /= 16.0f;
        y1 /= 16.0f;
        z1 /= 16.0f;
        x2 /= 16.0f;
        y2 /= 16.0f;
        z2 /= 16.0f;
        for (class_2350 face : this.drawFaces) {
            this.putFace(face, x1, y1, z1, x2, y2, z2);
        }
    }

    public void addQuad(class_2350 face, float x1, float y1, float z1, float x2, float y2, float z2) {
        this.putFace(face, x1, y1, z1, x2, y2, z2);
    }

    public void setFlipU(class_2350 side, boolean enable) {
        this.flipU[side.ordinal()] = enable;
    }

    public void setFlipV(class_2350 side, boolean enable) {
        this.flipV[side.ordinal()] = enable;
    }

    private void putFace(class_2350 face, float x1, float y1, float z1, float x2, float y2, float z2) {
        class_1058 texture = this.textures.get(face);
        QuadEmitter emitter = this.emitter;
        emitter.colorIndex(-1);
        UvVector uv = new UvVector();
        Vector4f customUv = this.customUv.get(face);
        if (customUv != null) {
            uv.u1 = texture.method_4580((double)customUv.x());
            uv.v1 = texture.method_4570((double)customUv.y());
            uv.u2 = texture.method_4580((double)customUv.z());
            uv.v2 = texture.method_4570((double)customUv.w());
        } else {
            uv = this.getStandardUv(face, texture, x1, y1, z1, x2, y2, z2);
        }
        emitter.color(this.color, this.color, this.color, this.color);
        emitter.normal(0, (float)face.method_10148(), (float)face.method_10164(), (float)face.method_10165());
        emitter.normal(1, (float)face.method_10148(), (float)face.method_10164(), (float)face.method_10165());
        emitter.normal(2, (float)face.method_10148(), (float)face.method_10164(), (float)face.method_10165());
        emitter.normal(3, (float)face.method_10148(), (float)face.method_10164(), (float)face.method_10165());
        this.setFaceUV(face, emitter, uv);
        switch (face) {
            case field_11033: {
                emitter.square(face, x1, z1, x2, z2, y1);
                break;
            }
            case field_11036: {
                emitter.square(face, x1, 1.0f - z2, x2, 1.0f - z1, 1.0f - y2);
                break;
            }
            case field_11043: {
                emitter.square(face, 1.0f - x2, y1, 1.0f - x1, y2, z1);
                break;
            }
            case field_11035: {
                emitter.square(face, x1, y1, x2, y2, 1.0f - z2);
                break;
            }
            case field_11039: {
                emitter.square(face, z1, y1, z2, y2, x1);
                break;
            }
            case field_11034: {
                emitter.square(face, 1.0f - z2, y1, 1.0f - z1, y2, 1.0f - x2);
            }
        }
        if (this.emissiveMaterial) {
            int lightmap = class_765.method_23687((int)15, (int)15);
            emitter.lightmap(lightmap, lightmap, lightmap, lightmap);
        }
        emitter.emit();
    }

    private void setFaceUV(class_2350 face, QuadEmitter emitter, UvVector uv) {
        float tmp;
        byte rotation = this.uvRotations[face.ordinal()];
        if (this.flipU[face.ordinal()]) {
            tmp = uv.u1;
            uv.u1 = uv.u2;
            uv.u2 = tmp;
        }
        if (this.flipV[face.ordinal()]) {
            tmp = uv.v1;
            uv.v1 = uv.v2;
            uv.v2 = tmp;
        }
        switch (face) {
            case field_11033: 
            case field_11036: {
                emitter.uv((4 - rotation) % 4, uv.u1, uv.v1);
                emitter.uv((5 - rotation) % 4, uv.u1, uv.v2);
                emitter.uv((6 - rotation) % 4, uv.u2, uv.v2);
                emitter.uv((7 - rotation) % 4, uv.u2, uv.v1);
                break;
            }
            case field_11043: 
            case field_11035: 
            case field_11039: 
            case field_11034: {
                emitter.uv((4 - rotation) % 4, uv.u1, uv.v2);
                emitter.uv((5 - rotation) % 4, uv.u1, uv.v1);
                emitter.uv((6 - rotation) % 4, uv.u2, uv.v1);
                emitter.uv((7 - rotation) % 4, uv.u2, uv.v2);
            }
        }
    }

    private UvVector getStandardUv(class_2350 face, class_1058 texture, float x1, float y1, float z1, float x2, float y2, float z2) {
        UvVector uv = new UvVector();
        if (face.method_10166() != class_2350.class_2351.field_11052) {
            uv.v1 = texture.method_4570((double)(16.0f - y1 * 16.0f));
            uv.v2 = texture.method_4570((double)(16.0f - y2 * 16.0f));
        } else {
            uv.v1 = texture.method_4570((double)(z1 * 16.0f));
            uv.v2 = texture.method_4570((double)(z2 * 16.0f));
        }
        switch (face) {
            case field_11033: 
            case field_11036: 
            case field_11035: {
                uv.u1 = texture.method_4580((double)(x1 * 16.0f));
                uv.u2 = texture.method_4580((double)(x2 * 16.0f));
                break;
            }
            case field_11043: {
                uv.u1 = texture.method_4580((double)(16.0f - x2 * 16.0f));
                uv.u2 = texture.method_4580((double)(16.0f - x1 * 16.0f));
                break;
            }
            case field_11039: {
                uv.u1 = texture.method_4580((double)(z1 * 16.0f));
                uv.u2 = texture.method_4580((double)(z2 * 16.0f));
                break;
            }
            case field_11034: {
                uv.u1 = texture.method_4580((double)(16.0f - z2 * 16.0f));
                uv.u2 = texture.method_4580((double)(16.0f - z1 * 16.0f));
            }
        }
        return uv;
    }

    public void setTexture(class_1058 texture) {
        for (class_2350 face : class_2350.values()) {
            this.textures.put(face, texture);
        }
    }

    public void setTextures(class_1058 up, class_1058 down, class_1058 north, class_1058 south, class_1058 east, class_1058 west) {
        this.textures.put(class_2350.field_11036, up);
        this.textures.put(class_2350.field_11033, down);
        this.textures.put(class_2350.field_11043, north);
        this.textures.put(class_2350.field_11035, south);
        this.textures.put(class_2350.field_11034, east);
        this.textures.put(class_2350.field_11039, west);
    }

    public void setTexture(class_2350 facing, class_1058 sprite) {
        this.textures.put(facing, sprite);
    }

    public void setDrawFaces(EnumSet<class_2350> drawFaces) {
        this.drawFaces = drawFaces;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setColorRGB(int color) {
        this.setColor(color | 0xFF000000);
    }

    public void setColorRGB(float r, float g, float b) {
        this.setColorRGB((int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f));
    }

    public void setEmissiveMaterial(boolean renderFullBright) {
        this.emissiveMaterial = renderFullBright;
    }

    public void setCustomUv(class_2350 facing, float u1, float v1, float u2, float v2) {
        this.customUv.put(facing, new Vector4f(u1, v1, u2, v2));
    }

    public void setUvRotation(class_2350 facing, int rotation) {
        Preconditions.checkArgument((rotation >= 0 && rotation <= 3 ? 1 : 0) != 0, (Object)"rotation");
        this.uvRotations[facing.ordinal()] = (byte)rotation;
    }

    private static final class UvVector {
        float u1;
        float u2;
        float v1;
        float v2;

        private UvVector() {
        }
    }
}

