/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render;

import appeng.api.client.AEKeyRendering;
import appeng.api.stacks.AmountFormat;
import appeng.api.stacks.GenericStack;
import appeng.client.gui.me.common.StackSizeRenderer;
import appeng.core.localization.GuiText;
import appeng.items.storage.StorageCellTooltipComponent;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_5684;
import org.joml.Matrix4f;

public class StorageCellClientTooltipComponent
implements class_5684 {
    private final StorageCellTooltipComponent tooltipComponent;
    private final class_2561 upgradesLabel;

    public StorageCellClientTooltipComponent(StorageCellTooltipComponent tooltipComponent) {
        this.tooltipComponent = tooltipComponent;
        this.upgradesLabel = GuiText.StorageCellTooltipUpgrades.text();
    }

    public int method_32661() {
        List<GenericStack> content;
        int height = 0;
        List<class_1799> upgrades = this.tooltipComponent.upgrades();
        if (!upgrades.isEmpty()) {
            height += 17;
        }
        if (!(content = this.tooltipComponent.content()).isEmpty()) {
            height += 17;
        }
        return height;
    }

    public int method_32664(class_327 font) {
        List<class_1799> upgrades;
        int width = 0;
        List<GenericStack> content = this.tooltipComponent.content();
        if (!content.isEmpty()) {
            int filterWidth = content.size() * 17;
            if (this.tooltipComponent.hasMoreContent()) {
                filterWidth += 10;
            }
            width = Math.max(width, filterWidth);
        }
        if (!(upgrades = this.tooltipComponent.upgrades()).isEmpty()) {
            int upgradesWidth = font.method_27525((class_5348)this.upgradesLabel) + 2 + 17 * upgrades.size();
            width = Math.max(width, upgradesWidth);
        }
        return width;
    }

    public void method_32665(class_327 font, int x, int y, Matrix4f matrix4f, class_4597.class_4598 bufferSource) {
        List<class_1799> upgrades;
        Objects.requireNonNull(font);
        int yoff = (16 - 9) / 2;
        List<GenericStack> content = this.tooltipComponent.content();
        if (!content.isEmpty()) {
            int xoff = content.size() * 17;
            if (this.tooltipComponent.hasMoreContent()) {
                font.method_27521("\u2026", (float)(x + xoff + 2), (float)(y + 2), -1, false, matrix4f, (class_4597)bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
            }
            y += 17;
        }
        if (!(upgrades = this.tooltipComponent.upgrades()).isEmpty()) {
            font.method_30882(this.upgradesLabel, (float)x, (float)(y + yoff), 0x7E7E7E, false, matrix4f, (class_4597)bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
        }
    }

    public void method_32666(class_327 font, int x, int y, class_332 guiGraphics) {
        List<class_1799> upgrades;
        List<GenericStack> content = this.tooltipComponent.content();
        if (!content.isEmpty()) {
            int xoff = 0;
            for (GenericStack stack : content) {
                AEKeyRendering.drawInGui(class_310.method_1551(), guiGraphics, x + xoff, y, stack.what());
                xoff += 17;
            }
            if (this.tooltipComponent.showAmounts()) {
                xoff = 0;
                for (GenericStack stack : content) {
                    String amtText = stack.what().formatAmount(stack.amount(), AmountFormat.SLOT);
                    StackSizeRenderer.renderSizeLabel(guiGraphics, font, (float)(x + xoff), (float)y, amtText, false);
                    xoff += 17;
                }
            }
            y += 17;
        }
        if (!(upgrades = this.tooltipComponent.upgrades()).isEmpty()) {
            int xoff = font.method_27525((class_5348)this.upgradesLabel) + 2;
            for (class_1799 upgrade : upgrades) {
                guiGraphics.method_51427(upgrade, x + xoff, y);
                xoff += 17;
            }
        }
    }
}

