/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.powersink;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.networking.energy.IAEPowerStorage;
import appeng.api.networking.events.GridPowerStorageStateChanged;
import appeng.blockentity.AEBaseInvBlockEntity;
import appeng.blockentity.powersink.IExternalPowerSink;
import appeng.helpers.ForgeEnergyAdapter;
import appeng.me.energy.StoredEnergyAmount;
import com.google.common.collect.ImmutableSet;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;

public abstract class AEBasePoweredBlockEntity
extends AEBaseInvBlockEntity
implements IAEPowerStorage,
IExternalPowerSink {
    private boolean internalPublicPowerStorage = false;
    private AccessRestriction internalPowerFlow = AccessRestriction.READ_WRITE;
    private final StoredEnergyAmount stored = new StoredEnergyAmount(0.0, 10000.0, this::emitPowerStateEvent);
    private static final Set<class_2350> ALL_SIDES = ImmutableSet.copyOf(EnumSet.allOf(class_2350.class));
    private Set<class_2350> internalPowerSides = ALL_SIDES;
    private final EnergyStorage forgeEnergyAdapter = new ForgeEnergyAdapter(this);

    public AEBasePoweredBlockEntity(class_2591<?> blockEntityType, class_2338 pos, class_2680 blockState) {
        super(blockEntityType, pos, blockState);
    }

    protected final Set<class_2350> getPowerSides() {
        return this.internalPowerSides;
    }

    protected void setPowerSides(Set<class_2350> sides) {
        this.internalPowerSides = ImmutableSet.copyOf(sides);
    }

    @Override
    public void method_11007(class_2487 data) {
        super.method_11007(data);
        data.method_10549("internalCurrentPower", this.getInternalCurrentPower());
    }

    @Override
    public void loadTag(class_2487 data) {
        super.loadTag(data);
        this.setInternalCurrentPower(data.method_10574("internalCurrentPower"));
    }

    @Override
    public final double getExternalPowerDemand(PowerUnits externalUnit, double maxPowerRequired) {
        return PowerUnits.AE.convertTo(externalUnit, Math.max(0.0, this.getFunnelPowerDemand(externalUnit.convertTo(PowerUnits.AE, maxPowerRequired))));
    }

    protected double getFunnelPowerDemand(double maxRequired) {
        return this.getInternalMaxPower() - this.getInternalCurrentPower();
    }

    @Override
    public final double injectExternalPower(PowerUnits input, double amt, Actionable mode) {
        return PowerUnits.AE.convertTo(input, this.funnelPowerIntoStorage(input.convertTo(PowerUnits.AE, amt), mode));
    }

    protected double funnelPowerIntoStorage(double power, Actionable mode) {
        return this.injectAEPower(power, mode);
    }

    @Override
    public final double injectAEPower(double amt, Actionable mode) {
        return amt - this.stored.insert(amt, mode == Actionable.MODULATE);
    }

    protected void emitPowerStateEvent(GridPowerStorageStateChanged.PowerEventType x) {
    }

    @Override
    public final double getAEMaxPower() {
        return this.getInternalMaxPower();
    }

    @Override
    public final double getAECurrentPower() {
        return this.getInternalCurrentPower();
    }

    @Override
    public final boolean isAEPublicPowerStorage() {
        return this.isInternalPublicPowerStorage();
    }

    @Override
    public final AccessRestriction getPowerFlow() {
        return this.getInternalPowerFlow();
    }

    @Override
    public final double extractAEPower(double amt, Actionable mode, PowerMultiplier multiplier) {
        return multiplier.divide(this.extractAEPower(multiplier.multiply(amt), mode));
    }

    protected double extractAEPower(double amt, Actionable mode) {
        return this.stored.extract(amt, mode == Actionable.MODULATE);
    }

    public double getInternalCurrentPower() {
        return this.stored.getAmount();
    }

    public void setInternalCurrentPower(double internalCurrentPower) {
        this.stored.setStored(internalCurrentPower);
    }

    public double getInternalMaxPower() {
        return this.stored.getMaximum();
    }

    public void setInternalMaxPower(double internalMaxPower) {
        this.stored.setMaximum(internalMaxPower);
    }

    private boolean isInternalPublicPowerStorage() {
        return this.internalPublicPowerStorage;
    }

    public void setInternalPublicPowerStorage(boolean internalPublicPowerStorage) {
        this.internalPublicPowerStorage = internalPublicPowerStorage;
    }

    private AccessRestriction getInternalPowerFlow() {
        return this.internalPowerFlow;
    }

    public void setInternalPowerFlow(AccessRestriction internalPowerFlow) {
        this.internalPowerFlow = internalPowerFlow;
    }

    @Nullable
    public EnergyStorage getEnergyStorage(class_2350 direction) {
        if (this.getPowerSides().contains(direction)) {
            return this.forgeEnergyAdapter;
        }
        return null;
    }
}

