/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.orientation;

import appeng.api.orientation.BlockOrientation;
import appeng.api.orientation.IOrientableBlock;
import appeng.api.orientation.OrientationStrategies;
import appeng.api.orientation.RelativeSide;
import appeng.block.orientation.SpinMapping;
import java.util.Collection;
import java.util.stream.Stream;
import net.minecraft.class_1750;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2758;
import net.minecraft.class_2769;

public interface IOrientationStrategy {
    public static final class_2758 SPIN = class_2758.method_11867((String)"spin", (int)0, (int)3);

    public static IOrientationStrategy get(class_2680 state) {
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof IOrientableBlock) {
            IOrientableBlock orientableBlock = (IOrientableBlock)class_22482;
            return orientableBlock.getOrientationStrategy();
        }
        return OrientationStrategies.none();
    }

    default public class_2350 getFacing(class_2680 state) {
        return class_2350.field_11043;
    }

    default public int getSpin(class_2680 state) {
        return 0;
    }

    default public class_2680 setFacing(class_2680 state, class_2350 facing) {
        return state;
    }

    default public class_2680 setSpin(class_2680 state, int spin) {
        return state;
    }

    default public class_2680 setUp(class_2680 state, class_2350 up) {
        class_2350 facing = this.getFacing(state);
        int spin = SpinMapping.getSpinFromUp(facing, up);
        return this.setSpin(state, spin);
    }

    default public class_2680 setOrientation(class_2680 state, class_2350 facing, int spin) {
        return this.setSpin(this.setFacing(state, facing), spin);
    }

    default public class_2680 setOrientation(class_2680 state, class_2350 facing, class_2350 up) {
        return this.setUp(this.setFacing(state, facing), up);
    }

    default public class_2350 getSide(class_2680 state, RelativeSide side) {
        return BlockOrientation.get(this, state).rotate(side.getUnrotatedSide());
    }

    default public class_2680 getStateForPlacement(class_2680 state, class_1750 context) {
        return state;
    }

    default public Stream<class_2680> getAllStates(class_2680 baseState) {
        Stream<class_2680> result = Stream.of(baseState);
        for (class_2769<?> property : this.getProperties()) {
            result = IOrientationStrategy.enumerateValues(result, property);
        }
        return result;
    }

    default public boolean allowsPlayerRotation() {
        return true;
    }

    public Collection<class_2769<?>> getProperties();

    private static <T extends Comparable<T>> Stream<class_2680> enumerateValues(Stream<class_2680> stream, class_2769<T> property) {
        return stream.flatMap(baseState -> property.method_11898().stream().map(value -> (class_2680)baseState.method_11657(property, value)));
    }
}

