/*
 * Decompiled with CFR 0.152.
 */
package appbot.item.cell;

import appbot.ae2.ManaKey;
import appbot.ae2.ManaKeyType;
import appbot.item.cell.IManaCellItem;
import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.ISaveProvider;
import appeng.api.storage.cells.StorageCell;
import appeng.core.definitions.AEItems;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public class ManaCellInventory
implements StorageCell {
    private static final String AMOUNT = "amount";
    private final IManaCellItem cellType;
    private final class_1799 i;
    @Nullable
    private final ISaveProvider container;
    private final boolean hasVoidUpgrade;
    private long storedMana;
    private boolean isPersisted = true;

    public ManaCellInventory(IManaCellItem cellType, class_1799 o, @Nullable ISaveProvider container) {
        this.cellType = cellType;
        this.i = o;
        this.container = container;
        this.storedMana = this.getTag().method_10537(AMOUNT);
        this.hasVoidUpgrade = cellType.getUpgrades(o).isInstalled((class_1935)AEItems.VOID_CARD);
    }

    private class_2487 getTag() {
        return this.i.method_7948();
    }

    public CellState getStatus() {
        if (this.storedMana == 0L) {
            return CellState.EMPTY;
        }
        if (this.storedMana == this.getMaxMana()) {
            return CellState.FULL;
        }
        if (this.storedMana > this.getMaxMana() / 2L) {
            return CellState.TYPES_FULL;
        }
        return CellState.NOT_EMPTY;
    }

    public double getIdleDrain() {
        return this.cellType.getIdleDrain();
    }

    private long getMaxMana() {
        return this.cellType.getTotalBytes() * (long)ManaKeyType.TYPE.getAmountPerByte();
    }

    protected long getTotalBytes() {
        return this.cellType.getTotalBytes();
    }

    protected long getUsedBytes() {
        int amountPerByte = ManaKeyType.TYPE.getAmountPerByte();
        return (this.storedMana + (long)amountPerByte - 1L) / (long)amountPerByte;
    }

    protected void saveChanges() {
        this.isPersisted = false;
        if (this.container != null) {
            this.container.saveChanges();
        } else {
            this.persist();
        }
    }

    public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
        if (!(what instanceof ManaKey)) {
            return 0L;
        }
        long inserted = Math.min(this.getMaxMana() - this.storedMana, amount);
        if (mode == Actionable.MODULATE) {
            this.storedMana += inserted;
            this.saveChanges();
        }
        return this.hasVoidUpgrade ? amount : inserted;
    }

    public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
        if (!(what instanceof ManaKey)) {
            return 0L;
        }
        long extracted = Math.min(this.storedMana, amount);
        if (mode == Actionable.MODULATE) {
            this.storedMana -= extracted;
            this.saveChanges();
        }
        return extracted;
    }

    public void persist() {
        if (this.isPersisted) {
            return;
        }
        if (this.storedMana <= 0L) {
            this.getTag().method_10551(AMOUNT);
        } else {
            this.getTag().method_10544(AMOUNT, this.storedMana);
        }
        this.isPersisted = true;
    }

    public void getAvailableStacks(KeyCounter out) {
        if (this.storedMana > 0L) {
            out.add(ManaKey.KEY, this.storedMana);
        }
    }

    public class_2561 getDescription() {
        return this.i.method_7964();
    }
}

