/*
 * Decompiled with CFR 0.152.
 */
package appbot.block;

import appbot.AppliedBotanics;
import appbot.ae2.ManaKey;
import appbot.mixins.ManaPoolBlockEntityAccessor;
import appeng.api.config.Actionable;
import appeng.api.networking.GridFlags;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import appeng.api.util.AECableType;
import appeng.hooks.ticking.TickHandler;
import appeng.me.InWorldGridNode;
import appeng.me.helpers.BlockEntityNodeListener;
import appeng.me.helpers.IGridConnectedBlockEntity;
import com.google.common.primitives.Ints;
import java.util.EnumSet;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.block.block_entity.mana.ManaPoolBlockEntity;

public class FluixPoolBlockEntity
extends ManaPoolBlockEntity
implements IInWorldGridNodeHost,
IGridConnectedBlockEntity {
    private final ManaPoolBlockEntityAccessor mana = (ManaPoolBlockEntityAccessor)((Object)this);
    private final IManagedGridNode mainNode = GridHelper.createManagedNode((Object)((Object)this), (IGridNodeListener)BlockEntityNodeListener.INSTANCE).setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL}).setVisualRepresentation((class_1935)AppliedBotanics.getInstance().fluixManaPool()).setInWorldNode(true).setExposedOnSides(EnumSet.complementOf(EnumSet.of(class_2350.field_11036))).setTagName("proxy");
    private final IActionSource actionSource = IActionSource.ofMachine(() -> ((IManagedGridNode)this.mainNode).getNode());
    private boolean saving;
    private boolean setChangedQueued = false;

    public FluixPoolBlockEntity(@NotNull class_2338 pos, @NotNull class_2680 state) {
        super(pos, state);
    }

    public boolean isFull() {
        IGrid grid = this.getMainNode().getGrid();
        if (grid == null || !this.getMainNode().isActive()) {
            return true;
        }
        return grid.getStorageService().getInventory().insert(ManaKey.KEY, 1L, Actionable.SIMULATE, this.actionSource) == 0L;
    }

    public void receiveMana(int mana) {
        IGrid grid = this.getMainNode().getGrid();
        if (grid == null || !this.getMainNode().isActive()) {
            return;
        }
        MEStorage storage = grid.getStorageService().getInventory();
        boolean changed = false;
        if (mana > 0) {
            changed = StorageHelper.poweredInsert((IEnergySource)grid.getEnergyService(), (MEStorage)storage, (AEKey)ManaKey.KEY, (long)mana, (IActionSource)this.actionSource) != 0L;
        } else if (mana < 0) {
            boolean bl = changed = StorageHelper.poweredExtraction((IEnergySource)grid.getEnergyService(), (MEStorage)storage, (AEKey)ManaKey.KEY, (long)(-mana), (IActionSource)this.actionSource) != 0L;
        }
        if (changed) {
            this.method_5431();
            this.markDispatchable();
        }
    }

    public int getCurrentMana() {
        IGrid grid = this.getMainNode().getGrid();
        if (grid == null || this.saving) {
            return this.mana.getMana();
        }
        if (!this.getMainNode().isActive()) {
            return 0;
        }
        return (int)grid.getStorageService().getInventory().extract(ManaKey.KEY, Integer.MAX_VALUE, Actionable.SIMULATE, this.actionSource);
    }

    public int getMaxMana() {
        long manaCap;
        IGrid grid = this.getMainNode().getGrid();
        if (grid == null || this.saving) {
            return super.getMaxMana();
        }
        int oldMana = this.mana.getMana();
        int oldManaCap = super.getMaxMana();
        if (this.getMainNode().isActive()) {
            MEStorage storage = grid.getStorageService().getInventory();
            this.mana.setMana((int)storage.extract(ManaKey.KEY, Integer.MAX_VALUE, Actionable.SIMULATE, this.actionSource));
            manaCap = storage.extract(ManaKey.KEY, Integer.MAX_VALUE, Actionable.SIMULATE, this.actionSource) + storage.insert(ManaKey.KEY, Integer.MAX_VALUE, Actionable.SIMULATE, this.actionSource);
        } else {
            this.mana.setMana(0);
            manaCap = 0L;
        }
        if (oldMana != this.mana.getMana() || (long)oldManaCap != manaCap) {
            this.method_5431();
            this.markDispatchable();
        }
        return Ints.saturatedCast((long)manaCap);
    }

    public void method_11007(class_2487 tag) {
        try {
            this.saving = true;
            super.method_11007(tag);
        }
        finally {
            this.saving = false;
        }
        this.getMainNode().saveToNBT(tag);
    }

    public void method_11014(@NotNull class_2487 tag) {
        super.method_11014(tag);
        this.getMainNode().loadFromNBT(tag);
    }

    @Nullable
    public IGridNode getGridNode(class_2350 dir) {
        InWorldGridNode inWorldNode;
        IGridNode node = this.getMainNode().getNode();
        return node instanceof InWorldGridNode && (inWorldNode = (InWorldGridNode)node).isExposedOnSide(dir) ? node : null;
    }

    public AECableType getCableConnectionType(class_2350 dir) {
        return AECableType.SMART;
    }

    public IManagedGridNode getMainNode() {
        return this.mainNode;
    }

    public void saveChanges() {
        if (this.field_11863 == null) {
            return;
        }
        if (this.field_11863.field_9236) {
            this.method_5431();
        } else {
            this.field_11863.method_8524(this.field_11867);
            if (!this.setChangedQueued) {
                TickHandler.instance().addCallable(null, this::setChangedAtEndOfTick);
                this.setChangedQueued = true;
            }
        }
    }

    private void setChangedAtEndOfTick() {
        this.method_5431();
        this.setChangedQueued = false;
    }

    public void onChunkUnloaded() {
        this.getMainNode().destroy();
    }

    public void onReady() {
        this.getMainNode().create(this.method_10997(), this.method_11016());
    }

    public void method_11012() {
        super.method_11012();
        this.getMainNode().destroy();
    }

    public void method_10996() {
        super.method_10996();
        GridHelper.onFirstTick((class_2586)this, FluixPoolBlockEntity::onReady);
    }

    public int calculateComparatorLevel() {
        long freeMana;
        long currentMana;
        IGrid grid = this.getMainNode().getGrid();
        if (grid == null) {
            currentMana = this.mana.getMana();
            freeMana = (long)super.getMaxMana() - currentMana;
        } else if (!this.getMainNode().isActive()) {
            currentMana = 0L;
            freeMana = 0L;
        } else {
            MEStorage storage = grid.getStorageService().getInventory();
            currentMana = storage.extract(ManaKey.KEY, Long.MAX_VALUE, Actionable.SIMULATE, this.actionSource);
            freeMana = storage.insert(ManaKey.KEY, Long.MAX_VALUE, Actionable.SIMULATE, this.actionSource);
        }
        if (currentMana == 0L) {
            return 0;
        }
        return (int)Math.ceil(1.0 / (1.0 + (double)freeMana / (double)currentMana) * 15.0);
    }
}

