/*
 * Decompiled with CFR 0.152.
 */
package appbot.ae2;

import appbot.AppliedBotanics;
import appbot.Lookup;
import appbot.ae2.ManaHelper;
import appbot.ae2.ManaKey;
import appbot.ae2.ManaKeyType;
import appeng.api.behaviors.ExternalStorageStrategy;
import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import appeng.core.localization.GuiText;
import com.google.common.primitives.Ints;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.mana.ManaReceiver;

public class ManaExternalStorageStrategy
implements ExternalStorageStrategy {
    private final Lookup<ManaReceiver, class_2350> apiCache;
    private final class_2350 fromSide;

    public ManaExternalStorageStrategy(class_3218 level, class_2338 fromPos, class_2350 fromSide) {
        this.apiCache = AppliedBotanics.getInstance().manaReceiver(level, fromPos);
        this.fromSide = fromSide;
    }

    @Nullable
    public MEStorage createWrapper(boolean extractableOnly, Runnable injectOrExtractCallback) {
        ManaReceiver receiver = this.apiCache.find(this.fromSide);
        if (receiver == null) {
            return null;
        }
        return new ManaStorageAdapter(receiver, injectOrExtractCallback);
    }

    private record ManaStorageAdapter(ManaReceiver receiver, Runnable changeListener) implements MEStorage
    {
        public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
            if (!(what instanceof ManaKey)) {
                return 0L;
            }
            if (this.receiver.isFull()) {
                return 0L;
            }
            int amt = Ints.saturatedCast((long)amount);
            int prevMana = this.receiver.getCurrentMana();
            if (mode != Actionable.MODULATE) {
                return Math.min(amt, ManaHelper.getCapacity(this.receiver) - prevMana);
            }
            this.receiver.receiveMana(amt);
            int inserted = Math.abs(this.receiver.getCurrentMana() - prevMana);
            if (inserted == 0) {
                inserted = amt;
            }
            if (inserted > 0) {
                this.changeListener.run();
            }
            return inserted;
        }

        public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
            if (!(what instanceof ManaKey)) {
                return 0L;
            }
            int extracted = (int)Math.min(amount, (long)this.receiver.getCurrentMana());
            if (extracted > 0 && mode == Actionable.MODULATE) {
                this.receiver.receiveMana(-extracted);
                this.changeListener.run();
            }
            return extracted;
        }

        public void getAvailableStacks(KeyCounter out) {
            int currentMana = this.receiver.getCurrentMana();
            if (currentMana != 0) {
                out.add(ManaKey.KEY, (long)currentMana);
            }
        }

        public class_2561 getDescription() {
            return GuiText.ExternalStorage.text(new Object[]{ManaKeyType.TYPE.getDescription()});
        }
    }
}

