/*
 * Decompiled with CFR 0.152.
 */
package appbot.ae2;

import appbot.ae2.ManaKey;
import appeng.api.config.Actionable;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageCells;
import appeng.api.storage.StorageHelper;
import appeng.api.storage.cells.StorageCell;
import appeng.items.tools.powered.AbstractPortableCell;
import com.google.common.primitives.Ints;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2586;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.mana.ManaItem;

public class MEStorageManaItem
implements ManaItem {
    private final MEStorage storage;
    private final IEnergySource energy;
    private final IActionSource source;

    public MEStorageManaItem(MEStorage storage, IEnergySource energy, IActionSource source) {
        this.storage = storage;
        this.energy = energy;
        this.source = source;
    }

    @Nullable
    public static ManaItem forItem(class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof AbstractPortableCell) {
            AbstractPortableCell item = (AbstractPortableCell)class_17922;
            StorageCell storage = StorageCells.getCellInventory((class_1799)stack, null);
            if (storage == null) {
                return null;
            }
            return new MEStorageManaItem((MEStorage)storage, (amount, mode, multiplier) -> {
                amount = multiplier.multiply(amount);
                if (mode == Actionable.SIMULATE) {
                    return multiplier.divide(Math.min(amount, item.getAECurrentPower(stack)));
                }
                return multiplier.divide(item.extractAEPower(stack, amount, Actionable.MODULATE));
            }, IActionSource.empty());
        }
        return null;
    }

    public int getMana() {
        return (int)StorageHelper.poweredExtraction((IEnergySource)this.energy, (MEStorage)this.storage, (AEKey)ManaKey.KEY, (long)Integer.MAX_VALUE, (IActionSource)this.source, (Actionable)Actionable.SIMULATE);
    }

    public int getMaxMana() {
        return Ints.saturatedCast((long)(StorageHelper.poweredExtraction((IEnergySource)this.energy, (MEStorage)this.storage, (AEKey)ManaKey.KEY, (long)Integer.MAX_VALUE, (IActionSource)this.source, (Actionable)Actionable.SIMULATE) + StorageHelper.poweredInsert((IEnergySource)this.energy, (MEStorage)this.storage, (AEKey)ManaKey.KEY, (long)Integer.MAX_VALUE, (IActionSource)this.source, (Actionable)Actionable.SIMULATE)));
    }

    public void addMana(int mana) {
        if (mana > 0) {
            StorageHelper.poweredInsert((IEnergySource)this.energy, (MEStorage)this.storage, (AEKey)ManaKey.KEY, (long)mana, (IActionSource)this.source);
        } else {
            StorageHelper.poweredExtraction((IEnergySource)this.energy, (MEStorage)this.storage, (AEKey)ManaKey.KEY, (long)(-mana), (IActionSource)this.source);
        }
    }

    public boolean canReceiveManaFromPool(class_2586 pool) {
        return true;
    }

    public boolean canReceiveManaFromItem(class_1799 otherStack) {
        return true;
    }

    public boolean canExportManaToPool(class_2586 pool) {
        return true;
    }

    public boolean canExportManaToItem(class_1799 otherStack) {
        return true;
    }

    public boolean isNoExport() {
        return false;
    }
}

