/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blockentity.machine.tier1;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1715;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import reborncore.api.IToolDrop;
import reborncore.api.blockentity.InventoryProvider;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.powerSystem.PowerAcceptorBlockEntity;
import reborncore.common.screen.BuiltScreenHandler;
import reborncore.common.screen.BuiltScreenHandlerProvider;
import reborncore.common.screen.builder.ScreenHandlerBuilder;
import reborncore.common.util.ItemUtils;
import reborncore.common.util.RebornInventory;
import techreborn.api.recipe.recipes.RollingMachineRecipe;
import techreborn.config.TechRebornConfig;
import techreborn.init.ModRecipes;
import techreborn.init.TRBlockEntities;
import techreborn.init.TRContent;

public class RollingMachineBlockEntity
extends PowerAcceptorBlockEntity
implements IToolDrop,
InventoryProvider,
BuiltScreenHandlerProvider {
    public int[] craftingSlots = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    private class_1715 craftCache;
    public final RebornInventory<RollingMachineBlockEntity> inventory = new RebornInventory(12, "RollingMachineBlockEntity", 64, (MachineBaseBlockEntity)this);
    public boolean isRunning;
    public int tickTime = 0;
    public int currentRecipeTime = 0;
    public class_1799 currentRecipeOutput = class_1799.field_8037;
    public RollingMachineRecipe currentRecipe;
    private final int outputSlot;
    public boolean locked = false;
    public int balanceSlot = 0;
    RollingMachineRecipe lastRecipe = null;
    private List<class_1792> cachedInventoryStructure = null;

    public RollingMachineBlockEntity(class_2338 pos, class_2680 state) {
        super(TRBlockEntities.ROLLING_MACHINE, pos, state);
        this.outputSlot = 9;
    }

    public long getBaseMaxPower() {
        return TechRebornConfig.rollingMachineMaxEnergy;
    }

    public boolean canProvideEnergy(@Nullable class_2350 side) {
        return false;
    }

    public long getBaseMaxOutput() {
        return 0L;
    }

    public long getBaseMaxInput() {
        return TechRebornConfig.rollingMachineMaxInput;
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, MachineBaseBlockEntity blockEntity) {
        super.tick(world, pos, state, blockEntity);
        if (world == null || world.field_9236) {
            return;
        }
        this.charge(10);
        class_1715 craftMatrix = this.getCraftingMatrix(true);
        this.currentRecipe = this.findMatchingRecipe(craftMatrix, world);
        if (this.currentRecipe != null) {
            if (world.method_8510() % 2L == 0L) {
                this.balanceRecipe(craftMatrix);
            }
            this.currentRecipeOutput = this.currentRecipe.method_8116((class_1263)craftMatrix, this.method_10997().method_30349());
        } else {
            this.currentRecipeOutput = class_1799.field_8037;
        }
        craftMatrix = this.getCraftingMatrix();
        if (this.currentRecipeOutput.method_7960() || !this.checkNotEmpty(craftMatrix)) {
            this.tickTime = 0;
            this.setIsActive(false);
            return;
        }
        if (this.getStored() > this.getEuPerTick(this.currentRecipe.getPower()) && this.canMake(craftMatrix)) {
            this.setIsActive(true);
            this.useEnergy(this.getEuPerTick(this.currentRecipe.getPower()));
            ++this.tickTime;
        } else {
            this.setIsActive(false);
            return;
        }
        if (this.tickTime >= this.currentRecipeTime) {
            if (this.inventory.method_5438(this.outputSlot).method_7960()) {
                this.inventory.method_5447(this.outputSlot, this.currentRecipeOutput.method_7972());
            } else {
                this.inventory.method_5438(this.outputSlot).method_7933(this.currentRecipeOutput.method_7947());
            }
            this.tickTime = 0;
            this.currentRecipeTime = Math.max((int)((double)this.currentRecipe.getTime() * (1.0 - this.getSpeedMultiplier())), 1);
            for (int i = 0; i < craftMatrix.method_5439(); ++i) {
                this.inventory.shrinkSlot(i, 1);
            }
            if (!this.locked) {
                this.currentRecipeOutput = class_1799.field_8037;
                this.currentRecipe = null;
            }
        }
    }

    public void setIsActive(boolean active) {
        if (active == this.isRunning) {
            return;
        }
        this.isRunning = active;
        class_2248 class_22482 = this.method_10997().method_8320(this.method_11016()).method_26204();
        if (class_22482 instanceof BlockMachineBase) {
            BlockMachineBase blockMachineBase = (BlockMachineBase)class_22482;
            blockMachineBase.setActive(Boolean.valueOf(active), this.method_10997(), this.method_11016());
        }
        this.method_10997().method_8413(this.method_11016(), this.method_10997().method_8320(this.method_11016()), this.method_10997().method_8320(this.method_11016()), 3);
    }

    public Optional<class_1715> balanceRecipe(class_1715 craftCache) {
        class_1799 sourceStack;
        if (this.currentRecipe == null) {
            return Optional.empty();
        }
        if (this.field_11863.field_9236) {
            return Optional.empty();
        }
        if (!this.locked) {
            return Optional.empty();
        }
        if (craftCache.method_5442()) {
            return Optional.empty();
        }
        ++this.balanceSlot;
        if (this.balanceSlot > craftCache.method_5439()) {
            this.balanceSlot = 0;
        }
        if ((sourceStack = this.inventory.method_5438(this.balanceSlot)).method_7960()) {
            return Optional.empty();
        }
        ArrayList<Integer> possibleSlots = new ArrayList<Integer>();
        for (int s = 0; s < this.currentRecipe.method_8117().size(); ++s) {
            class_1799 stackInSlot = this.inventory.method_5438(s);
            class_1856 ingredient = (class_1856)this.currentRecipe.method_8117().get(s);
            if (ingredient == class_1856.field_9017 || !ingredient.method_8093(sourceStack)) continue;
            if (stackInSlot.method_7960()) {
                possibleSlots.add(s);
                continue;
            }
            if (stackInSlot.method_7909() != sourceStack.method_7909()) continue;
            possibleSlots.add(s);
        }
        if (!possibleSlots.isEmpty()) {
            int totalItems = possibleSlots.stream().mapToInt(value -> this.inventory.method_5438(value.intValue()).method_7947()).sum();
            int slots = possibleSlots.size();
            int[] split = new int[slots];
            int remainder = totalItems % slots;
            Arrays.fill(split, totalItems / slots);
            while (remainder > 0) {
                for (int i = 0; i < split.length; ++i) {
                    if (remainder <= 0) continue;
                    int n = i;
                    split[n] = split[n] + 1;
                    --remainder;
                }
            }
            List slotEnvTyperubution = possibleSlots.stream().mapToInt(value -> this.inventory.method_5438(value.intValue()).method_7947()).boxed().collect(Collectors.toList());
            boolean needsBalance = false;
            for (int required : split) {
                if (slotEnvTyperubution.contains(required)) {
                    slotEnvTyperubution.remove((Object)required);
                    continue;
                }
                needsBalance = true;
            }
            if (!needsBalance) {
                return Optional.empty();
            }
        } else {
            return Optional.empty();
        }
        Pair bestSlot = null;
        for (Integer slot : possibleSlots) {
            class_1799 slotStack = this.inventory.method_5438(slot.intValue());
            if (slotStack.method_7960()) {
                bestSlot = Pair.of((Object)slot, (Object)0);
            }
            if (bestSlot == null) {
                bestSlot = Pair.of((Object)slot, (Object)slotStack.method_7947());
                continue;
            }
            if ((Integer)bestSlot.getRight() < slotStack.method_7947()) continue;
            bestSlot = Pair.of((Object)slot, (Object)slotStack.method_7947());
        }
        if (bestSlot == null || (Integer)bestSlot.getLeft() == this.balanceSlot || ((Integer)bestSlot.getRight()).intValue() == sourceStack.method_7947() || this.inventory.method_5438(((Integer)bestSlot.getLeft()).intValue()).method_7960() || !ItemUtils.isItemEqual((class_1799)sourceStack, (class_1799)this.inventory.method_5438(((Integer)bestSlot.getLeft()).intValue()), (boolean)true, (boolean)true)) {
            return Optional.empty();
        }
        sourceStack.method_7934(1);
        this.inventory.method_5438(((Integer)bestSlot.getLeft()).intValue()).method_7933(1);
        this.inventory.setHashChanged();
        return Optional.of(this.getCraftingMatrix());
    }

    private class_1715 getCraftingMatrix() {
        return this.getCraftingMatrix(false);
    }

    private class_1715 getCraftingMatrix(boolean forceRefresh) {
        if (this.craftCache == null) {
            this.craftCache = new class_1715((class_1703)new RollingBEContainer(), 3, 3);
        }
        if (forceRefresh || this.inventory.hasChanged()) {
            for (int i = 0; i < 9; ++i) {
                this.craftCache.method_5447(i, this.inventory.method_5438(i).method_7972());
            }
            this.inventory.resetHasChanged();
        }
        return this.craftCache;
    }

    private List<class_1792> fastIntlayout() {
        if (this.inventory == null) {
            return null;
        }
        ArrayList<class_1792> arrayList = new ArrayList<class_1792>(9);
        for (int i = 0; i < 9; ++i) {
            arrayList.add(this.inventory.method_5438(i).method_7909());
        }
        return arrayList;
    }

    private boolean checkNotEmpty(class_1715 craftMatrix) {
        if (this.locked) {
            boolean returnValue = false;
            for (int i = 0; i < craftMatrix.method_5439(); ++i) {
                class_1799 stack1 = craftMatrix.method_5438(i);
                if (stack1.method_7947() == 1) {
                    return false;
                }
                if (stack1.method_7947() <= 1) continue;
                returnValue = true;
            }
            return returnValue;
        }
        for (int i = 0; i < craftMatrix.method_5439(); ++i) {
            class_1799 stack1 = craftMatrix.method_5438(i);
            if (stack1.method_7960()) continue;
            return true;
        }
        return false;
    }

    public boolean canMake(class_1715 craftMatrix) {
        class_1799 stack = this.findMatchingRecipeOutput(craftMatrix, this.field_11863);
        if (stack.method_7960()) {
            return false;
        }
        class_1799 output = this.inventory.method_5438(this.outputSlot);
        if (output.method_7960()) {
            return true;
        }
        return ItemUtils.isItemEqual((class_1799)stack, (class_1799)output, (boolean)true, (boolean)true) && output.method_7947() + stack.method_7947() <= output.method_7914();
    }

    public List<RollingMachineRecipe> getAllRecipe(class_1937 world) {
        return ModRecipes.ROLLING_MACHINE.getRecipes(world);
    }

    public class_1799 findMatchingRecipeOutput(class_1715 inv, class_1937 world) {
        RollingMachineRecipe recipe = this.findMatchingRecipe(inv, world);
        if (recipe == null) {
            return class_1799.field_8037;
        }
        return recipe.method_8110(this.method_10997().method_30349());
    }

    public RollingMachineRecipe findMatchingRecipe(class_1715 inv, class_1937 world) {
        if (this.isCorrectCachedInventory()) {
            return this.lastRecipe;
        }
        this.cachedInventoryStructure = this.fastIntlayout();
        for (RollingMachineRecipe recipe : this.getAllRecipe(world)) {
            if (!recipe.method_8115((class_1263)inv, world)) continue;
            this.lastRecipe = recipe;
            this.currentRecipeTime = Math.max((int)((double)recipe.getTime() * (1.0 - this.getSpeedMultiplier())), 1);
            return recipe;
        }
        this.lastRecipe = null;
        this.currentRecipeTime = 0;
        return null;
    }

    private boolean isCorrectCachedInventory() {
        if (this.cachedInventoryStructure == null) {
            return false;
        }
        List<class_1792> current = this.fastIntlayout();
        if (current == null || current.size() != this.cachedInventoryStructure.size()) {
            return false;
        }
        for (int i = 0; i < current.size(); ++i) {
            if (current.get(i) == this.cachedInventoryStructure.get(i)) continue;
            return false;
        }
        return true;
    }

    public class_1799 getToolDrop(class_1657 entityPlayer) {
        return TRContent.Machine.ROLLING_MACHINE.getStack();
    }

    public void method_11014(class_2487 tagCompound) {
        super.method_11014(tagCompound);
        this.isRunning = tagCompound.method_10577("isRunning");
        this.tickTime = tagCompound.method_10550("tickTime");
        this.locked = tagCompound.method_10577("locked");
    }

    public void method_11007(class_2487 tagCompound) {
        super.method_11007(tagCompound);
        tagCompound.method_10556("isRunning", this.isRunning);
        tagCompound.method_10569("tickTime", this.tickTime);
        tagCompound.method_10556("locked", this.locked);
    }

    public RebornInventory<RollingMachineBlockEntity> getInventory() {
        return this.inventory;
    }

    public int getBurnTime() {
        return this.tickTime;
    }

    public void setBurnTime(int burnTime) {
        this.tickTime = burnTime;
    }

    public int getBurnTimeRemainingScaled(int scale) {
        if (this.tickTime == 0 || Math.max((int)((double)this.currentRecipe.getTime() * (1.0 - this.getSpeedMultiplier())), 1) == 0) {
            return 0;
        }
        return this.tickTime * scale / Math.max((int)((double)this.currentRecipe.getTime() * (1.0 - this.getSpeedMultiplier())), 1);
    }

    public BuiltScreenHandler createScreenHandler(int syncID, class_1657 player) {
        return new ScreenHandlerBuilder("rollingmachine").player(player.method_31548()).inventory().hotbar().addInventory().blockEntity((class_2586)this).slot(0, 30, 22).slot(1, 48, 22).slot(2, 66, 22).slot(3, 30, 40).slot(4, 48, 40).slot(5, 66, 40).slot(6, 30, 58).slot(7, 48, 58).slot(8, 66, 58).onCraft(inv -> this.inventory.method_5447(1, this.findMatchingRecipeOutput(this.getCraftingMatrix(), this.field_11863))).outputSlot(9, 124, 40).energySlot(10, 8, 70).syncEnergyValue().sync(this::getBurnTime, this::setBurnTime).sync(this::getLockedInt, this::setLockedInt).sync(this::getCurrentRecipeTime, this::setCurrentRecipeTime).addInventory().create((MachineBaseBlockEntity)this, syncID);
    }

    public int getCurrentRecipeTime() {
        return this.currentRecipeTime;
    }

    public RollingMachineBlockEntity setCurrentRecipeTime(int currentRecipeTime) {
        this.currentRecipeTime = currentRecipeTime;
        return this;
    }

    public int getLockedInt() {
        return this.locked ? 1 : 0;
    }

    public void setLockedInt(int lockedInt) {
        this.locked = lockedInt == 1;
    }

    public int getProgressScaled(int scale) {
        if (this.tickTime != 0 && this.currentRecipeTime != 0) {
            return this.tickTime * scale / this.currentRecipeTime;
        }
        return 0;
    }

    public boolean canBeUpgraded() {
        return true;
    }

    private static class RollingBEContainer
    extends class_1703 {
        protected RollingBEContainer() {
            super(null, 0);
        }

        public class_1799 method_7601(class_1657 player, int slot) {
            return class_1799.field_8037;
        }

        public boolean method_7597(class_1657 playerEntity) {
            return true;
        }
    }
}

