/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blockentity.machine.multiblock;

import java.util.function.BiPredicate;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.blockentity.MultiblockWriter;
import reborncore.common.multiblock.IMultiblockPart;
import reborncore.common.recipes.RecipeCrafter;
import reborncore.common.screen.BuiltScreenHandler;
import reborncore.common.screen.BuiltScreenHandlerProvider;
import reborncore.common.screen.builder.ScreenHandlerBuilder;
import reborncore.common.util.RebornInventory;
import techreborn.blockentity.machine.GenericMachineBlockEntity;
import techreborn.blockentity.machine.multiblock.casing.MachineCasingBlockEntity;
import techreborn.blocks.misc.BlockMachineCasing;
import techreborn.config.TechRebornConfig;
import techreborn.init.ModRecipes;
import techreborn.init.TRBlockEntities;
import techreborn.init.TRContent;
import techreborn.multiblocks.MultiBlockCasing;

public class IndustrialBlastFurnaceBlockEntity
extends GenericMachineBlockEntity
implements BuiltScreenHandlerProvider {
    private int cachedHeat;

    public IndustrialBlastFurnaceBlockEntity(class_2338 pos, class_2680 state) {
        super(TRBlockEntities.INDUSTRIAL_BLAST_FURNACE, pos, state, "IndustrialBlastFurnace", TechRebornConfig.industrialBlastFurnaceMaxInput, TechRebornConfig.industrialBlastFurnaceMaxEnergy, TRContent.Machine.INDUSTRIAL_BLAST_FURNACE.block, 4);
        int[] inputs = new int[]{0, 1};
        int[] outputs = new int[]{2, 3};
        this.inventory = new RebornInventory(5, "IndustrialBlastFurnaceBlockEntity", 64, (MachineBaseBlockEntity)this);
        this.crafter = new RecipeCrafter(ModRecipes.BLAST_FURNACE, (class_2586)this, 2, 2, this.inventory, inputs, outputs);
    }

    public void writeMultiblock(MultiblockWriter writer) {
        class_2248 basic = TRContent.MachineBlocks.BASIC.getCasing();
        class_2248 advanced = TRContent.MachineBlocks.ADVANCED.getCasing();
        class_2248 industrial = TRContent.MachineBlocks.INDUSTRIAL.getCasing();
        class_2680 lava = class_2246.field_10164.method_9564();
        BiPredicate<class_1922, class_2338> casing = (view, pos) -> {
            class_2248 block = view.method_8320(pos).method_26204();
            return basic == block || advanced == block || industrial == block;
        };
        BiPredicate<class_1922, class_2338> maybeLava = (view, pos) -> {
            class_2680 state = view.method_8320(pos);
            return state == lava || state.method_26204() == class_2246.field_10124;
        };
        class_2680 state = basic.method_9564();
        writer.translate(1, 0, -1).fill(0, 0, 0, 3, 1, 3, casing, state).ring(class_2350.class_2351.field_11052, 3, 1, 3, casing, state, maybeLava, lava).ring(class_2350.class_2351.field_11052, 3, 2, 3, casing, state, maybeLava, lava).fill(0, 3, 0, 3, 4, 3, casing, state);
    }

    public int getHeat() {
        if (!this.isMultiblockValid()) {
            return 0;
        }
        class_2338 location = this.field_11867.method_10079(this.getFacing().method_10153(), 2);
        class_2586 blockEntity = this.field_11863.method_8321(location);
        if (blockEntity instanceof MachineCasingBlockEntity && ((MachineCasingBlockEntity)blockEntity).isConnected() && ((MachineCasingBlockEntity)blockEntity).getMultiblockController().isAssembled()) {
            MultiBlockCasing casing = ((MachineCasingBlockEntity)blockEntity).getMultiblockController();
            int heat = 0;
            if (this.field_11863.method_8320(new class_2338(location.method_10263(), location.method_10264() - 1, location.method_10260())).method_26204() == blockEntity.method_10997().method_8320(blockEntity.method_11016()).method_26204()) {
                return 0;
            }
            for (IMultiblockPart part : casing.connectedParts) {
                heat += BlockMachineCasing.getHeatFromState(part.method_11010());
            }
            if (this.field_11863.method_8320(location.method_10079(class_2350.field_11036, 1)).method_26204() == class_2246.field_10164 && this.field_11863.method_8320(location.method_10079(class_2350.field_11036, 2)).method_26204() == class_2246.field_10164) {
                heat += 500;
            }
            return heat;
        }
        return 0;
    }

    public void setHeat(int heat) {
        this.cachedHeat = heat;
    }

    public int getCachedHeat() {
        return this.cachedHeat;
    }

    public BuiltScreenHandler createScreenHandler(int syncID, class_1657 player) {
        return new ScreenHandlerBuilder("blastfurnace").player(player.method_31548()).inventory().hotbar().addInventory().blockEntity((class_2586)this).slot(0, 50, 27).slot(1, 50, 47).outputSlot(2, 93, 37).outputSlot(3, 113, 37).energySlot(4, 8, 72).syncEnergyValue().syncCrafterValue().sync(this::getHeat, this::setHeat).addInventory().create((MachineBaseBlockEntity)this, syncID);
    }
}

