/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.util;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.Range;

public final class RangeUtil {
    private RangeUtil() {
    }

    public static List<Range<Integer>> joinAdjacent(List<Range<Integer>> list) {
        List<Range> in = list.stream().sorted(Comparator.comparing(Range::getMinimum)).toList();
        LinkedList<Range> out = new LinkedList<Range>();
        for (Range range : in) {
            if (out.isEmpty()) {
                out.add(range);
                continue;
            }
            Range last = (Range)out.getLast();
            if ((Integer)last.getMaximum() >= (Integer)range.getMinimum() - 1) {
                out.removeLast();
                out.add(Range.between((Comparable)((Integer)last.getMinimum()), (Comparable)Integer.valueOf(Math.max((Integer)last.getMaximum(), (Integer)range.getMaximum()))));
                continue;
            }
            out.add(range);
        }
        return Collections.unmodifiableList(out);
    }
}

