/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.network;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import reborncore.common.network.ExtendedPacketBuffer;
import reborncore.common.network.IdentifiedPacket;

public class NetworkManager {
    public static IdentifiedPacket createServerBoundPacket(class_2960 identifier, Consumer<ExtendedPacketBuffer> packetBufferConsumer) {
        class_2540 buf = PacketByteBufs.create();
        packetBufferConsumer.accept(new ExtendedPacketBuffer((ByteBuf)buf));
        return new IdentifiedPacket(identifier, buf);
    }

    public static void registerServerBoundHandler(class_2960 identifier, ServerPlayNetworking.PlayChannelHandler handler) {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)identifier, (ServerPlayNetworking.PlayChannelHandler)handler);
    }

    public static IdentifiedPacket createClientBoundPacket(class_2960 identifier, Consumer<ExtendedPacketBuffer> packetBufferConsumer) {
        class_2540 buf = PacketByteBufs.create();
        packetBufferConsumer.accept(new ExtendedPacketBuffer((ByteBuf)buf));
        return new IdentifiedPacket(identifier, buf);
    }

    public static <T> IdentifiedPacket createClientBoundPacket(class_2960 identifier, Codec<T> codec, T value) {
        return NetworkManager.createClientBoundPacket(identifier, extendedPacketBuffer -> extendedPacketBuffer.writeCodec(codec, value));
    }

    public static void sendToAll(IdentifiedPacket packet, MinecraftServer server) {
        NetworkManager.send(packet, PlayerLookup.all((MinecraftServer)server));
    }

    public static void sendToPlayer(IdentifiedPacket packet, class_3222 serverPlayerEntity) {
        NetworkManager.send(packet, Collections.singletonList(serverPlayerEntity));
    }

    public static void sendToWorld(IdentifiedPacket packet, class_3218 world) {
        NetworkManager.send(packet, PlayerLookup.world((class_3218)world));
    }

    public static void sendToTracking(IdentifiedPacket packet, class_2586 blockEntity) {
        NetworkManager.send(packet, PlayerLookup.tracking((class_2586)blockEntity));
    }

    public static void send(IdentifiedPacket packet, Collection<class_3222> players) {
        for (class_3222 player : players) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)packet.channel(), (class_2540)packet.packetByteBuf());
        }
    }

    public static void sendTo(IdentifiedPacket packet, PacketSender sender) {
        class_2596 s2CPacket = ServerPlayNetworking.createS2CPacket((class_2960)packet.channel(), (class_2540)packet.packetByteBuf());
        sender.sendPacket(s2CPacket);
    }
}

