/*
 * Decompiled with CFR 0.152.
 */
package reborncore;

import java.util.Locale;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerBlockEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reborncore.api.ToolManager;
import reborncore.api.blockentity.UnloadHandler;
import reborncore.api.items.ArmorRemoveHandler;
import reborncore.common.RebornCoreCommands;
import reborncore.common.RebornCoreConfig;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.blocks.BlockWrenchEventHandler;
import reborncore.common.chunkloading.ChunkLoaderManager;
import reborncore.common.config.Configuration;
import reborncore.common.misc.ModSounds;
import reborncore.common.misc.RebornCoreTags;
import reborncore.common.multiblock.MultiblockRegistry;
import reborncore.common.network.ServerBoundPackets;
import reborncore.common.powerSystem.PowerAcceptorBlockEntity;
import reborncore.common.recipes.PaddedShapedRecipe;
import reborncore.common.screen.ServerPlayerEntityScreenHandlerHelper;
import reborncore.common.util.CalenderUtils;
import reborncore.common.util.GenericWrenchHelper;
import team.reborn.energy.api.EnergyStorage;

public class RebornCore
implements ModInitializer {
    public static final String MOD_NAME = "Reborn Core";
    public static final String MOD_ID = "reborncore";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"reborncore");
    public static Locale locale = Locale.ROOT;

    public void onInitialize() {
        new Configuration(RebornCoreConfig.class, MOD_ID);
        CalenderUtils.loadCalender();
        ToolManager.INSTANCE.customToolHandlerList.add(new GenericWrenchHelper(new class_2960("ic2:wrench"), true));
        ToolManager.INSTANCE.customToolHandlerList.add(new GenericWrenchHelper(new class_2960("forestry:wrench"), false));
        ToolManager.INSTANCE.customToolHandlerList.add(new GenericWrenchHelper(new class_2960("actuallyadditions:item_laser_wrench"), false));
        ToolManager.INSTANCE.customToolHandlerList.add(new GenericWrenchHelper(new class_2960("thermalfoundation:wrench"), false));
        ToolManager.INSTANCE.customToolHandlerList.add(new GenericWrenchHelper(new class_2960("charset:wrench"), false));
        ToolManager.INSTANCE.customToolHandlerList.add(new GenericWrenchHelper(new class_2960("teslacorelib:wrench"), false));
        ToolManager.INSTANCE.customToolHandlerList.add(new GenericWrenchHelper(new class_2960("rftools:smartwrench"), false));
        ToolManager.INSTANCE.customToolHandlerList.add(new GenericWrenchHelper(new class_2960("intergrateddynamics:smartwrench"), false));
        ToolManager.INSTANCE.customToolHandlerList.add(new GenericWrenchHelper(new class_2960("correlated:weldthrower"), false));
        ToolManager.INSTANCE.customToolHandlerList.add(new GenericWrenchHelper(new class_2960("chiselsandbits:wrench_wood"), false));
        ToolManager.INSTANCE.customToolHandlerList.add(new GenericWrenchHelper(new class_2960("redstonearsenal:tool.wrench_flux"), false));
        ModSounds.setup();
        BlockWrenchEventHandler.setup();
        ServerTickEvents.START_WORLD_TICK.register(MultiblockRegistry::tickStart);
        ServerBoundPackets.init();
        RebornCoreCommands.setup();
        RebornCoreTags.WATER_EXPLOSION_ITEM.toString();
        PaddedShapedRecipe.PADDED.toString();
        ServerBlockEntityEvents.BLOCK_ENTITY_UNLOAD.register((blockEntity, world) -> {
            if (blockEntity instanceof UnloadHandler) {
                ((UnloadHandler)blockEntity).onUnload();
            }
        });
        ServerWorldEvents.LOAD.register((server, world) -> ChunkLoaderManager.get((class_1937)world).onServerWorldLoad(world));
        ServerTickEvents.START_WORLD_TICK.register(world -> ChunkLoaderManager.get((class_1937)world).onServerWorldTick(world));
        ServerEntityEvents.EQUIPMENT_CHANGE.register((livingEntity, equipmentSlot, previousStack, currentStack) -> {
            if (livingEntity instanceof class_1657) {
                class_1657 playerEntity = (class_1657)livingEntity;
                class_1792 patt6058$temp = previousStack.method_7909();
                if (patt6058$temp instanceof ArmorRemoveHandler) {
                    ArmorRemoveHandler armorRemoveHandler = (ArmorRemoveHandler)patt6058$temp;
                    if (!class_1799.method_7984((class_1799)previousStack, (class_1799)currentStack)) {
                        armorRemoveHandler.onRemoved(playerEntity);
                    }
                }
            }
        });
        FluidStorage.SIDED.registerFallback((world, pos, state, be, direction) -> {
            if (be instanceof MachineBaseBlockEntity) {
                MachineBaseBlockEntity machineBase = (MachineBaseBlockEntity)be;
                return machineBase.getTank();
            }
            return null;
        });
        EnergyStorage.SIDED.registerFallback((world, pos, state, be, direction) -> {
            if (be instanceof PowerAcceptorBlockEntity) {
                PowerAcceptorBlockEntity powerAcceptor = (PowerAcceptorBlockEntity)be;
                return powerAcceptor.getSideEnergyStorage((class_2350)direction);
            }
            return null;
        });
        ServerPlayerEntityScreenHandlerHelper.class.getName();
    }

    public static EnvType getSide() {
        return FabricLoader.getInstance().getEnvironmentType();
    }
}

