/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.fabric.transfer;

import com.google.common.primitives.Ints;
import java.util.ArrayList;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1799;
import owmii.powah.lib.logistics.inventory.Inventory;

public class InventoryWrapper
extends CombinedStorage<ItemVariant, Slot> {
    private final Inventory inventory;

    public InventoryWrapper(Inventory inventory) {
        super(new ArrayList());
        this.inventory = inventory;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            this.parts.add(new Slot(i));
        }
    }

    protected class Slot
    extends SnapshotParticipant<class_1799>
    implements SingleSlotStorage<ItemVariant> {
        private final int slot;

        private Slot(int slot) {
            this.slot = slot;
        }

        public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            StoragePreconditions.notBlankNotNegative((TransferVariant)resource, (long)maxAmount);
            int amount = Ints.saturatedCast((long)maxAmount);
            class_1799 toInsert = resource.toStack(amount);
            if (InventoryWrapper.this.inventory.insertItem(this.slot, toInsert, true).method_7947() < amount) {
                this.updateSnapshots(transaction);
                InventoryWrapper.this.inventory.setSendUpdates(false);
                int inserted = amount - InventoryWrapper.this.inventory.insertItem(this.slot, toInsert, false).method_7947();
                InventoryWrapper.this.inventory.setSendUpdates(true);
                return inserted;
            }
            return 0L;
        }

        public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            StoragePreconditions.notBlankNotNegative((TransferVariant)resource, (long)maxAmount);
            int amount = Ints.saturatedCast((long)maxAmount);
            if (resource.matches(InventoryWrapper.this.inventory.extractItem(this.slot, amount, true))) {
                this.updateSnapshots(transaction);
                InventoryWrapper.this.inventory.setSendUpdates(false);
                class_1799 extracted = InventoryWrapper.this.inventory.extractItem(this.slot, amount, false);
                InventoryWrapper.this.inventory.setSendUpdates(true);
                return extracted.method_7947();
            }
            return 0L;
        }

        public boolean isResourceBlank() {
            return InventoryWrapper.this.inventory.getStackInSlot(this.slot).method_7960();
        }

        public ItemVariant getResource() {
            return ItemVariant.of((class_1799)InventoryWrapper.this.inventory.getStackInSlot(this.slot));
        }

        public long getAmount() {
            return InventoryWrapper.this.inventory.getStackInSlot(this.slot).method_7947();
        }

        public long getCapacity() {
            return InventoryWrapper.this.inventory.getStackInSlot(this.slot).method_7914();
        }

        protected class_1799 createSnapshot() {
            return InventoryWrapper.this.inventory.getStackInSlot(this.slot).method_7972();
        }

        protected void readSnapshot(class_1799 snapshot) {
            InventoryWrapper.this.inventory.setSendUpdates(false);
            InventoryWrapper.this.inventory.setStackInSlot(this.slot, snapshot);
            InventoryWrapper.this.inventory.setSendUpdates(true);
        }

        protected void onFinalCommit() {
            InventoryWrapper.this.inventory.onContentsChanged(this.slot);
        }
    }
}

