/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.glodium.registry;

import com.glodblock.github.glodium.Glodium;
import it.unimi.dsi.fastutil.objects.Object2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.apache.commons.lang3.tuple.Pair;

public class RegistryHandler {
    protected final String id;
    protected final List<Pair<String, class_2248>> blocks = new ArrayList<Pair<String, class_2248>>();
    protected final List<Pair<String, class_1792>> items = new ArrayList<Pair<String, class_1792>>();
    protected final List<Pair<String, class_2591<?>>> tiles = new ArrayList();
    protected final Object2ReferenceMap<String, Function<class_2248, class_1792>> itemBlocks = new Object2ReferenceOpenHashMap();

    public RegistryHandler(String modid) {
        this.id = modid;
    }

    public void block(String name, class_2248 block) {
        this.blocks.add((Pair<String, class_2248>)Pair.of((Object)name, (Object)block));
    }

    public void block(String name, class_2248 block, Function<class_2248, class_1792> itemWrapper) {
        this.block(name, block);
        this.itemBlocks.put((Object)name, itemWrapper);
    }

    public void item(String name, class_1792 item) {
        this.items.add((Pair<String, class_1792>)Pair.of((Object)name, (Object)item));
    }

    public void tile(String name, class_2591<?> type) {
        this.tiles.add(Pair.of((Object)name, type));
    }

    public void runRegister() {
        this.onRegisterBlocks();
        this.onRegisterItems();
        this.onRegisterTileEntities();
    }

    protected void onRegisterBlocks() {
        for (Pair<String, class_2248> entry : this.blocks) {
            String key = (String)entry.getLeft();
            class_2248 block = (class_2248)entry.getRight();
            class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)Glodium.id(this.id, key), (Object)block);
        }
    }

    protected void onRegisterItems() {
        for (Pair<String, class_2248> pair : this.blocks) {
            if (this.itemBlocks.containsKey(pair.getLeft())) {
                class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)Glodium.id(this.id, (String)pair.getLeft()), (Object)((class_1792)((Function)this.itemBlocks.get(pair.getLeft())).apply((class_2248)pair.getRight())));
                continue;
            }
            class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)Glodium.id(this.id, (String)pair.getLeft()), (Object)new class_1747((class_2248)pair.getRight(), new class_1792.class_1793()));
        }
        for (Pair<String, class_2248> pair : this.items) {
            class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)Glodium.id(this.id, (String)pair.getLeft()), (Object)((class_1792)pair.getRight()));
        }
    }

    protected void onRegisterTileEntities() {
        for (Pair<String, class_2591<?>> entry : this.tiles) {
            class_2378.method_10230((class_2378)class_7923.field_41181, (class_2960)Glodium.id(this.id, (String)entry.getLeft()), (Object)((class_2591)entry.getRight()));
        }
    }
}

