/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.glodium.network;

import com.glodblock.github.glodium.Glodium;
import com.glodblock.github.glodium.GlodiumServer;
import com.glodblock.github.glodium.network.TargetPoint;
import com.glodblock.github.glodium.network.packet.IMessage;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_2987;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;

public class NetworkHandlerServer {
    protected final class_2960 channel;
    int id = 0;
    protected final Int2ObjectMap<Supplier<IMessage<?>>> packetFactoryMap = new Int2ObjectOpenHashMap();
    protected final Object2IntMap<Class<?>> packetIDMap = new Object2IntOpenHashMap();

    NetworkHandlerServer(String modid) {
        this.channel = Glodium.id(modid, "network");
        ServerPlayNetworking.registerGlobalReceiver((class_2960)this.channel, this::serverPacket);
    }

    public void registerPacket(Class<?> clazz, Supplier<IMessage<?>> factory) {
        this.packetIDMap.put(clazz, this.id);
        this.packetFactoryMap.put(this.id, factory);
        ++this.id;
    }

    public void serverPacket(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 payload, PacketSender responseSender) {
        try {
            IMessage packet = (IMessage)((Supplier)this.packetFactoryMap.get(payload.method_10816())).get();
            if (!packet.isClient()) {
                packet.fromBytes(payload);
                server.execute(() -> packet.onMessage((class_1657)player));
            }
        }
        catch (class_2987 class_29872) {
            // empty catch block
        }
    }

    public void sendToAll(IMessage<?> message) {
        MinecraftServer server = GlodiumServer.getServer();
        if (server != null) {
            PlayerLookup.all((MinecraftServer)server).forEach(player -> ServerPlayNetworking.send((class_3222)player, (class_2960)this.channel, (class_2540)this.toFMLPacket(message)));
        }
    }

    public void sendTo(IMessage<?> message, class_3222 player) {
        ServerPlayNetworking.send((class_3222)player, (class_2960)this.channel, (class_2540)this.toFMLPacket(message));
    }

    public void sendToAllAround(IMessage<?> message, TargetPoint point) {
        PlayerLookup.around((class_3218)((class_3218)point.level), (class_243)new class_243(point.x, point.y, point.z), (double)point.r2).forEach(player -> {
            if (player != point.excluded) {
                ServerPlayNetworking.send((class_3222)player, (class_2960)this.channel, (class_2540)this.toFMLPacket(message));
            }
        });
    }

    public void sendToServer(IMessage<?> message) {
        throw new UnsupportedOperationException();
    }

    public class_2540 toFMLPacket(IMessage<?> message) {
        class_2540 bytes = new class_2540(Unpooled.buffer((int)1024));
        int id = this.packetIDMap.getOrDefault(message.getPacketClass(), -1);
        if (id == -1) {
            Glodium.LOGGER.error(String.format("Unregistered Packet: %s", message.getPacketClass()));
        }
        bytes.method_10804(id);
        message.toBytes(bytes);
        return bytes;
    }
}

