/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.glodium.client.render.highlight;

import com.glodblock.github.glodium.client.render.ColorData;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.PriorityQueue;
import it.unimi.dsi.fastutil.objects.ObjectHeapPriorityQueue;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_5321;

public class HighlightHandler {
    private static final PriorityQueue<HighlightData> BLOCK_QUEUE = new ObjectHeapPriorityQueue(Comparator.comparingLong(o -> o.time));
    private static final ObjectSet<HighlightData> BLOCKS = new ObjectOpenCustomHashSet((Hash.Strategy)new Hash.Strategy<HighlightData>(){

        public int hashCode(HighlightData o) {
            return o.dim.hashCode() ^ o.pos.hashCode();
        }

        public boolean equals(HighlightData a, HighlightData b) {
            return a == b || a != null && b != null && Objects.equals(a.dim, b.dim) && Objects.equals(a.pos, b.pos) && 1.dirCheck(a.face, b.face);
        }

        private static boolean dirCheck(class_2350 a, class_2350 b) {
            if (a == null || b == null) {
                return true;
            }
            return a == b;
        }
    });

    public static void highlight(class_2338 pos, class_5321<class_1937> dim, long time, ColorData color) {
        HighlightHandler.highlight(pos, null, dim, time, new class_238(pos), color);
    }

    public static void highlight(class_2338 pos, class_5321<class_1937> dim, long time, ColorData color, Supplier<Boolean> checker) {
        HighlightHandler.highlight(pos, null, dim, time, new class_238(pos), color, checker);
    }

    public static void highlight(class_2338 pos, class_2350 face, class_5321<class_1937> dim, long time, class_238 box, ColorData color) {
        HighlightHandler.highlight(pos, face, dim, time, box, color, null);
    }

    public static void highlight(class_2338 pos, class_2350 face, class_5321<class_1937> dim, long time, class_238 box, ColorData color, Supplier<Boolean> checker) {
        HighlightData r = new HighlightData(pos, face, time, dim, box, color, checker);
        if (!BLOCKS.contains((Object)r)) {
            BLOCK_QUEUE.enqueue((Object)r);
            BLOCKS.add((Object)r);
        }
    }

    public static void expire() {
        if (BLOCK_QUEUE.isEmpty()) {
            return;
        }
        BLOCKS.remove(BLOCK_QUEUE.first());
        BLOCK_QUEUE.dequeue();
    }

    public static HighlightData getFirst() {
        if (BLOCK_QUEUE.isEmpty()) {
            return null;
        }
        return (HighlightData)BLOCK_QUEUE.first();
    }

    public static Collection<HighlightData> getBlockData() {
        return BLOCKS;
    }

    public record HighlightData(class_2338 pos, class_2350 face, long time, class_5321<class_1937> dim, class_238 box, ColorData color, Supplier<Boolean> checker) {
        public boolean checkDim(class_5321<class_1937> dim) {
            if (dim == null || this.dim == null) {
                return false;
            }
            return dim.equals(this.dim);
        }

        public boolean allowRender() {
            if (this.checker != null) {
                return this.checker.get();
            }
            return true;
        }
    }
}

