/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.extendedae.container;

import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.inventories.InternalInventory;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.core.definitions.AEItems;
import appeng.crafting.pattern.AECraftingPattern;
import appeng.crafting.pattern.AEProcessingPattern;
import appeng.crafting.pattern.EncodedPatternItem;
import appeng.menu.AEBaseMenu;
import appeng.menu.SlotSemantics;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.slot.AppEngSlot;
import appeng.menu.slot.OutputSlot;
import appeng.menu.slot.RestrictedInputSlot;
import appeng.util.inv.AppEngInternalInventory;
import com.github.glodblock.extendedae.api.IPage;
import com.github.glodblock.extendedae.client.ExSemantics;
import com.github.glodblock.extendedae.client.gui.widget.SingleFakeSlot;
import com.github.glodblock.extendedae.common.inventory.PatternModifierInventory;
import com.github.glodblock.extendedae.network.packet.sync.IActionHolder;
import com.github.glodblock.extendedae.util.Ae2Reflect;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3917;
import net.minecraft.class_3955;
import org.jetbrains.annotations.NotNull;

public class ContainerPatternModifier
extends AEBaseMenu
implements IPage,
IActionHolder {
    private final Map<String, Consumer<Object[]>> actions = new Object2ObjectOpenHashMap();
    public static final class_3917<ContainerPatternModifier> TYPE = MenuTypeBuilder.create(ContainerPatternModifier::new, PatternModifierInventory.class).build("pattern_modifier");
    public final AppEngSlot targetSlot;
    public final AppEngSlot cloneSlot;
    public final AppEngSlot replaceTarget;
    public final AppEngSlot replaceWith;
    @GuiSync(value=1)
    public int page;

    public ContainerPatternModifier(int id, class_1661 playerInventory, PatternModifierInventory host) {
        super(TYPE, id, playerInventory, (Object)host);
        this.createPlayerInventorySlots(playerInventory);
        AppEngInternalInventory patternInv = host.getInventoryByName("patternInv");
        for (int x = 0; x < patternInv.size(); ++x) {
            this.addSlot((class_1735)new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.ENCODED_PATTERN, (InternalInventory)patternInv, x), SlotSemantics.ENCODED_PATTERN);
        }
        AppEngInternalInventory targetInv = host.getInventoryByName("targetInv");
        AppEngInternalInventory blankPatternInv = host.getInventoryByName("blankPatternInv");
        AppEngInternalInventory clonePatternInv = host.getInventoryByName("clonePatternInv");
        AppEngInternalInventory replaceInv = host.getInventoryByName("replaceInv");
        this.targetSlot = (AppEngSlot)this.addSlot((class_1735)new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.ENCODED_PATTERN, (InternalInventory)targetInv, 0), ExSemantics.EX_1);
        this.cloneSlot = (AppEngSlot)this.addSlot((class_1735)new OutputSlot((InternalInventory)clonePatternInv, 0, null), ExSemantics.EX_2);
        this.replaceTarget = (AppEngSlot)this.addSlot((class_1735)new SingleFakeSlot((InternalInventory)replaceInv, 0), ExSemantics.EX_4);
        this.replaceWith = (AppEngSlot)this.addSlot((class_1735)new SingleFakeSlot((InternalInventory)replaceInv, 1), ExSemantics.EX_5);
        for (int x = 0; x < blankPatternInv.size(); ++x) {
            this.addSlot((class_1735)new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.BLANK_PATTERN, (InternalInventory)blankPatternInv, x), ExSemantics.EX_3);
        }
        this.actions.put("clear", o -> this.clear());
        this.actions.put("clone", o -> this.clonePattern());
        this.actions.put("modify", o -> this.modify((Integer)o[0], (Boolean)o[1]));
        this.actions.put("replace", o -> this.replace());
        this.actions.put("show", o -> this.showPage());
    }

    public void showPage() {
        AppEngSlot as;
        for (class_1735 slot : this.getSlots(SlotSemantics.ENCODED_PATTERN)) {
            if (!(slot instanceof AppEngSlot)) continue;
            as = (AppEngSlot)slot;
            as.setSlotEnabled(this.page == 0 || this.page == 1);
        }
        this.replaceTarget.setSlotEnabled(this.page == 1);
        this.replaceWith.setSlotEnabled(this.page == 1);
        this.targetSlot.setSlotEnabled(this.page == 2);
        this.cloneSlot.setSlotEnabled(this.page == 2);
        for (class_1735 slot : this.getSlots(ExSemantics.EX_3)) {
            if (!(slot instanceof AppEngSlot)) continue;
            as = (AppEngSlot)slot;
            as.setSlotEnabled(this.page == 2);
        }
    }

    public void replace() {
        class_1799 replace = this.replaceTarget.method_7677();
        class_1799 with = this.replaceWith.method_7677();
        if (replace.method_7960() || with.method_7960()) {
            return;
        }
        for (class_1735 slot : this.getSlots(SlotSemantics.ENCODED_PATTERN)) {
            GenericStack[] replaceInput;
            GenericStack output;
            GenericStack[] input;
            class_1799 stack = slot.method_7677();
            class_1792 class_17922 = stack.method_7909();
            if (!(class_17922 instanceof EncodedPatternItem)) continue;
            EncodedPatternItem pattern = (EncodedPatternItem)class_17922;
            IPatternDetails detail = pattern.decode(stack, this.getPlayer().method_37908(), false);
            if (detail instanceof AEProcessingPattern) {
                AEProcessingPattern process = (AEProcessingPattern)detail;
                input = process.getSparseInputs();
                output = process.getOutputs();
                replaceInput = new GenericStack[input.length];
                GenericStack[] replaceOutput = new GenericStack[((GenericStack)output).length];
                this.replace(input, replaceInput, (AEKey)AEItemKey.of((class_1799)replace), (AEKey)AEItemKey.of((class_1799)with));
                this.replace((GenericStack[])output, replaceOutput, (AEKey)AEItemKey.of((class_1799)replace), (AEKey)AEItemKey.of((class_1799)with));
                class_1799 newPattern = PatternDetailsHelper.encodeProcessingPattern((GenericStack[])replaceInput, (GenericStack[])replaceOutput);
                slot.method_7673(newPattern);
                continue;
            }
            if (!(detail instanceof AECraftingPattern)) continue;
            AECraftingPattern craft = (AECraftingPattern)detail;
            input = craft.getSparseInputs();
            output = craft.getPrimaryOutput();
            replaceInput = new GenericStack[input.length];
            this.replace(input, replaceInput, (AEKey)AEItemKey.of((class_1799)replace), (AEKey)AEItemKey.of((class_1799)with));
            try {
                class_1799 newPattern = PatternDetailsHelper.encodeCraftingPattern((class_3955)Ae2Reflect.getCraftRecipe(craft), (class_1799[])this.itemize(replaceInput), (class_1799)this.itemize(output), (boolean)craft.canSubstitute, (boolean)craft.canSubstituteFluids);
                AECraftingPattern check = new AECraftingPattern(AEItemKey.of((class_1799)newPattern), this.getPlayer().method_37908());
                if (check == null) continue;
                slot.method_7673(newPattern);
            }
            catch (Exception e) {
                return;
            }
        }
    }

    private class_1799[] itemize(GenericStack[] stacks) {
        class_1799[] items = new class_1799[stacks.length];
        for (int i = 0; i < stacks.length; ++i) {
            items[i] = this.itemize(stacks[i]);
        }
        return items;
    }

    private class_1799 itemize(GenericStack stack) {
        AEKey aEKey;
        if (stack != null && (aEKey = stack.what()) instanceof AEItemKey) {
            AEItemKey what = (AEItemKey)aEKey;
            return what.toStack((int)stack.amount());
        }
        return class_1799.field_8037;
    }

    public void clear() {
        for (class_1735 slot : this.getSlots(SlotSemantics.ENCODED_PATTERN)) {
            class_1799 stack = slot.method_7677();
            if (!(stack.method_7909() instanceof EncodedPatternItem)) continue;
            slot.method_7673(AEItems.BLANK_PATTERN.stack());
        }
    }

    public void clonePattern() {
        EncodedPatternItem pattern;
        IPatternDetails detail;
        class_1799 target = this.targetSlot.method_7677();
        class_1799 clone = this.cloneSlot.method_7677();
        class_1792 class_17922 = target.method_7909();
        if (class_17922 instanceof EncodedPatternItem && (detail = (pattern = (EncodedPatternItem)class_17922).decode(target, this.getPlayer().method_37908(), false)) != null) {
            class_1799 newPattern = target.method_7972();
            if (clone.method_7960()) {
                if (this.consumeBlankPattern()) {
                    this.cloneSlot.method_7673(newPattern);
                }
            } else if (clone.method_7909() instanceof EncodedPatternItem) {
                this.cloneSlot.method_7673(newPattern);
            }
        }
    }

    public void modify(int scale, boolean div) {
        if (scale <= 0) {
            return;
        }
        for (class_1735 slot : this.getSlots(SlotSemantics.ENCODED_PATTERN)) {
            EncodedPatternItem pattern;
            IPatternDetails detail;
            class_1799 stack = slot.method_7677();
            class_1792 class_17922 = stack.method_7909();
            if (!(class_17922 instanceof EncodedPatternItem) || !((detail = (pattern = (EncodedPatternItem)class_17922).decode(stack, this.getPlayer().method_37908(), false)) instanceof AEProcessingPattern)) continue;
            AEProcessingPattern process = (AEProcessingPattern)detail;
            GenericStack[] input = process.getSparseInputs();
            GenericStack[] output = process.getOutputs();
            if (!this.checkModify(input, scale, div) || !this.checkModify(output, scale, div)) continue;
            GenericStack[] mulInput = new GenericStack[input.length];
            GenericStack[] mulOutput = new GenericStack[output.length];
            this.modifyStacks(input, mulInput, scale, div);
            this.modifyStacks(output, mulOutput, scale, div);
            class_1799 newPattern = PatternDetailsHelper.encodeProcessingPattern((GenericStack[])mulInput, (GenericStack[])mulOutput);
            slot.method_7673(newPattern);
        }
    }

    private boolean checkModify(GenericStack[] stacks, int scale, boolean div) {
        if (div) {
            for (GenericStack stack : stacks) {
                if (stack == null || stack.amount() % (long)scale == 0L) continue;
                return false;
            }
        } else {
            for (GenericStack stack : stacks) {
                if (stack == null) continue;
                long upper = 999999L * (long)stack.what().getAmountPerUnit();
                if (stack.amount() * (long)scale <= upper) continue;
                return false;
            }
        }
        return true;
    }

    private void modifyStacks(GenericStack[] stacks, GenericStack[] des, int scale, boolean div) {
        for (int i = 0; i < stacks.length; ++i) {
            if (stacks[i] == null) continue;
            long amt = div ? stacks[i].amount() / (long)scale : stacks[i].amount() * (long)scale;
            des[i] = new GenericStack(stacks[i].what(), amt);
        }
    }

    private void replace(GenericStack[] stacks, GenericStack[] des, AEKey replace, AEKey with) {
        for (int i = 0; i < stacks.length; ++i) {
            if (stacks[i] == null) continue;
            des[i] = stacks[i].what().equals(replace) ? new GenericStack(with, stacks[i].amount()) : new GenericStack(stacks[i].what(), stacks[i].amount());
        }
    }

    private boolean consumeBlankPattern() {
        for (class_1735 slot : this.getSlots(ExSemantics.EX_3)) {
            class_1799 stack = slot.method_7677();
            if (stack.method_7960() || !AEItems.BLANK_PATTERN.isSameAs(stack)) continue;
            stack.method_7934(1);
            if (stack.method_7947() <= 0) {
                slot.method_7673(class_1799.field_8037);
            }
            return true;
        }
        return false;
    }

    @Override
    public void setPage(int page) {
        this.page = page;
    }

    @Override
    public int getPage() {
        return this.page;
    }

    @Override
    @NotNull
    public Map<String, Consumer<Object[]>> getActionMap() {
        return this.actions;
    }
}

