/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.script;

import com.blamejared.crafttweaker.CraftTweakerCommon;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.util.sequence.SequenceManager;
import com.blamejared.crafttweaker.api.util.sequence.SequenceType;
import com.blamejared.crafttweaker.api.zencode.scriptrun.ScriptRunConfiguration;
import com.blamejared.crafttweaker.impl.script.ScriptRecipe;
import com.blamejared.crafttweaker.impl.script.ScriptRecipeType;
import com.blamejared.crafttweaker.mixin.common.access.recipe.AccessRecipeManager;
import com.blamejared.crafttweaker.platform.Services;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_2960;
import net.minecraft.class_3956;

public class RecipeManagerScriptLoader {
    private static UpdatedState currentState = UpdatedState.NONE;
    private static class_1863 manager = null;

    public static void updateState(UpdatedState state, @Nullable Supplier<class_1863> managerSupplier) {
        if (currentState.hasAll()) {
            currentState = UpdatedState.NONE;
            manager = null;
            throw new IllegalArgumentException("Invalid state found in RecipeManagerScriptLoader!");
        }
        currentState = currentState.merge(state);
        if (managerSupplier != null) {
            manager = managerSupplier.get();
        }
        if (currentState.hasAll()) {
            if (manager == null) {
                throw new RuntimeException("State is ready, but manager is null!");
            }
            RecipeManagerScriptLoader.loadScriptsFromManager(manager);
            currentState = UpdatedState.NONE;
            manager = null;
        }
    }

    public static void loadScriptsFromManager(class_1863 manager) {
        SequenceManager.clearSequences(SequenceType.CLIENT_THREAD_LEVEL);
        if (Services.CLIENT.isSingleplayer()) {
            return;
        }
        RecipeManagerScriptLoader.fixRecipeManager(manager);
        Map<class_3956<?>, Map<class_2960, class_1860<?>>> allRecipes = ((AccessRecipeManager)manager).crafttweaker$getRecipes();
        Map<class_2960, class_1860<?>> recipes = allRecipes.remove((Object)ScriptRecipeType.INSTANCE);
        if (recipes == null || recipes.isEmpty()) {
            return;
        }
        Collection scriptRecipes = recipes.values().stream().map(ScriptRecipe.class::cast).collect(Collectors.toCollection(ArrayList::new));
        ScriptRunConfiguration configuration = new ScriptRunConfiguration("crafttweaker", CraftTweakerConstants.CLIENT_RECIPES_UPDATED_SOURCE_ID, ScriptRunConfiguration.RunKind.EXECUTE);
        try {
            RecipeManagerScriptLoader.executeScriptRecipes(scriptRecipes, configuration);
        }
        catch (Throwable e) {
            CraftTweakerCommon.logger().error("Unable to execute script run", e);
        }
    }

    private static void fixRecipeManager(class_1863 manager) {
        AccessRecipeManager accessRecipeManager = (AccessRecipeManager)manager;
        accessRecipeManager.crafttweaker$setRecipes(new HashMap(accessRecipeManager.crafttweaker$getRecipes()));
        accessRecipeManager.crafttweaker$getRecipes().replaceAll((k, v) -> new HashMap(accessRecipeManager.crafttweaker$getRecipes().get(k)));
        accessRecipeManager.crafttweaker$setByName(new HashMap(accessRecipeManager.crafttweaker$getByName()));
        CraftTweakerAPI.getAccessibleElementsProvider().recipeManager(manager);
    }

    private static void executeScriptRecipes(Collection<ScriptRecipe> scriptRecipes, ScriptRunConfiguration configuration) throws Throwable {
        URI uri = new URI("crt-recipe-fs:recipes");
        Map<String, Collection<ScriptRecipe>> env = Map.of("recipes", scriptRecipes);
        try (FileSystem fs = FileSystems.newFileSystem(uri, env);){
            Path root = fs.getRootDirectories().iterator().next();
            CraftTweakerAPI.getScriptRunManager().createScriptRun(root, configuration).execute();
        }
    }

    public static enum UpdatedState {
        NONE(false, false),
        RECIPES(true, false),
        TAGS(false, true),
        ALL(true, true);

        private final boolean hasRecipes;
        private final boolean hasTags;

        private UpdatedState(boolean hasRecipes, boolean hasTags) {
            this.hasRecipes = hasRecipes;
            this.hasTags = hasTags;
        }

        public boolean hasRecipes() {
            return this.hasRecipes;
        }

        public boolean hasTags() {
            return this.hasTags;
        }

        public boolean hasAll() {
            return this.hasRecipes && this.hasTags;
        }

        public static UpdatedState of(boolean hasRecipes, boolean hasTags) {
            if (hasRecipes) {
                if (hasTags) {
                    return ALL;
                }
                return RECIPES;
            }
            if (hasTags) {
                return TAGS;
            }
            return NONE;
        }

        public UpdatedState merge(UpdatedState other) {
            return UpdatedState.of(this.hasRecipes || other.hasRecipes, this.hasTags || other.hasTags);
        }
    }
}

