/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.recipe.serializer;

import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.MirrorAxis;
import com.blamejared.crafttweaker.api.recipe.fun.RecipeFunction2D;
import com.blamejared.crafttweaker.api.recipe.type.CTShapedRecipe;
import com.blamejared.crafttweaker.impl.helper.AccessibleElementsProvider;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class CTShapedRecipeSerializer
implements class_1865<CTShapedRecipe> {
    public static final CTShapedRecipeSerializer INSTANCE = new CTShapedRecipeSerializer();

    private CTShapedRecipeSerializer() {
    }

    public CTShapedRecipe fromJson(class_2960 resourceLocation, JsonObject jsonObject) {
        return this.makeRecipe(CraftTweakerConstants.rl("invalid_recipe"), IItemStack.of(new class_1799((class_1935)class_1802.field_8077)), new IIngredient[][]{{IItemStack.of(new class_1799((class_1935)class_1802.field_8077))}}, MirrorAxis.NONE, null);
    }

    public CTShapedRecipe fromNetwork(class_2960 recipeId, class_2540 buffer) {
        int height = buffer.method_10816();
        int width = buffer.method_10816();
        IIngredient[][] inputs = new IIngredient[height][width];
        for (int h = 0; h < inputs.length; ++h) {
            for (int w = 0; w < inputs[h].length; ++w) {
                inputs[h][w] = IIngredient.fromIngredient(class_1856.method_8086((class_2540)buffer));
            }
        }
        MirrorAxis mirrorAxis = (MirrorAxis)buffer.method_10818(MirrorAxis.class);
        class_1799 output = buffer.method_10819();
        return this.makeRecipe(recipeId, IItemStack.of(output), inputs, mirrorAxis, null);
    }

    public void toNetwork(class_2540 buffer, CTShapedRecipe recipe) {
        buffer.method_10804(recipe.method_8158());
        buffer.method_10804(recipe.method_8150());
        for (class_1856 ingredient : recipe.method_8117()) {
            ingredient.method_8088(buffer);
        }
        buffer.method_10817((Enum)recipe.getMirrorAxis());
        buffer.method_10793(AccessibleElementsProvider.get().registryAccess(recipe::method_8110));
    }

    public CTShapedRecipe makeRecipe(class_2960 recipeId, IItemStack output, IIngredient[][] ingredients, MirrorAxis mirrorAxis, @Nullable RecipeFunction2D function) {
        return new CTShapedRecipe(recipeId.method_12832(), output, ingredients, mirrorAxis, function);
    }
}

