/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.fabric.mixin;

import com.google.common.collect.ImmutableMap;
import com.google.common.hash.HashCode;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.TreeMap;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(targets={"net.minecraft.data.HashCache$ProviderCache"})
public abstract class HashCacheFabricMixin {
    @Shadow
    public abstract String comp_729();

    @Shadow
    public abstract ImmutableMap<Path, HashCode> comp_730();

    @Inject(at={@At(value="HEAD")}, method={"save"}, cancellable=true)
    private void hookWrite(Path path, Path outputPath, String header, CallbackInfo ci) throws IOException {
        if (!"botania".equals(System.getProperty("fabric-api.datagen.modid"))) {
            return;
        }
        ci.cancel();
        try (BufferedWriter writer = Files.newBufferedWriter(outputPath, StandardCharsets.UTF_8, new OpenOption[0]);){
            writer.write("// ");
            writer.write(this.comp_729());
            writer.write(9);
            writer.write(header.substring(header.indexOf(9) + 1));
            writer.newLine();
            TreeMap<String, String> sorted = new TreeMap<String, String>();
            for (Map.Entry entry : this.comp_730().entrySet()) {
                String relativePath = path.relativize((Path)entry.getKey()).toString().replace('\\', '/');
                sorted.put(relativePath, ((HashCode)entry.getValue()).toString());
            }
            for (Map.Entry entry : sorted.entrySet()) {
                writer.write((String)entry.getValue() + " " + (String)entry.getKey());
                writer.newLine();
            }
        }
    }
}

