/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data;

import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1294;
import net.minecraft.class_1299;
import net.minecraft.class_1322;
import net.minecraft.class_2405;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2960;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_5134;
import net.minecraft.class_7058;
import net.minecraft.class_7061;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.configdata.LooniumMobAttributeModifier;
import vazkii.botania.api.configdata.LooniumMobEffectToApply;
import vazkii.botania.api.configdata.LooniumMobSpawnData;
import vazkii.botania.api.configdata.LooniumStructureConfiguration;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.common.loot.BotaniaLootTables;

public class LooniumStructureConfigurationProvider
implements class_2405 {
    public static final String LOONIUM_MODIFIER_DAMAGE = "Loonium Modifier Damage";
    public static final String LOONIUM_MODIFIER_HEALTH = "Loonium Modifier Health";
    private final class_7784.class_7489 pathProvider;

    public LooniumStructureConfigurationProvider(class_7784 packOutput) {
        this.pathProvider = packOutput.method_45973(class_7784.class_7490.field_39367, "loonium_config");
    }

    @NotNull
    public CompletableFuture<?> method_10319(@NotNull class_7403 cache) {
        HashMap<class_2960, LooniumStructureConfiguration> configs = new HashMap<class_2960, LooniumStructureConfiguration>();
        this.addConfigs(configs);
        ArrayList<CompletableFuture> output = new ArrayList<CompletableFuture>(configs.size());
        for (Map.Entry e : configs.entrySet()) {
            Path path = this.pathProvider.method_44107((class_2960)e.getKey());
            LooniumStructureConfiguration config = (LooniumStructureConfiguration)e.getValue();
            JsonElement jsonTree = (JsonElement)LooniumStructureConfiguration.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)config).getOrThrow(false, arg_0 -> ((Logger)BotaniaAPI.LOGGER).error(arg_0));
            output.add(class_2405.method_10320((class_7403)cache, (JsonElement)jsonTree, (Path)path));
        }
        return CompletableFuture.allOf((CompletableFuture[])output.toArray(CompletableFuture[]::new));
    }

    private void addConfigs(Map<class_2960, LooniumStructureConfiguration> configs) {
        class_2960 defaultConfigId = LooniumStructureConfiguration.DEFAULT_CONFIG_ID;
        configs.put(defaultConfigId, LooniumStructureConfigurationProvider.getDefaultConfig());
        configs.put(class_7058.field_38428.method_29177(), LooniumStructureConfigurationProvider.getConfigAncientCity(defaultConfigId));
        configs.put(class_7058.field_37186.method_29177(), LooniumStructureConfigurationProvider.getConfigBastionRemnant(defaultConfigId));
        configs.put(class_7058.field_37173.method_29177(), LooniumStructureConfigurationProvider.getConfigDesertPyramid(defaultConfigId));
        configs.put(class_7058.field_37184.method_29177(), LooniumStructureConfigurationProvider.getConfigEndCity(defaultConfigId));
        configs.put(class_7058.field_37182.method_29177(), LooniumStructureConfigurationProvider.getConfigFortress(defaultConfigId));
        configs.put(class_7058.field_37172.method_29177(), LooniumStructureConfigurationProvider.getConfigJungleTemple(defaultConfigId));
        configs.put(class_7058.field_37179.method_29177(), LooniumStructureConfigurationProvider.getConfigOceanMonument(defaultConfigId));
        class_2960 oceanRuinId = ResourceLocationHelper.prefix("ocean_ruins");
        configs.put(oceanRuinId, LooniumStructureConfiguration.forParent(defaultConfigId).boundingBoxType(class_7061.class_7062.field_37200).build());
        configs.put(class_7058.field_37180.method_29177(), LooniumStructureConfigurationProvider.getConfigOceanRuinCold(oceanRuinId));
        configs.put(class_7058.field_37181.method_29177(), LooniumStructureConfigurationProvider.getConfigOceanRuinWarm(oceanRuinId));
        configs.put(class_7058.field_37168.method_29177(), LooniumStructureConfigurationProvider.getConfigPillagerOutpost(defaultConfigId));
        configs.put(class_7058.field_37193.method_29177(), LooniumStructureConfigurationProvider.getConfigRuinedPortalDesert(defaultConfigId));
        configs.put(class_7058.field_37163.method_29177(), LooniumStructureConfigurationProvider.getConfigRuinedPortalJungle(defaultConfigId));
        configs.put(class_7058.field_37165.method_29177(), LooniumStructureConfigurationProvider.getConfigRuinedPortalMountain(defaultConfigId));
        configs.put(class_7058.field_37167.method_29177(), LooniumStructureConfigurationProvider.getConfigRuinedPortalNether(defaultConfigId));
        configs.put(class_7058.field_37166.method_29177(), LooniumStructureConfigurationProvider.getConfigRuinedPortalOcean(defaultConfigId));
        configs.put(class_7058.field_37192.method_29177(), LooniumStructureConfigurationProvider.getConfigRuinedPortalStandard(defaultConfigId));
        configs.put(class_7058.field_37164.method_29177(), LooniumStructureConfigurationProvider.getConfigRuinedPortalSwamp(defaultConfigId));
        configs.put(class_7058.field_37175.method_29177(), LooniumStructureConfigurationProvider.getConfigShipwreck(defaultConfigId));
        configs.put(class_7058.field_37176.method_29177(), LooniumStructureConfiguration.forParent(class_7058.field_37175.method_29177()).build());
        configs.put(class_7058.field_37178.method_29177(), LooniumStructureConfigurationProvider.getConfigStronghold(defaultConfigId));
        configs.put(class_7058.field_43326.method_29177(), LooniumStructureConfigurationProvider.getConfigTrailRuins(defaultConfigId));
        class_2960 villageId = ResourceLocationHelper.prefix("village");
        configs.put(villageId, LooniumStructureConfiguration.forParent(defaultConfigId).boundingBoxType(class_7061.class_7062.field_37200).build());
        configs.put(class_7058.field_37188.method_29177(), LooniumStructureConfigurationProvider.getConfigVillageDesert(villageId));
        configs.put(class_7058.field_37187.method_29177(), LooniumStructureConfigurationProvider.getConfigVillagePlains(villageId));
        configs.put(class_7058.field_37189.method_29177(), LooniumStructureConfigurationProvider.getConfigVillageSavanna(villageId));
        configs.put(class_7058.field_37190.method_29177(), LooniumStructureConfigurationProvider.getConfigVillageSnowy(villageId));
        configs.put(class_7058.field_37191.method_29177(), LooniumStructureConfigurationProvider.getConfigVillageTaiga(villageId));
        configs.put(class_7058.field_37171.method_29177(), LooniumStructureConfigurationProvider.getConfigWoodlandMansion(defaultConfigId));
    }

    public static LooniumStructureConfiguration getDefaultConfig() {
        return LooniumStructureConfiguration.builder().manaCost(35000).maxNearbyMobs(10).boundingBoxType(class_7061.class_7062.field_37199).spawnedMobs(LooniumMobSpawnData.entityWeight(class_1299.field_6091, 40).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(195, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(class_1299.field_6071, 59).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_SWORD).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6123, 106).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_TRIDENT).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6051, 423).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_SWORD).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6098, 59).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BOW).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6137, 529).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BOW).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6084, 59).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6079, 529).build()).attributeModifiers(new LooniumMobAttributeModifier(LOONIUM_MODIFIER_HEALTH, class_5134.field_23716, 2.0, class_1322.class_1323.field_6330), new LooniumMobAttributeModifier(LOONIUM_MODIFIER_DAMAGE, class_5134.field_23721, 1.5, class_1322.class_1323.field_6330)).effectsToApply(LooniumStructureConfigurationProvider.getStandardEffects(false, true)).build();
    }

    public static LooniumStructureConfiguration getConfigAncientCity(class_2960 parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(class_1299.field_6091, 30).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(99, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(class_1299.field_6071, 40).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_ANCIENT_CITY).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6123, 80).equipmentTable(BotaniaLootTables.LOONIUM_DROWNED_ANCIENT_CITY).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6051, 410).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_ANCIENT_CITY).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6098, 60).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_ANCIENT_CITY).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6137, 440).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_ANCIENT_CITY).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6084, 100).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6079, 200).build()).build();
    }

    public static LooniumStructureConfiguration getConfigBastionRemnant(class_2960 parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(class_1299.field_6091, 30).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(99, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getPiglinSpawnData(450, BotaniaLootTables.LOONIUM_PIGLIN_BASTION_REMNANT, false, false), LooniumMobSpawnData.entityWeight(class_1299.field_25751, 50).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_AXE_GOLD).attributeModifiers(new LooniumMobAttributeModifier(LOONIUM_MODIFIER_HEALTH, class_5134.field_23716, 1.5, class_1322.class_1323.field_6330), new LooniumMobAttributeModifier(LOONIUM_MODIFIER_DAMAGE, class_5134.field_23721, 1.5, class_1322.class_1323.field_6330)).build(), LooniumMobSpawnData.entityWeight(class_1299.field_21973, 300).spawnAsAdult().build()).build();
    }

    public static LooniumStructureConfiguration getConfigDesertPyramid(class_2960 parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(class_1299.field_6091, 50).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(149, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(class_1299.field_6071, 450).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_DESERT_PYRAMID).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6051, 50).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_DESERT_PYRAMID).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6137, 500).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_DESERT_PYRAMID).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6084, 40).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6079, 360).build()).build();
    }

    public static LooniumStructureConfiguration getConfigEndCity(class_2960 parentId) {
        LooniumMobEffectToApply[] creeperEffects = new LooniumMobEffectToApply[]{LooniumMobEffectToApply.effect(class_1294.field_5918).duration(100).build(), LooniumMobEffectToApply.effect(class_1294.field_5924).duration(100).build(), LooniumMobEffectToApply.effect(class_1294.field_5906).duration(400).build()};
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(class_1299.field_6109, 100).effectsToApply(LooniumStructureConfigurationProvider.getStandardEffects(true, true)).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6091, 300).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(99, false, creeperEffects), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, creeperEffects), LooniumMobSpawnData.entityWeight(class_1299.field_6051, 300).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_END_CITY).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6137, 300).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_END_CITY).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6079, 300).build()).effectsToApply(LooniumMobEffectToApply.effect(class_1294.field_5918).build(), LooniumMobEffectToApply.effect(class_1294.field_5924).build(), LooniumMobEffectToApply.effect(class_1294.field_5906).build()).build();
    }

    public static LooniumStructureConfiguration getConfigFortress(class_2960 parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(class_1299.field_6091, 30).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(99, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(class_1299.field_6099, 300).effectsToApply(LooniumStructureConfigurationProvider.getStandardEffects(false, false)).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6076, 450).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_FORTRESS).effectsToApply(LooniumStructureConfigurationProvider.getStandardEffects(false, false)).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6137, 50).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_FORTRESS).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6050, 400).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_FORTRESS).effectsToApply(LooniumStructureConfigurationProvider.getStandardEffects(false, false)).build()).build();
    }

    public static LooniumStructureConfiguration getConfigJungleTemple(class_2960 parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(class_1299.field_6091, 30).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(149, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(class_1299.field_6123, 40).equipmentTable(BotaniaLootTables.LOONIUM_DROWNED_JUNGLE_TEMPLE).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6051, 360).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_JUNGLE_TEMPLE).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6137, 500).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_JUNGLE_TEMPLE).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6084, 300).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6079, 300).build()).build();
    }

    public static LooniumStructureConfiguration getConfigOceanMonument(class_2960 parentId) {
        LooniumMobEffectToApply[] standardEffectsInWater = LooniumStructureConfigurationProvider.getStandardEffects(true, true);
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(class_1299.field_6118, 200).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(199, false, LooniumStructureConfigurationProvider.getCreeperEffects(true)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(true)), LooniumMobSpawnData.entityWeight(class_1299.field_6123, 540).equipmentTable(BotaniaLootTables.LOONIUM_DROWNED_MONUMENT).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6051, 60).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_MONUMENT).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6098, 40).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_MONUMENT).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6137, 360).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_MONUMENT).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6084, 30).effectsToApply(standardEffectsInWater).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6079, 270).effectsToApply(standardEffectsInWater).build()).build();
    }

    public static LooniumStructureConfiguration getConfigOceanRuinCold(class_2960 parentId) {
        LooniumMobEffectToApply[] standardEffectsInWater = LooniumStructureConfigurationProvider.getStandardEffects(true, true);
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumStructureConfigurationProvider.getCreeperSpawnData(199, false, LooniumStructureConfigurationProvider.getCreeperEffects(true)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(true)), LooniumMobSpawnData.entityWeight(class_1299.field_6123, 540).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_TRIDENT).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6051, 60).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_SWORD).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6098, 40).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BOW).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6137, 360).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BOW).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6084, 30).effectsToApply(standardEffectsInWater).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6079, 270).effectsToApply(standardEffectsInWater).build()).build();
    }

    public static LooniumStructureConfiguration getConfigOceanRuinWarm(class_2960 parentId) {
        LooniumMobEffectToApply[] standardEffectsInWater = LooniumStructureConfigurationProvider.getStandardEffects(true, true);
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumStructureConfigurationProvider.getCreeperSpawnData(199, false, LooniumStructureConfigurationProvider.getCreeperEffects(true)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(true)), LooniumMobSpawnData.entityWeight(class_1299.field_6123, 540).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_TRIDENT).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6051, 60).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_SWORD).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6137, 400).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BOW).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6084, 30).effectsToApply(standardEffectsInWater).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6079, 270).effectsToApply(standardEffectsInWater).build()).build();
    }

    public static LooniumStructureConfiguration getConfigPillagerOutpost(class_2960 parentId) {
        return LooniumStructureConfiguration.forParent(parentId).boundingBoxType(class_7061.class_7062.field_37200).spawnedMobs(LooniumMobSpawnData.entityWeight(class_1299.field_6091, 40).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(199, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(class_1299.field_6105, 900).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_CROSSBOW).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6117, 175).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_AXE).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6090, 25).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6137, 200).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_OUTPOST).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6051, 200).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_OUTPOST).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6079, 200).build()).build();
    }

    public static LooniumStructureConfiguration getConfigRuinedPortalDesert(class_2960 parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(class_1299.field_23696, 25).effectsToApply(LooniumStructureConfigurationProvider.getStandardEffects(false, false)).build(), LooniumStructureConfigurationProvider.getPiglinSpawnData(50, BotaniaLootTables.LOONIUM_PIGLIN_PORTAL, false, true), LooniumMobSpawnData.entityWeight(class_1299.field_6050, 50).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6091, 50).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(149, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(class_1299.field_6071, 450).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6051, 50).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6137, 450).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_PORTAL).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6079, 360).build()).build();
    }

    public static LooniumStructureConfiguration getConfigRuinedPortalJungle(class_2960 parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(class_1299.field_23696, 25).effectsToApply(LooniumStructureConfigurationProvider.getStandardEffects(false, false)).build(), LooniumStructureConfigurationProvider.getPiglinSpawnData(50, BotaniaLootTables.LOONIUM_PIGLIN_PORTAL, false, true), LooniumMobSpawnData.entityWeight(class_1299.field_6050, 50).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6091, 30).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(149, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(class_1299.field_6123, 40).equipmentTable(BotaniaLootTables.LOONIUM_DROWNED_PORTAL).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6051, 360).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6137, 500).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_PORTAL).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6084, 250).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6079, 50).build()).build();
    }

    public static LooniumStructureConfiguration getConfigRuinedPortalMountain(class_2960 parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(class_1299.field_23696, 25).effectsToApply(LooniumStructureConfigurationProvider.getStandardEffects(false, false)).build(), LooniumStructureConfigurationProvider.getPiglinSpawnData(50, BotaniaLootTables.LOONIUM_PIGLIN_PORTAL, false, true), LooniumMobSpawnData.entityWeight(class_1299.field_6050, 50).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6091, 40).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(195, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(class_1299.field_6051, 529).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6098, 59).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_PORTAL).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6137, 529).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_PORTAL).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6125, 59).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6079, 529).build()).build();
    }

    public static LooniumStructureConfiguration getConfigRuinedPortalNether(class_2960 parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(class_1299.field_23696, 125).effectsToApply(LooniumStructureConfigurationProvider.getStandardEffects(false, false)).build(), LooniumStructureConfigurationProvider.getPiglinSpawnData(500, BotaniaLootTables.LOONIUM_PIGLIN_PORTAL, false, false), LooniumMobSpawnData.entityWeight(class_1299.field_6050, 450).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6091, 40).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(195, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(class_1299.field_6051, 50).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6137, 200).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_PORTAL).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6084, 10).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6079, 90).build()).build();
    }

    public static LooniumStructureConfiguration getConfigRuinedPortalOcean(class_2960 parentId) {
        LooniumMobEffectToApply[] standardEffectsInWater = LooniumStructureConfigurationProvider.getStandardEffects(true, true);
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(class_1299.field_23696, 25).effectsToApply(LooniumStructureConfigurationProvider.getStandardEffects(false, false)).build(), LooniumStructureConfigurationProvider.getPiglinSpawnData(50, BotaniaLootTables.LOONIUM_PIGLIN_PORTAL, true, true), LooniumMobSpawnData.entityWeight(class_1299.field_6050, 50).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(199, false, LooniumStructureConfigurationProvider.getCreeperEffects(true)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(true)), LooniumMobSpawnData.entityWeight(class_1299.field_6123, 540).equipmentTable(BotaniaLootTables.LOONIUM_DROWNED_PORTAL).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6051, 60).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6137, 400).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_PORTAL).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6084, 30).effectsToApply(standardEffectsInWater).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6079, 270).effectsToApply(standardEffectsInWater).build()).build();
    }

    public static LooniumStructureConfiguration getConfigRuinedPortalStandard(class_2960 parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(class_1299.field_23696, 25).effectsToApply(LooniumStructureConfigurationProvider.getStandardEffects(false, false)).build(), LooniumStructureConfigurationProvider.getPiglinSpawnData(50, BotaniaLootTables.LOONIUM_PIGLIN_PORTAL, false, true), LooniumMobSpawnData.entityWeight(class_1299.field_6050, 50).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6091, 40).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(195, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(class_1299.field_6071, 59).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6123, 106).equipmentTable(BotaniaLootTables.LOONIUM_DROWNED_PORTAL).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6051, 423).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6098, 59).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_PORTAL).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6137, 529).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_PORTAL).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6084, 59).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6079, 529).build()).build();
    }

    public static LooniumStructureConfiguration getConfigRuinedPortalSwamp(class_2960 parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(class_1299.field_23696, 25).effectsToApply(LooniumStructureConfigurationProvider.getStandardEffects(false, false)).build(), LooniumStructureConfigurationProvider.getPiglinSpawnData(50, BotaniaLootTables.LOONIUM_PIGLIN_PORTAL, false, true), LooniumMobSpawnData.entityWeight(class_1299.field_6050, 50).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6091, 30).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(149, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(class_1299.field_6123, 40).equipmentTable(BotaniaLootTables.LOONIUM_DROWNED_PORTAL).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6051, 360).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6137, 500).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_PORTAL).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6084, 50).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6079, 250).build()).build();
    }

    public static LooniumStructureConfiguration getConfigShipwreck(class_2960 parentId) {
        LooniumMobEffectToApply[] standardEffectsInWater = LooniumStructureConfigurationProvider.getStandardEffects(true, true);
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumStructureConfigurationProvider.getCreeperSpawnData(199, false, LooniumStructureConfigurationProvider.getCreeperEffects(true)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(true)), LooniumMobSpawnData.entityWeight(class_1299.field_6123, 540).equipmentTable(BotaniaLootTables.LOONIUM_DROWNED_SHIPWRECK).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6051, 60).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_SHIPWRECK).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6098, 40).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_SHIPWRECK).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6137, 360).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_SHIPWRECK).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6084, 30).effectsToApply(standardEffectsInWater).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6079, 270).effectsToApply(standardEffectsInWater).build()).build();
    }

    public static LooniumStructureConfiguration getConfigStronghold(class_2960 parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(class_1299.field_6091, 80).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(149, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(class_1299.field_6071, 40).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_STRONGHOLD).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6123, 40).equipmentTable(BotaniaLootTables.LOONIUM_DROWNED_STRONGHOLD).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6051, 410).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_STRONGHOLD).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6098, 60).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_STRONGHOLD).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6137, 440).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_STRONGHOLD).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6084, 100).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6125, 100).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6079, 400).build()).build();
    }

    public static LooniumStructureConfiguration getConfigTrailRuins(class_2960 parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(class_1299.field_6091, 40).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(195, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(class_1299.field_6071, 59).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_TRAIL_RUINS).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6123, 106).equipmentTable(BotaniaLootTables.LOONIUM_DROWNED_TRAIL_RUINS).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6051, 423).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_TRAIL_RUINS).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6098, 59).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_TRAIL_RUINS).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6137, 529).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_TRAIL_RUINS).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6084, 59).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6079, 529).build()).build();
    }

    public static LooniumStructureConfiguration getConfigVillageDesert(class_2960 parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(class_1299.field_6091, 40).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(195, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(class_1299.field_6071, 423).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_SWORD).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6051, 59).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_SWORD).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6054, 106).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BY_PROFESSION).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6137, 600).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BOW).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6084, 59).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6079, 529).build()).build();
    }

    public static LooniumStructureConfiguration getConfigVillagePlains(class_2960 parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(class_1299.field_6091, 40).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(195, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(class_1299.field_6123, 59).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_TRIDENT).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6051, 423).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_SWORD).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6054, 106).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BY_PROFESSION).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6137, 600).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BOW).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6084, 59).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6079, 529).build()).build();
    }

    public static LooniumStructureConfiguration getConfigVillageSavanna(class_2960 parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(class_1299.field_6091, 40).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(195, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(class_1299.field_6123, 30).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_TRIDENT).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6071, 30).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_SWORD).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6051, 423).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_SWORD).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6054, 106).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BY_PROFESSION).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6137, 600).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BOW).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6084, 59).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6079, 529).build()).build();
    }

    public static LooniumStructureConfiguration getConfigVillageSnowy(class_2960 parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(class_1299.field_6091, 40).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(195, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(class_1299.field_6123, 59).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_TRIDENT).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6051, 423).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_SWORD).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6054, 106).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BY_PROFESSION).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6098, 529).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BOW).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6137, 59).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BOW).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6084, 59).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6079, 529).build()).build();
    }

    public static LooniumStructureConfiguration getConfigVillageTaiga(class_2960 parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(class_1299.field_6091, 40).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(195, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(class_1299.field_6123, 59).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_TRIDENT).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6051, 423).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_SWORD).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6054, 106).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BY_PROFESSION).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6098, 106).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BOW).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6137, 423).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BOW).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6084, 59).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6079, 529).build()).build();
    }

    public static LooniumStructureConfiguration getConfigWoodlandMansion(class_2960 parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(class_1299.field_6091, 40).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(199, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(class_1299.field_6117, 600).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_AXE).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6105, 200).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_CROSSBOW).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6090, 100).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6051, 150).equipmentTable(BotaniaLootTables.LOONIUM_ARMOR_MANSION).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6051, 50).spawnAsBaby().equipmentTable(BotaniaLootTables.LOONIUM_ARMOR_MANSION).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6137, 200).equipmentTable(BotaniaLootTables.LOONIUM_ARMOR_MANSION).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6084, 30).build(), LooniumMobSpawnData.entityWeight(class_1299.field_6079, 270).build()).build();
    }

    public static LooniumMobEffectToApply[] getStandardEffects(boolean withWaterBreathing, boolean withFireResistance) {
        LooniumMobEffectToApply[] looniumMobEffectToApplyArray;
        if (withFireResistance) {
            if (withWaterBreathing) {
                LooniumMobEffectToApply[] looniumMobEffectToApplyArray2 = new LooniumMobEffectToApply[3];
                looniumMobEffectToApplyArray2[0] = LooniumMobEffectToApply.effect(class_1294.field_5918).build();
                looniumMobEffectToApplyArray2[1] = LooniumMobEffectToApply.effect(class_1294.field_5924).build();
                looniumMobEffectToApplyArray = looniumMobEffectToApplyArray2;
                looniumMobEffectToApplyArray2[2] = LooniumMobEffectToApply.effect(class_1294.field_5923).build();
            } else {
                LooniumMobEffectToApply[] looniumMobEffectToApplyArray3 = new LooniumMobEffectToApply[2];
                looniumMobEffectToApplyArray3[0] = LooniumMobEffectToApply.effect(class_1294.field_5918).build();
                looniumMobEffectToApplyArray = looniumMobEffectToApplyArray3;
                looniumMobEffectToApplyArray3[1] = LooniumMobEffectToApply.effect(class_1294.field_5924).build();
            }
        } else if (withWaterBreathing) {
            LooniumMobEffectToApply[] looniumMobEffectToApplyArray4 = new LooniumMobEffectToApply[2];
            looniumMobEffectToApplyArray4[0] = LooniumMobEffectToApply.effect(class_1294.field_5924).build();
            looniumMobEffectToApplyArray = looniumMobEffectToApplyArray4;
            looniumMobEffectToApplyArray4[1] = LooniumMobEffectToApply.effect(class_1294.field_5923).build();
        } else {
            LooniumMobEffectToApply[] looniumMobEffectToApplyArray5 = new LooniumMobEffectToApply[1];
            looniumMobEffectToApplyArray = looniumMobEffectToApplyArray5;
            looniumMobEffectToApplyArray5[0] = LooniumMobEffectToApply.effect(class_1294.field_5924).build();
        }
        return looniumMobEffectToApplyArray;
    }

    public static LooniumMobEffectToApply[] getCreeperEffects(boolean withWaterBreathing) {
        LooniumMobEffectToApply[] looniumMobEffectToApplyArray;
        if (withWaterBreathing) {
            LooniumMobEffectToApply[] looniumMobEffectToApplyArray2 = new LooniumMobEffectToApply[3];
            looniumMobEffectToApplyArray2[0] = LooniumMobEffectToApply.effect(class_1294.field_5918).duration(100).build();
            looniumMobEffectToApplyArray2[1] = LooniumMobEffectToApply.effect(class_1294.field_5924).duration(100).build();
            looniumMobEffectToApplyArray = looniumMobEffectToApplyArray2;
            looniumMobEffectToApplyArray2[2] = LooniumMobEffectToApply.effect(class_1294.field_5923).build();
        } else {
            LooniumMobEffectToApply[] looniumMobEffectToApplyArray3 = new LooniumMobEffectToApply[2];
            looniumMobEffectToApplyArray3[0] = LooniumMobEffectToApply.effect(class_1294.field_5918).duration(100).build();
            looniumMobEffectToApplyArray = looniumMobEffectToApplyArray3;
            looniumMobEffectToApplyArray3[1] = LooniumMobEffectToApply.effect(class_1294.field_5924).duration(100).build();
        }
        return looniumMobEffectToApplyArray;
    }

    public static LooniumMobSpawnData getCreeperSpawnData(int weight, boolean charged, LooniumMobEffectToApply ... creeperEffects) {
        class_2487 chargedCreeperNbt;
        if (charged) {
            chargedCreeperNbt = new class_2487();
            chargedCreeperNbt.method_10556("powered", true);
        } else {
            chargedCreeperNbt = null;
        }
        return LooniumMobSpawnData.entityWeight(class_1299.field_6046, weight).nbt(chargedCreeperNbt).effectsToApply(creeperEffects).build();
    }

    public static LooniumMobSpawnData getPiglinSpawnData(int weight, class_2960 equipmentTable, boolean needWaterBreathing, boolean zombificationImmune) {
        class_2487 piglinNbt = new class_2487();
        if (zombificationImmune) {
            piglinNbt.method_10556("IsImmuneToZombification", true);
        }
        class_4095 piglinBrain = class_4095.method_28311(List.of(class_4140.field_25361, class_4140.field_22473, class_4140.field_22350), List.of()).method_28335(new Dynamic((DynamicOps)class_2509.field_11560));
        piglinBrain.method_18878(class_4140.field_25361, (Object)true);
        piglinBrain.method_18878(class_4140.field_22473, (Object)true);
        piglinBrain.method_18878(class_4140.field_22350, (Object)true);
        DataResult dataResult = piglinBrain.method_28310((DynamicOps)class_2509.field_11560);
        dataResult.resultOrPartial(arg_0 -> ((Logger)BotaniaAPI.LOGGER).error(arg_0)).ifPresent(tag -> piglinNbt.method_10566("Brain", tag));
        return LooniumMobSpawnData.entityWeight(class_1299.field_22281, weight).spawnAsAdult().nbt(piglinNbt).equipmentTable(equipmentTable).effectsToApply(LooniumStructureConfigurationProvider.getStandardEffects(needWaterBreathing, true)).build();
    }

    @NotNull
    public String method_10321() {
        return "Loonium structure configuration";
    }
}

