/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2512;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_6862;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.crafting.BlockStateIngredient;
import vazkii.botania.common.crafting.BlockStateStateIngredient;
import vazkii.botania.common.crafting.BlocksStateIngredient;
import vazkii.botania.common.crafting.CompoundStateIngredient;
import vazkii.botania.common.crafting.TagExcludingStateIngredient;
import vazkii.botania.common.crafting.TagStateIngredient;
import vazkii.botania.common.helper.ItemNBTHelper;

public class StateIngredientHelper {
    public static StateIngredient of(class_2248 block) {
        return new BlockStateIngredient(block);
    }

    public static StateIngredient of(class_2680 state) {
        return new BlockStateStateIngredient(state);
    }

    public static StateIngredient of(class_6862<class_2248> tag) {
        return StateIngredientHelper.of(tag.comp_327());
    }

    public static StateIngredient of(class_2960 id) {
        return new TagStateIngredient(id);
    }

    public static StateIngredient of(Collection<class_2248> blocks) {
        return new BlocksStateIngredient(blocks);
    }

    public static StateIngredient compound(Collection<StateIngredient> ingredients) {
        return new CompoundStateIngredient(ingredients);
    }

    public static StateIngredient combine(StateIngredient firstIngredient, StateIngredient secondIngredient) {
        CompoundStateIngredient compound;
        ArrayList<StateIngredient> ingredients = new ArrayList<StateIngredient>();
        if (firstIngredient instanceof CompoundStateIngredient) {
            compound = (CompoundStateIngredient)firstIngredient;
            ingredients.addAll((Collection<StateIngredient>)compound.getIngredients());
        } else {
            ingredients.add(firstIngredient);
        }
        if (secondIngredient instanceof CompoundStateIngredient) {
            compound = (CompoundStateIngredient)secondIngredient;
            ingredients.addAll((Collection<StateIngredient>)compound.getIngredients());
        } else {
            ingredients.add(secondIngredient);
        }
        return new CompoundStateIngredient(ingredients);
    }

    public static StateIngredient tagExcluding(class_6862<class_2248> tag, StateIngredient ... excluded) {
        return new TagExcludingStateIngredient(tag.comp_327(), List.of(excluded));
    }

    public static StateIngredient deserialize(JsonObject object) {
        switch (class_3518.method_15265((JsonObject)object, (String)"type")) {
            case "tag": {
                return new TagStateIngredient(new class_2960(class_3518.method_15265((JsonObject)object, (String)"tag")));
            }
            case "block": {
                return new BlockStateIngredient((class_2248)class_7923.field_41175.method_10223(new class_2960(class_3518.method_15265((JsonObject)object, (String)"block"))));
            }
            case "state": {
                return new BlockStateStateIngredient(StateIngredientHelper.readBlockState(object));
            }
            case "blocks": {
                ArrayList<class_2248> blocks = new ArrayList<class_2248>();
                for (JsonElement element : class_3518.method_15261((JsonObject)object, (String)"blocks")) {
                    blocks.add((class_2248)class_7923.field_41175.method_10223(new class_2960(element.getAsString())));
                }
                return new BlocksStateIngredient(blocks);
            }
            case "tag_excluding": {
                class_2960 tag = new class_2960(class_3518.method_15265((JsonObject)object, (String)"tag"));
                ArrayList<StateIngredient> ingr = new ArrayList<StateIngredient>();
                for (JsonElement element : class_3518.method_15261((JsonObject)object, (String)"exclude")) {
                    ingr.add(StateIngredientHelper.deserialize(class_3518.method_15295((JsonElement)element, (String)"exclude entry")));
                }
                return new TagExcludingStateIngredient(tag, ingr);
            }
            case "compound": {
                ArrayList<StateIngredient> stateIngredients = new ArrayList<StateIngredient>();
                for (JsonElement ingredient : class_3518.method_15261((JsonObject)object, (String)"ingredients")) {
                    if (!ingredient.isJsonObject()) {
                        throw new JsonParseException("Unknown ingredient in compound state ingredient: " + String.valueOf(ingredient));
                    }
                    stateIngredients.add(StateIngredientHelper.deserialize(ingredient.getAsJsonObject()));
                }
                return new CompoundStateIngredient(stateIngredients);
            }
        }
        throw new JsonParseException("Unknown type!");
    }

    @Nullable
    public static StateIngredient tryDeserialize(JsonObject object) {
        return StateIngredientHelper.clearTheAir(StateIngredientHelper.deserialize(object));
    }

    public static StateIngredient clearTheAir(StateIngredient ingredient) {
        if (ingredient instanceof BlockStateIngredient || ingredient instanceof BlockStateStateIngredient) {
            if (ingredient.test(class_2246.field_10124.method_9564())) {
                return null;
            }
        } else if (ingredient instanceof BlocksStateIngredient) {
            BlocksStateIngredient sib = (BlocksStateIngredient)ingredient;
            ImmutableSet<class_2248> blocks = sib.blocks;
            ArrayList<class_2248> list = new ArrayList<class_2248>((Collection<class_2248>)blocks);
            if (list.removeIf(b -> b == class_2246.field_10124)) {
                if (list.size() == 0) {
                    return null;
                }
                return StateIngredientHelper.of(list);
            }
        } else if (ingredient instanceof CompoundStateIngredient) {
            CompoundStateIngredient sic = (CompoundStateIngredient)ingredient;
            List<StateIngredient> newIngredients = sic.getIngredients().stream().map(StateIngredientHelper::clearTheAir).filter(Objects::nonNull).toList();
            if (newIngredients.isEmpty()) {
                return null;
            }
            return StateIngredientHelper.compound(newIngredients);
        }
        return ingredient;
    }

    public static StateIngredient read(class_2540 buffer) {
        switch (buffer.method_10816()) {
            case 0: {
                int count = buffer.method_10816();
                HashSet<class_2248> set = new HashSet<class_2248>();
                for (int i = 0; i < count; ++i) {
                    int id = buffer.method_10816();
                    class_2248 block = (class_2248)class_7923.field_41175.method_10200(id);
                    set.add(block);
                }
                return new BlocksStateIngredient(set);
            }
            case 1: {
                return new BlockStateIngredient((class_2248)class_7923.field_41175.method_10200(buffer.method_10816()));
            }
            case 2: {
                return new BlockStateStateIngredient(class_2248.method_9531((int)buffer.method_10816()));
            }
            case 3: {
                int ingredientCount = buffer.method_10816();
                HashSet<StateIngredient> ingredientSet = new HashSet<StateIngredient>();
                for (int i = 0; i < ingredientCount; ++i) {
                    ingredientSet.add(StateIngredientHelper.read(buffer));
                }
                return new CompoundStateIngredient(ingredientSet);
            }
        }
        throw new IllegalArgumentException("Unknown input discriminator!");
    }

    public static JsonObject serializeBlockState(class_2680 state) {
        class_2487 nbt = class_2512.method_10686((class_2680)state);
        ItemNBTHelper.renameTag(nbt, "Name", "name");
        ItemNBTHelper.renameTag(nbt, "Properties", "properties");
        Dynamic dyn = new Dynamic((DynamicOps)class_2509.field_11560, (Object)nbt);
        return ((JsonElement)dyn.convert((DynamicOps)JsonOps.INSTANCE).getValue()).getAsJsonObject();
    }

    public static class_2680 readBlockState(JsonObject object) {
        class_2487 nbt = (class_2487)new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)object).convert((DynamicOps)class_2509.field_11560).getValue();
        ItemNBTHelper.renameTag(nbt, "name", "Name");
        ItemNBTHelper.renameTag(nbt, "properties", "Properties");
        String name = nbt.method_10558("Name");
        class_2960 id = class_2960.method_12829((String)name);
        if (id == null || class_7923.field_41175.method_17966(id).isEmpty()) {
            throw new IllegalArgumentException("Invalid or unknown block ID: " + name);
        }
        return class_2512.method_10681((class_7871)class_7923.field_41175.method_46771(), (class_2487)nbt);
    }
}

