/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.configdata.ConfigDataManager;
import vazkii.botania.api.configdata.LooniumStructureConfiguration;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.xplat.XplatAbstractions;

public class ConfigDataManagerImpl
implements ConfigDataManager {
    private final Map<class_2960, LooniumStructureConfiguration> looniumConfigs = new HashMap<class_2960, LooniumStructureConfiguration>();

    public static void registerListener() {
        XplatAbstractions.INSTANCE.registerReloadListener(class_3264.field_14190, ResourceLocationHelper.prefix("configdata"), new ConfigDataManagerImpl());
    }

    @Override
    @Nullable
    public LooniumStructureConfiguration getEffectiveLooniumStructureConfiguration(class_2960 id) {
        LooniumStructureConfiguration configuration = this.looniumConfigs.get(id);
        return configuration != null ? configuration.getEffectiveConfig(this.looniumConfigs::get) : null;
    }

    private static void validateLooniumConfig(Map<class_2960, LooniumStructureConfiguration> map) {
        HashSet<class_2960> errorEntries = new HashSet<class_2960>();
        LinkedHashSet<class_2960> visitedEntries = new LinkedHashSet<class_2960>();
        do {
            errorEntries.clear();
            for (Map.Entry<class_2960, LooniumStructureConfiguration> entry : map.entrySet()) {
                class_2960 parent;
                class_2960 id = entry.getKey();
                if (id.equals((Object)(parent = entry.getValue().parent))) {
                    BotaniaAPI.LOGGER.warn("Ignoring Loonium structure configuration, because it specified itself as parent: {}", (Object)id);
                    errorEntries.add(id);
                    continue;
                }
                visitedEntries.clear();
                if (ConfigDataManagerImpl.findTopmostParent(map, id, parent, visitedEntries)) continue;
                BotaniaAPI.LOGGER.warn("Ignoring Loonium structure configuration(s) without top-most parent: {}", visitedEntries);
                errorEntries.addAll(visitedEntries);
                break;
            }
            errorEntries.forEach(map::remove);
        } while (!errorEntries.isEmpty() && !map.isEmpty());
        if (!map.containsKey(LooniumStructureConfiguration.DEFAULT_CONFIG_ID)) {
            BotaniaAPI.LOGGER.error("Default Loonium configuration not found!");
        }
    }

    private static boolean findTopmostParent(Map<class_2960, LooniumStructureConfiguration> map, class_2960 id, class_2960 parent, Set<class_2960> visitedEntries) {
        if (!visitedEntries.add(id)) {
            BotaniaAPI.LOGGER.warn("Cyclic dependency between Loonium structure configurations detected: {}", visitedEntries);
            return false;
        }
        if (parent == null) {
            return true;
        }
        LooniumStructureConfiguration parentConfig = map.get(parent);
        return parentConfig != null && ConfigDataManagerImpl.findTopmostParent(map, parent, parentConfig.parent, visitedEntries);
    }

    private void applyLooniumConfig(Map<class_2960, LooniumStructureConfiguration> looniumConfigs) {
        BotaniaAPI.LOGGER.info("Loaded {} Loonium configurations", (Object)looniumConfigs.size());
        this.looniumConfigs.putAll(looniumConfigs);
    }

    @NotNull
    public CompletableFuture<Void> method_25931(@NotNull class_3302.class_4045 barrier, @NotNull class_3300 manager, @NotNull class_3695 prepProfiler, @NotNull class_3695 reloadProfiler, @NotNull Executor backgroundExecutor, @NotNull Executor gameExecutor) {
        CompletableFuture<Void> looniumTask = this.scheduleConfigParse(barrier, manager, backgroundExecutor, gameExecutor, ConfigDataType.LOONUIM);
        return CompletableFuture.allOf(looniumTask).thenRun(() -> BotaniaAPI.instance().setConfigData(this));
    }

    private <T> CompletableFuture<Void> scheduleConfigParse(class_3302.class_4045 barrier, class_3300 manager, Executor backgroundExecutor, Executor gameExecutor, ConfigDataType<T> type) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            HashMap<class_2960, JsonElement> resourceMap = new HashMap<class_2960, JsonElement>();
            class_4309.method_51148((class_3300)manager, (String)type.directory, (Gson)new Gson(), resourceMap);
            HashMap configs = new HashMap(resourceMap.size());
            resourceMap.forEach((id, jsonElement) -> {
                BotaniaAPI.LOGGER.debug("Parsing {} config '{}'", (Object)type.directory, id);
                type.codec.parse((DynamicOps)JsonOps.INSTANCE, jsonElement).result().ifPresent(c -> configs.put(id, c));
            });
            type.validateFunction.accept(configs);
            return configs;
        }, backgroundExecutor).thenCompose(arg_0 -> ((class_3302.class_4045)barrier).method_18352(arg_0))).thenAcceptAsync(c -> type.applyFunction.accept(this, (Map<class_2960, ConfigDataManagerImpl>)c), gameExecutor);
    }

    private record ConfigDataType<T>(Codec<T> codec, String directory, Consumer<Map<class_2960, T>> validateFunction, BiConsumer<ConfigDataManagerImpl, Map<class_2960, T>> applyFunction) {
        private static final ConfigDataType<LooniumStructureConfiguration> LOONUIM = new ConfigDataType<LooniumStructureConfiguration>(LooniumStructureConfiguration.CODEC, "loonium_config", ConfigDataManagerImpl::validateLooniumConfig, ConfigDataManagerImpl::applyLooniumConfig);
    }
}

