/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.mana;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2464;
import net.minecraft.class_247;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_3726;
import net.minecraft.class_3727;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.state.BotaniaStateProperties;
import vazkii.botania.common.block.BotaniaWaterloggedBlock;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.mana.ManaPoolBlockEntity;
import vazkii.botania.common.block.decor.BotaniaMushroomBlock;
import vazkii.botania.common.entity.ManaBurstEntity;
import vazkii.botania.common.item.material.MysticalPetalItem;

public class ManaPoolBlock
extends BotaniaWaterloggedBlock
implements class_2343 {
    private static final class_265 NORMAL_SHAPE;
    private static final class_265 DILUTED_SHAPE;
    private static final class_265 CREATIVE_SHAPE;
    private static final class_265 NORMAL_SHAPE_INTERACT;
    private static final class_265 DILUTED_SHAPE_INTERACT;
    private static final class_265 CREATIVE_SHAPE_INTERACT;
    public final Variant variant;

    public ManaPoolBlock(Variant v, class_4970.class_2251 builder) {
        super(builder);
        this.variant = v;
        this.method_9590((class_2680)this.method_9564().method_11657(BotaniaStateProperties.OPTIONAL_DYE_COLOR, (Comparable)((Object)BotaniaStateProperties.OptionalDyeColor.NONE)));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{BotaniaStateProperties.OPTIONAL_DYE_COLOR});
    }

    public void method_9568(class_1799 stack, @Nullable class_1922 world, List<class_2561> tooltip, class_1836 flag) {
        super.method_9568(stack, world, tooltip, flag);
        if (this.variant == Variant.CREATIVE) {
            for (int i = 0; i < 2; ++i) {
                tooltip.add((class_2561)class_2561.method_43471((String)("botaniamisc.creativePool" + i)).method_27692(class_124.field_1080));
            }
        }
    }

    @NotNull
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 ctx) {
        return switch (this.variant) {
            default -> throw new IncompatibleClassChangeError();
            case Variant.DILUTED -> DILUTED_SHAPE;
            case Variant.CREATIVE -> CREATIVE_SHAPE;
            case Variant.DEFAULT, Variant.FABULOUS -> NORMAL_SHAPE;
        };
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_3727 econtext;
        if (context instanceof class_3727 && (econtext = (class_3727)context).method_32480() instanceof ManaBurstEntity) {
            return switch (this.variant) {
                default -> throw new IncompatibleClassChangeError();
                case Variant.DILUTED -> DILUTED_SHAPE_INTERACT;
                case Variant.CREATIVE -> CREATIVE_SHAPE_INTERACT;
                case Variant.DEFAULT, Variant.FABULOUS -> NORMAL_SHAPE_INTERACT;
            };
        }
        return super.method_9549(state, world, pos, context);
    }

    @NotNull
    public class_265 method_9584(class_2680 state, class_1922 level, class_2338 pos) {
        return switch (this.variant) {
            default -> throw new IncompatibleClassChangeError();
            case Variant.DILUTED -> DILUTED_SHAPE_INTERACT;
            case Variant.CREATIVE -> CREATIVE_SHAPE_INTERACT;
            case Variant.DEFAULT, Variant.FABULOUS -> NORMAL_SHAPE_INTERACT;
        };
    }

    @NotNull
    public class_1269 method_9534(@NotNull class_2680 state, class_1937 world, @NotNull class_2338 pos, class_1657 player, @NotNull class_1268 hand, @NotNull class_3965 hit) {
        ManaPoolBlockEntity pool;
        class_2586 be = world.method_8321(pos);
        class_1799 stack = player.method_5998(hand);
        Optional<Object> itemColor = Optional.empty();
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof MysticalPetalItem) {
            MysticalPetalItem petalItem = (MysticalPetalItem)class_17922;
            itemColor = Optional.of(petalItem.color);
        }
        if ((class_17922 = class_2248.method_9503((class_1792)stack.method_7909())) instanceof BotaniaMushroomBlock) {
            BotaniaMushroomBlock mushroomBlock = (BotaniaMushroomBlock)class_17922;
            itemColor = Optional.of(mushroomBlock.color);
        }
        if (itemColor.isPresent() && be instanceof ManaPoolBlockEntity && !itemColor.equals((pool = (ManaPoolBlockEntity)be).getColor())) {
            pool.setColor(itemColor);
            if (!player.method_31549().field_7477) {
                stack.method_7934(1);
            }
            return class_1269.method_29236((boolean)world.method_8608());
        }
        if (stack.method_31574(class_1802.field_8696) && be instanceof ManaPoolBlockEntity && (pool = (ManaPoolBlockEntity)be).getColor().isPresent()) {
            pool.setColor(Optional.empty());
            if (!player.method_31549().field_7477) {
                stack.method_7934(1);
            }
            return class_1269.method_29236((boolean)world.method_8608());
        }
        return super.method_9534(state, world, pos, player, hand, hit);
    }

    @NotNull
    public class_2586 method_10123(@NotNull class_2338 pos, @NotNull class_2680 state) {
        return new ManaPoolBlockEntity(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
        return ManaPoolBlock.createTickerHelper(type, BotaniaBlockEntities.POOL, level.field_9236 ? ManaPoolBlockEntity::clientTick : ManaPoolBlockEntity::serverTick);
    }

    public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        if (entity instanceof class_1542) {
            class_1542 item = (class_1542)entity;
            ManaPoolBlockEntity tile = (ManaPoolBlockEntity)world.method_8321(pos);
            tile.collideEntityItem(item);
        }
    }

    @NotNull
    public class_2464 method_9604(class_2680 state) {
        if (this.variant == Variant.FABULOUS) {
            return class_2464.field_11456;
        }
        return class_2464.field_11458;
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        ManaPoolBlockEntity pool = (ManaPoolBlockEntity)world.method_8321(pos);
        return ManaPoolBlockEntity.calculateComparatorLevel(pool.getCurrentMana(), pool.getMaxMana());
    }

    static {
        NORMAL_SHAPE_INTERACT = ManaPoolBlock.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
        DILUTED_SHAPE_INTERACT = ManaPoolBlock.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0);
        CREATIVE_SHAPE_INTERACT = ManaPoolBlock.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);
        class_265 cutout = ManaPoolBlock.method_9541((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
        class_265 dilutedCutout = ManaPoolBlock.method_9541((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)6.0, (double)15.0);
        NORMAL_SHAPE = class_259.method_1072((class_265)NORMAL_SHAPE_INTERACT, (class_265)cutout, (class_247)class_247.field_16886);
        DILUTED_SHAPE = class_259.method_1072((class_265)DILUTED_SHAPE_INTERACT, (class_265)dilutedCutout, (class_247)class_247.field_16886);
        CREATIVE_SHAPE = class_259.method_1072((class_265)CREATIVE_SHAPE_INTERACT, (class_265)cutout, (class_247)class_247.field_16886);
    }

    public static enum Variant {
        DEFAULT,
        CREATIVE,
        DILUTED,
        FABULOUS;

    }
}

