/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1074;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3419;
import net.minecraft.class_4587;
import net.minecraft.class_5712;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block.Wandable;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.api.recipe.RunicAltarRecipe;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.client.gui.HUDHandler;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.SimpleInventoryBlockEntity;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.EntityHelper;
import vazkii.botania.common.helper.InventoryHelper;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.WandOfTheForestItem;
import vazkii.botania.common.item.material.RuneItem;
import vazkii.botania.common.proxy.Proxy;
import vazkii.botania.xplat.XplatAbstractions;

public class RunicAltarBlockEntity
extends SimpleInventoryBlockEntity
implements ManaReceiver,
Wandable {
    private static final String TAG_MANA = "mana";
    private static final String TAG_MANA_TO_GET = "manaToGet";
    private static final int SET_KEEP_TICKS_EVENT = 0;
    private static final int SET_COOLDOWN_EVENT = 1;
    private static final int CRAFT_EFFECT_EVENT = 2;
    private RunicAltarRecipe currentRecipe;
    public int manaToGet = 0;
    private int mana = 0;
    private int cooldown = 0;
    public int signal = 0;
    private List<class_1799> lastRecipe = null;
    private int recipeKeepTicks = 0;

    public RunicAltarBlockEntity(class_2338 pos, class_2680 state) {
        super(BotaniaBlockEntities.RUNE_ALTAR, pos, state);
    }

    public boolean addItem(@Nullable class_1657 player, class_1799 stack, @Nullable class_1268 hand) {
        if (this.cooldown > 0 || stack.method_7909() instanceof WandOfTheForestItem || stack.method_31574((class_1792)BotaniaItems.lexicon)) {
            return false;
        }
        if (stack.method_31574(BotaniaBlocks.livingrock.method_8389())) {
            if (!this.field_11863.field_9236) {
                class_1799 toSpawn = player != null && player.method_31549().field_7477 ? stack.method_7972().method_7971(1) : stack.method_7971(1);
                class_1542 item = new class_1542(this.field_11863, (double)this.method_11016().method_10263() + 0.5, (double)(this.method_11016().method_10264() + 1), (double)this.method_11016().method_10260() + 0.5, toSpawn);
                item.method_6982(40);
                item.method_18799(class_243.field_1353);
                this.field_11863.method_8649((class_1297)item);
            }
            return true;
        }
        if (this.manaToGet != 0) {
            return false;
        }
        boolean did = false;
        for (int i = 0; i < this.inventorySize(); ++i) {
            if (!this.getItemHandler().method_5438(i).method_7960()) continue;
            did = true;
            class_1799 stackToAdd = stack.method_46651(1);
            this.getItemHandler().method_5447(i, stackToAdd);
            if (player != null && player.method_31549().field_7477) break;
            stack.method_7934(1);
            break;
        }
        if (did) {
            this.field_11863.method_33596(null, class_5712.field_28733, this.method_11016());
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
        return true;
    }

    public boolean method_11004(int id, int param) {
        switch (id) {
            case 0: {
                this.recipeKeepTicks = param;
                return true;
            }
            case 1: {
                this.cooldown = param;
                return true;
            }
            case 2: {
                if (this.field_11863.field_9236) {
                    for (int i = 0; i < 25; ++i) {
                        float red = (float)Math.random();
                        float green = (float)Math.random();
                        float blue = (float)Math.random();
                        SparkleParticleData data = SparkleParticleData.sparkle((float)Math.random(), red, green, blue, 10);
                        this.field_11863.method_8406((class_2394)data, (double)this.field_11867.method_10263() + 0.5 + Math.random() * 0.4 - 0.2, (double)(this.field_11867.method_10264() + 1), (double)this.field_11867.method_10260() + 0.5 + Math.random() * 0.4 - 0.2, 0.0, 0.0, 0.0);
                    }
                    this.field_11863.method_8486((double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), BotaniaSounds.runeAltarCraft, class_3419.field_15245, 1.0f, 1.0f, false);
                }
                return true;
            }
        }
        return super.method_11004(id, param);
    }

    private void tickCooldown() {
        if (this.cooldown > 0) {
            --this.cooldown;
        }
        if (this.recipeKeepTicks > 0) {
            --this.recipeKeepTicks;
        } else {
            this.lastRecipe = null;
        }
    }

    public static void serverTick(class_1937 level, class_2338 worldPosition, class_2680 state, RunicAltarBlockEntity self) {
        if (self.manaToGet == 0) {
            List items = level.method_18467(class_1542.class, new class_238(worldPosition, worldPosition.method_10069(1, 1, 1)));
            for (class_1542 item : items) {
                class_1799 stack;
                if (!item.method_5805() || item.method_6983().method_7960() || item.method_6983().method_31574(BotaniaBlocks.livingrock.method_8389()) || XplatAbstractions.INSTANCE.itemFlagsComponent((class_1542)item).runicAltarSpawned || !self.addItem(null, stack = item.method_6983(), null)) continue;
                EntityHelper.syncItem(item);
            }
        }
        int newSignal = 0;
        if (self.manaToGet > 0) {
            ++newSignal;
            if (self.mana >= self.manaToGet) {
                ++newSignal;
            }
        }
        if (newSignal != self.signal) {
            self.signal = newSignal;
            level.method_8455(worldPosition, state.method_26204());
        }
        self.updateRecipe();
        self.tickCooldown();
    }

    public static void clientTick(class_1937 level, class_2338 worldPosition, class_2680 state, RunicAltarBlockEntity self) {
        if (self.manaToGet > 0 && self.mana >= self.manaToGet && level.field_9229.method_43048(20) == 0) {
            class_243 vec = class_243.method_24953((class_2382)self.method_11016());
            class_243 endVec = vec.method_1031(0.0, 2.5, 0.0);
            Proxy.INSTANCE.lightningFX(level, vec, endVec, 2.0f, 38027, 58583);
        }
        if (self.cooldown > 0) {
            WispParticleData data = WispParticleData.wisp(0.2f, 0.2f, 0.2f, 0.2f, 1.0f);
            level.method_8406((class_2394)data, (double)worldPosition.method_10263() + Math.random(), (double)worldPosition.method_10264() + 0.8, (double)worldPosition.method_10260() + Math.random(), 0.0, (double)0.025f, 0.0);
        }
        self.tickCooldown();
    }

    private void updateRecipe() {
        int manaToGet = this.manaToGet;
        this.manaToGet = this.currentRecipe != null ? this.currentRecipe.getManaUsage() : this.field_11863.method_8433().method_8132(BotaniaRecipeTypes.RUNE_TYPE, this.getItemHandler(), this.field_11863).map(RunicAltarRecipe::getManaUsage).orElse(0).intValue();
        if (manaToGet != this.manaToGet) {
            this.field_11863.method_8396(null, this.field_11867, BotaniaSounds.runeAltarStart, class_3419.field_15245, 1.0f, 1.0f);
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
    }

    private void saveLastRecipe() {
        class_1799 stack;
        this.lastRecipe = new ArrayList<class_1799>();
        for (int i = 0; i < this.inventorySize() && !(stack = this.getItemHandler().method_5438(i)).method_7960(); ++i) {
            this.lastRecipe.add(stack.method_7972());
        }
        this.recipeKeepTicks = 400;
        this.field_11863.method_8427(this.method_11016(), BotaniaBlocks.runeAltar, 0, 400);
    }

    public class_1269 trySetLastRecipe(class_1657 player) {
        if (player.method_37908().method_8608()) {
            return class_1269.method_29236((boolean)true);
        }
        boolean success = InventoryHelper.tryToSetLastRecipe(player, this.getItemHandler(), this.lastRecipe, null);
        if (success) {
            this.field_11863.method_33596(null, class_5712.field_28733, this.method_11016());
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
        return success ? class_1269.method_29236((boolean)false) : class_1269.field_5811;
    }

    @Override
    public boolean onUsedByWand(@Nullable class_1657 player, class_1799 wand, class_2350 side) {
        if (this.field_11863.field_9236) {
            return true;
        }
        RunicAltarRecipe recipe = null;
        if (this.currentRecipe != null) {
            recipe = this.currentRecipe;
        } else {
            Optional maybeRecipe = this.field_11863.method_8433().method_8132(BotaniaRecipeTypes.RUNE_TYPE, this.getItemHandler(), this.field_11863);
            if (maybeRecipe.isPresent()) {
                recipe = (RunicAltarRecipe)maybeRecipe.get();
            }
        }
        if (recipe != null && this.manaToGet > 0 && this.mana >= this.manaToGet) {
            List items = this.field_11863.method_18467(class_1542.class, new class_238(this.field_11867, this.field_11867.method_10069(1, 1, 1)));
            class_1542 livingrock = null;
            for (class_1542 item : items) {
                if (!item.method_5805() || item.method_6983().method_7960() || !item.method_6983().method_31574(BotaniaBlocks.livingrock.method_8389())) continue;
                livingrock = item;
                break;
            }
            if (livingrock != null) {
                int mana = recipe.getManaUsage();
                this.receiveMana(-mana);
                class_1799 output = recipe.method_8116(this.getItemHandler(), this.method_10997().method_30349());
                class_1542 outputItem = new class_1542(this.field_11863, (double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 1.5, (double)this.field_11867.method_10260() + 0.5, output);
                XplatAbstractions.INSTANCE.itemFlagsComponent((class_1542)outputItem).runicAltarSpawned = true;
                if (player != null) {
                    player.method_51283((class_1860)recipe, List.of(output));
                    output.method_7982(this.field_11863, player, output.method_7947());
                }
                this.field_11863.method_8649((class_1297)outputItem);
                this.currentRecipe = null;
                this.field_11863.method_33596(null, class_5712.field_28174, this.method_11016());
                this.field_11863.method_8427(this.method_11016(), BotaniaBlocks.runeAltar, 1, 60);
                this.field_11863.method_8427(this.method_11016(), BotaniaBlocks.runeAltar, 2, 0);
                this.saveLastRecipe();
                for (int i = 0; i < this.inventorySize(); ++i) {
                    class_1799 stack = this.getItemHandler().method_5438(i);
                    if (stack.method_7960()) continue;
                    if (stack.method_7909() instanceof RuneItem && (player == null || !player.method_31549().field_7477)) {
                        class_1542 outputRune = new class_1542(this.field_11863, (double)this.method_11016().method_10263() + 0.5, (double)this.method_11016().method_10264() + 1.5, (double)this.method_11016().method_10260() + 0.5, stack.method_7972());
                        XplatAbstractions.INSTANCE.itemFlagsComponent((class_1542)outputRune).runicAltarSpawned = true;
                        this.field_11863.method_8649((class_1297)outputRune);
                    }
                    this.getItemHandler().method_5447(i, class_1799.field_8037);
                }
                EntityHelper.shrinkItem(livingrock);
            }
        }
        return true;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.inventorySize(); ++i) {
            if (this.getItemHandler().method_5438(i).method_7960()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void writePacketNBT(class_2487 tag) {
        super.writePacketNBT(tag);
        tag.method_10569(TAG_MANA, this.mana);
        tag.method_10569(TAG_MANA_TO_GET, this.manaToGet);
    }

    @Override
    public void readPacketNBT(class_2487 tag) {
        super.readPacketNBT(tag);
        this.mana = tag.method_10550(TAG_MANA);
        this.manaToGet = tag.method_10550(TAG_MANA_TO_GET);
    }

    @Override
    protected class_1277 createItemHandler() {
        return new class_1277(16){

            public int method_5444() {
                return 1;
            }
        };
    }

    @Override
    public class_1937 getManaReceiverLevel() {
        return this.method_10997();
    }

    @Override
    public class_2338 getManaReceiverPos() {
        return this.method_11016();
    }

    @Override
    public int getCurrentMana() {
        return this.mana;
    }

    @Override
    public boolean isFull() {
        return this.mana >= this.manaToGet;
    }

    @Override
    public void receiveMana(int mana) {
        this.mana = Math.min(this.mana + mana, this.manaToGet);
    }

    @Override
    public boolean canReceiveManaFromBursts() {
        return !this.isFull();
    }

    public boolean canAddLastRecipe() {
        return this.isEmpty();
    }

    public int getTargetMana() {
        return this.manaToGet;
    }

    public static class Hud {
        public static void render(RunicAltarBlockEntity altar, class_332 gui, class_310 mc) {
            class_4587 ms = gui.method_51448();
            int xc = mc.method_22683().method_4486() / 2;
            int yc = mc.method_22683().method_4502() / 2;
            float angle = -90.0f;
            int radius = 24;
            int amt = 0;
            for (int i = 0; i < altar.inventorySize() && !altar.getItemHandler().method_5438(i).method_7960(); ++i) {
                ++amt;
            }
            if (amt > 0 && altar.manaToGet > 0) {
                float anglePer = 360.0f / (float)amt;
                altar.field_11863.method_8433().method_8132(BotaniaRecipeTypes.RUNE_TYPE, altar.getItemHandler(), altar.field_11863).ifPresent(recipe -> {
                    RenderSystem.enableBlend();
                    RenderSystem.blendFunc((int)770, (int)771);
                    float progress = (float)altar.mana / (float)altar.manaToGet;
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    RenderHelper.drawTexturedModalRect(gui, HUDHandler.manaBar, xc + radius + 9, yc - 8, progress == 1.0f ? 0 : 22, 8, 22, 15);
                    if (progress == 1.0f) {
                        gui.method_51445(new class_1799((class_1935)BotaniaBlocks.livingrock), xc + radius + 16, yc + 8);
                        ms.method_22903();
                        ms.method_46416(0.0f, 0.0f, 100.0f);
                        class_1799 playerWand = PlayerHelper.getFirstHeldItemClass((class_1309)mc.field_1724, WandOfTheForestItem.class);
                        if (playerWand.method_7960()) {
                            playerWand = PlayerHelper.getItemClassFromInventory((class_1657)mc.field_1724, WandOfTheForestItem.class);
                        }
                        class_1799 wandToRender = playerWand.method_7960() ? new class_1799((class_1935)BotaniaItems.twigWand) : playerWand;
                        gui.method_51445(wandToRender, xc + radius + 24, yc + 8);
                        ms.method_22909();
                    }
                    RenderHelper.renderProgressPie(gui, xc + radius + 32, yc - 8, progress, recipe.method_8116(altar.getItemHandler(), altar.method_10997().method_30349()));
                    if (progress == 1.0f) {
                        gui.method_51433(mc.field_1772, "+", xc + radius + 14, yc + 12, 0xFFFFFF, false);
                    }
                });
                for (int i = 0; i < amt; ++i) {
                    double xPos = (double)xc + Math.cos((double)angle * Math.PI / 180.0) * (double)radius - 8.0;
                    double yPos = (double)yc + Math.sin((double)angle * Math.PI / 180.0) * (double)radius - 8.0;
                    ms.method_22903();
                    ms.method_22904(xPos, yPos, 0.0);
                    gui.method_51445(altar.getItemHandler().method_5438(i), 0, 0);
                    ms.method_22909();
                    angle += anglePer;
                }
            }
            if (altar.recipeKeepTicks > 0 && altar.canAddLastRecipe()) {
                String s = class_1074.method_4662((String)"botaniamisc.altarRefill0", (Object[])new Object[0]);
                gui.method_25303(mc.field_1772, s, xc - mc.field_1772.method_1727(s) / 2, yc + 10, 0xFFFFFF);
                s = class_1074.method_4662((String)"botaniamisc.altarRefill1", (Object[])new Object[0]);
                gui.method_25303(mc.field_1772, s, xc - mc.field_1772.method_1727(s) / 2, yc + 20, 0xFFFFFF);
            }
        }
    }
}

