/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.block_entity;

import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.block_entity.BindableSpecialFlowerBlockEntity;
import vazkii.botania.api.internal.ManaNetwork;
import vazkii.botania.api.mana.ManaCollector;

public abstract class GeneratingFlowerBlockEntity
extends BindableSpecialFlowerBlockEntity<ManaCollector> {
    private static final class_2960 SPREADER_ID = new class_2960("botania", "mana_spreader");
    public static final int LINK_RANGE = 6;
    private static final String TAG_MANA = "mana";
    private int mana;

    public GeneratingFlowerBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state, ManaCollector.class);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.method_10997().field_9236) {
            double particleChance = 1.0 - (double)this.getMana() / (double)this.getMaxMana() / 3.5;
            int color = this.getColor();
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            if (Math.random() > particleChance) {
                class_243 offset = this.method_10997().method_8320(this.method_11016()).method_26226((class_1922)this.method_10997(), this.method_11016());
                double x = (double)this.method_11016().method_10263() + offset.field_1352;
                double y = (double)this.method_11016().method_10264() + offset.field_1351;
                double z = (double)this.method_11016().method_10260() + offset.field_1350;
                BotaniaAPI.instance().sparkleFX(this.method_10997(), x + 0.3 + Math.random() * 0.5, y + 0.5 + Math.random() * 0.5, z + 0.3 + Math.random() * 0.5, red, green, blue, (float)Math.random(), 5);
            }
        }
        this.emptyManaIntoCollector();
    }

    @Override
    public int getBindingRadius() {
        return 6;
    }

    @Override
    @Nullable
    public class_2338 findClosestTarget() {
        ManaNetwork network = BotaniaAPI.instance().getManaNetworkInstance();
        ManaCollector closestCollector = network.getClosestCollector(this.method_11016(), this.method_10997(), this.getBindingRadius());
        return closestCollector == null ? null : closestCollector.getManaReceiverPos();
    }

    public void emptyManaIntoCollector() {
        ManaCollector collector = (ManaCollector)this.findBoundTile();
        if (collector != null && !collector.isFull() && this.getMana() > 0) {
            int manaval = Math.min(this.getMana(), collector.getMaxMana() - collector.getCurrentMana());
            this.addMana(-manaval);
            collector.receiveMana(manaval);
            this.sync();
        }
    }

    @Override
    public int getMana() {
        return this.mana;
    }

    @Override
    public void addMana(int mana) {
        this.mana = Math.min(this.getMaxMana(), this.getMana() + mana);
        this.method_5431();
    }

    @Override
    public class_1799 getDefaultHudIcon() {
        return class_7923.field_41178.method_17966(SPREADER_ID).map(class_1799::new).orElse(class_1799.field_8037);
    }

    @Override
    public void readFromPacketNBT(class_2487 cmp) {
        super.readFromPacketNBT(cmp);
        this.mana = cmp.method_10550(TAG_MANA);
    }

    @Override
    public void writeToPacketNBT(class_2487 cmp) {
        super.writeToPacketNBT(cmp);
        cmp.method_10569(TAG_MANA, this.getMana());
    }
}

