/*
 * Decompiled with CFR 0.152.
 */
package io.github.projectet.ae2things.gui.cell;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.implementations.menuobjects.IPortableTerminal;
import appeng.api.implementations.menuobjects.ItemMenuHost;
import appeng.api.storage.MEStorage;
import appeng.api.util.IConfigManager;
import appeng.menu.ISubMenu;
import appeng.util.ConfigManager;
import com.google.common.base.Preconditions;
import io.github.projectet.ae2things.item.PortableDISKItem;
import io.github.projectet.ae2things.storage.DISKCellHandler;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import org.jetbrains.annotations.Nullable;

public class PortableDISKMenuHost
extends ItemMenuHost
implements IPortableTerminal {
    private final BiConsumer<class_1657, ISubMenu> returnMainMenu;
    private final MEStorage cellStorage;
    private final PortableDISKItem item;

    public PortableDISKMenuHost(class_1657 player, @Nullable Integer slot, PortableDISKItem diskItem, class_1799 itemStack, BiConsumer<class_1657, ISubMenu> returnMainMenu) {
        super(player, slot, itemStack);
        Preconditions.checkArgument((itemStack.method_7909() == diskItem ? 1 : 0) != 0, (Object)"Stack doesn't match item");
        this.returnMainMenu = returnMainMenu;
        this.cellStorage = DISKCellHandler.INSTANCE.getCellInventory(itemStack, null);
        Objects.requireNonNull(this.cellStorage, "Portable cell doesn't expose a cell inventory.");
        this.item = diskItem;
    }

    public double extractAEPower(double amt, Actionable mode, PowerMultiplier usePowerMultiplier) {
        amt = usePowerMultiplier.multiply(amt);
        if (mode == Actionable.SIMULATE) {
            return usePowerMultiplier.divide(Math.min(amt, this.item.getAECurrentPower(this.getItemStack())));
        }
        return usePowerMultiplier.divide(this.item.extractAEPower(this.getItemStack(), amt, Actionable.MODULATE));
    }

    public boolean onBroadcastChanges(class_1703 menu) {
        return this.ensureItemStillInSlot() && this.drainPower();
    }

    @Nullable
    public MEStorage getInventory() {
        return this.cellStorage;
    }

    public void returnToMainMenu(class_1657 player, ISubMenu subMenu) {
        this.returnMainMenu.accept(player, subMenu);
    }

    public class_1799 getMainMenuIcon() {
        return this.getItemStack();
    }

    public IConfigManager getConfigManager() {
        ConfigManager out = new ConfigManager((manager, settingName) -> manager.writeToNBT(this.getItemStack().method_7948()));
        out.registerSetting(Settings.SORT_BY, (Enum)SortOrder.NAME);
        out.registerSetting(Settings.VIEW_MODE, (Enum)ViewItems.ALL);
        out.registerSetting(Settings.SORT_DIRECTION, (Enum)SortDir.ASCENDING);
        out.readFromNBT(this.getItemStack().method_7948().method_10553());
        return out;
    }
}

