/*
 * Decompiled with CFR 0.152.
 */
package io.github.projectet.ae2things.block.entity;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.Setting;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.inventories.ISegmentedInventory;
import appeng.api.inventories.InternalInventory;
import appeng.api.inventories.ItemTransfer;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.upgrades.UpgradeInventories;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.blockentity.grid.AENetworkPowerBlockEntity;
import appeng.blockentity.misc.InscriberRecipes;
import appeng.core.definitions.AEItems;
import appeng.core.settings.TickRates;
import appeng.me.service.EnergyService;
import appeng.recipes.handlers.InscriberProcessType;
import appeng.recipes.handlers.InscriberRecipe;
import appeng.util.ConfigManager;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.CombinedInternalInventory;
import appeng.util.inv.FilteredInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import appeng.util.inv.filter.IAEItemFilter;
import io.github.projectet.ae2things.AE2Things;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class BEAdvancedInscriber
extends AENetworkPowerBlockEntity
implements IGridTickable,
IUpgradeableObject,
IConfigurableObject {
    private final AppEngInternalInventory topItemHandler = new AppEngInternalInventory((InternalInventoryHost)this, 1, 64);
    private final AppEngInternalInventory botItemHandler = new AppEngInternalInventory((InternalInventoryHost)this, 1, 64);
    private final AppEngInternalInventory sideItemHandler = new AppEngInternalInventory((InternalInventoryHost)this, 2, 64);
    private final InternalInventory topItemHandlerExtern;
    private final InternalInventory botItemHandlerExtern;
    private final InternalInventory sideItemHandlerExtern;
    private final ConfigManager configManager;
    private final InternalInventory combinedExtInventory;
    private final InternalInventory inv = new CombinedInternalInventory(new InternalInventory[]{this.topItemHandler, this.botItemHandler, this.sideItemHandler});
    private final IUpgradeInventory upgrades;
    private InscriberRecipe cachedTask;
    private int processingTime = 0;
    private final int maxProcessingTime = 50;
    private boolean working;
    public boolean topLock;
    public boolean botLock;
    private final Map<InternalInventory, class_1799> lastStacks = new IdentityHashMap<AppEngInternalInventory, class_1799>(Map.of(this.topItemHandler, class_1799.field_8037, this.botItemHandler, class_1799.field_8037, this.sideItemHandler, class_1799.field_8037));

    public BEAdvancedInscriber(class_2338 pos, class_2680 state) {
        super(AE2Things.ADVANCED_INSCRIBER_BE, pos, state);
        this.upgrades = UpgradeInventories.forMachine((class_1935)AE2Things.ADVANCED_INSCRIBER, (int)5, () -> ((BEAdvancedInscriber)this).saveChanges());
        this.sideItemHandler.setMaxStackSize(1, 64);
        this.configManager = new ConfigManager(this::onConfigChanged);
        this.getMainNode().setExposedOnSides(EnumSet.allOf(class_2350.class)).setIdlePowerUsage(0.0).addService(IGridTickable.class, (IGridNodeService)this);
        this.setInternalMaxPower(1600.0);
        this.configManager.registerSetting(Settings.AUTO_EXPORT, (Enum)YesNo.NO);
        this.configManager.registerSetting(Settings.INSCRIBER_BUFFER_SIZE, (Enum)YesNo.YES);
        FilteredInventory filter = new FilteredInventory();
        this.topItemHandlerExtern = new FilteredInternalInventory((InternalInventory)this.topItemHandler, (IAEItemFilter)filter);
        this.botItemHandlerExtern = new FilteredInternalInventory((InternalInventory)this.botItemHandler, (IAEItemFilter)filter);
        this.sideItemHandlerExtern = new FilteredInternalInventory((InternalInventory)this.sideItemHandler, (IAEItemFilter)filter);
        this.combinedExtInventory = new CombinedInternalInventory(new InternalInventory[]{this.topItemHandlerExtern, this.botItemHandlerExtern, this.sideItemHandlerExtern});
        this.topLock = true;
        this.botLock = true;
    }

    private void onConfigChanged(IConfigManager manager, Setting<?> setting) {
        if (setting == Settings.AUTO_EXPORT) {
            this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().wakeDevice(node));
        }
        if (setting == Settings.INSCRIBER_BUFFER_SIZE) {
            if (this.configManager.getSetting(Settings.INSCRIBER_BUFFER_SIZE) == YesNo.YES) {
                this.topItemHandler.setMaxStackSize(0, 64);
                this.sideItemHandler.setMaxStackSize(0, 64);
                this.botItemHandler.setMaxStackSize(0, 64);
            } else {
                this.topItemHandler.setMaxStackSize(0, 4);
                this.sideItemHandler.setMaxStackSize(0, 4);
                this.botItemHandler.setMaxStackSize(0, 4);
            }
        }
        this.saveChanges();
    }

    protected void saveVisualState(class_2487 data) {
        super.saveVisualState(data);
        data.method_10556("working", this.isWorking());
    }

    protected void loadVisualState(class_2487 data) {
        super.loadVisualState(data);
        this.working = data.method_10577("working");
    }

    public InternalInventory getInternalInventory() {
        return this.inv;
    }

    public InternalInventory getExposedInventoryForSide(class_2350 facing) {
        return this.combinedExtInventory;
    }

    public void onChangeInventory(InternalInventory inv, int slot) {
        if (slot == 0) {
            boolean isEmpty = inv.getStackInSlot(0).method_7960();
            boolean wasEmpty = this.lastStacks.get(inv).method_7960();
            this.lastStacks.put(inv, inv.getStackInSlot(0).method_7972());
            if (isEmpty != wasEmpty) {
                this.setProcessingTime(0);
            }
        }
        if (!this.isWorking()) {
            this.markForUpdate();
        }
        this.cachedTask = null;
        this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().wakeDevice(node));
    }

    public IUpgradeInventory getUpgrades() {
        return this.upgrades;
    }

    protected boolean readFromStream(class_2540 data) {
        boolean newWorking;
        boolean c = super.readFromStream(data);
        boolean oldWorking = this.isWorking();
        if (oldWorking != (newWorking = data.readBoolean()) && newWorking) {
            this.working = true;
        }
        for (int i = 0; i < this.inv.size(); ++i) {
            this.inv.setItemDirect(i, data.method_10819());
        }
        this.cachedTask = null;
        return c;
    }

    public void toggleTopLock() {
        this.topLock = !this.topLock;
    }

    public void toggleBotLock() {
        this.botLock = !this.botLock;
    }

    protected void writeToStream(class_2540 data) {
        super.writeToStream(data);
        data.writeBoolean(this.isWorking());
        for (int i = 0; i < this.inv.size(); ++i) {
            data.method_10793(this.inv.getStackInSlot(i));
        }
    }

    private boolean hasAutoExportWork() {
        return !this.sideItemHandler.getStackInSlot(1).method_7960() && this.configManager.getSetting(Settings.AUTO_EXPORT) == YesNo.YES;
    }

    @Nullable
    public InternalInventory getSubInventory(class_2960 id) {
        if (id.equals((Object)ISegmentedInventory.STORAGE)) {
            return this.getInternalInventory();
        }
        if (id.equals((Object)ISegmentedInventory.UPGRADES)) {
            return this.upgrades;
        }
        return super.getSubInventory(id);
    }

    @Nullable
    public InscriberRecipe getTask() {
        if (this.cachedTask == null && this.field_11863 != null) {
            class_1799 input = this.sideItemHandler.getStackInSlot(0);
            class_1799 plateA = this.topItemHandler.getStackInSlot(0);
            class_1799 plateB = this.botItemHandler.getStackInSlot(0);
            if (input.method_7960()) {
                return null;
            }
            this.cachedTask = InscriberRecipes.findRecipe((class_1937)this.field_11863, (class_1799)input, (class_1799)plateA, (class_1799)plateB, (boolean)true);
        }
        return this.cachedTask;
    }

    public void method_11007(class_2487 data) {
        super.method_11007(data);
        this.upgrades.writeToNBT(data, "upgrades");
        data.method_10556("topLock", this.topLock);
        data.method_10556("botLock", this.botLock);
    }

    public void loadTag(class_2487 data) {
        super.loadTag(data);
        this.upgrades.readFromNBT(data, "upgrades");
        this.topLock = data.method_10577("topLock");
        this.botLock = data.method_10577("botLock");
    }

    public void addAdditionalDrops(class_1937 level, class_2338 pos, List<class_1799> drops) {
        super.addAdditionalDrops(level, pos, drops);
        for (class_1799 upgrade : this.upgrades) {
            drops.add(upgrade);
        }
    }

    private boolean hasWork() {
        return this.getTask() != null && this.sideItemHandler.getStackInSlot(1).method_7947() != 64;
    }

    public boolean isWorking() {
        return this.working;
    }

    private void matchWork() {
        if (this.isWorking() != this.hasWork()) {
            this.working = this.hasWork();
            this.markForUpdate();
        }
    }

    private void setProcessingTime(int processingTime) {
        this.processingTime = processingTime;
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.Inscriber, !this.hasWork() && !this.hasAutoExportWork(), true);
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (this.getTask() != null && this.sideItemHandler.getStackInSlot(1).method_7947() != 64) {
            EnergyService[] eg = new EnergyService[1];
            BEAdvancedInscriber src = this;
            this.getMainNode().ifPresent(arg_0 -> BEAdvancedInscriber.lambda$tickingRequest$2((IEnergyService[])eg, arg_0));
            if (eg[0] == null) {
                return TickRateModulation.IDLE;
            }
            int speedFactor = 1 + this.upgrades.getInstalledUpgrades((class_1935)AEItems.SPEED_CARD) * 3;
            int powerConsumption = 20 * speedFactor;
            double powerThreshold = (double)powerConsumption - 0.01;
            double powerReq = this.extractAEPower(powerConsumption, Actionable.SIMULATE, PowerMultiplier.CONFIG);
            if (powerReq <= powerThreshold) {
                src = eg[0];
                powerReq = eg[0].extractAEPower((double)powerConsumption, Actionable.SIMULATE, PowerMultiplier.CONFIG);
            }
            if (powerReq > powerThreshold) {
                src.extractAEPower(powerConsumption, Actionable.MODULATE, PowerMultiplier.CONFIG);
                if (this.getProcessingTime() == 0) {
                    this.setProcessingTime(this.getProcessingTime() + speedFactor);
                } else {
                    this.setProcessingTime(this.getProcessingTime() + ticksSinceLastCall * speedFactor);
                }
                if (this.getProcessingTime() > this.getMaxProcessingTime()) {
                    class_1799 outputCopy;
                    this.setProcessingTime(this.getMaxProcessingTime());
                    InscriberRecipe out = this.getTask();
                    if (out != null && this.sideItemHandler.insertItem(1, outputCopy = out.getResultItem().method_7972(), true).method_7960()) {
                        this.sideItemHandler.insertItem(1, outputCopy, false);
                        this.setProcessingTime(0);
                        if (out.getProcessType() == InscriberProcessType.PRESS) {
                            this.topItemHandler.extractItem(0, 1, false);
                            this.botItemHandler.extractItem(0, 1, false);
                        }
                        this.sideItemHandler.extractItem(0, 1, false);
                        this.saveChanges();
                    }
                }
            } else {
                if (this.isWorking()) {
                    this.working = false;
                    this.markForUpdate();
                }
                return TickRateModulation.SLEEP;
            }
        }
        if (this.pushOutResult()) {
            return TickRateModulation.URGENT;
        }
        this.matchWork();
        return this.hasWork() ? TickRateModulation.URGENT : (this.hasAutoExportWork() ? TickRateModulation.SLOWER : TickRateModulation.SLEEP);
    }

    private boolean pushOutResult() {
        if (!this.hasAutoExportWork()) {
            return false;
        }
        EnumSet<class_2350> pushSides = EnumSet.allOf(class_2350.class);
        for (class_2350 dir : pushSides) {
            ItemTransfer target = InternalInventory.wrapExternal((class_1937)this.field_11863, (class_2338)this.method_11016().method_10093(dir), (class_2350)dir.method_10153());
            if (target == null) continue;
            int startItems = this.sideItemHandler.getStackInSlot(1).method_7947();
            this.sideItemHandler.insertItem(1, target.addItems(this.sideItemHandler.extractItem(1, 64, false)), false);
            int endItems = this.sideItemHandler.getStackInSlot(1).method_7947();
            if (startItems == endItems) continue;
            return true;
        }
        return false;
    }

    public int getMaxProcessingTime() {
        return 50;
    }

    public int getProcessingTime() {
        return this.processingTime;
    }

    public IConfigManager getConfigManager() {
        return this.configManager;
    }

    private static /* synthetic */ void lambda$tickingRequest$2(IEnergyService[] eg, IGrid grid) {
        eg[0] = grid.getEnergyService();
    }

    public class FilteredInventory
    implements IAEItemFilter {
        public boolean allowExtract(InternalInventory inv, int slot, int amount) {
            if (inv == BEAdvancedInscriber.this.topItemHandler) {
                return !BEAdvancedInscriber.this.topLock && !BEAdvancedInscriber.this.sideItemHandler.getStackInSlot(1).method_7960() && BEAdvancedInscriber.this.sideItemHandler.getStackInSlot(0).method_7960();
            }
            if (inv == BEAdvancedInscriber.this.botItemHandler) {
                return !BEAdvancedInscriber.this.botLock && !BEAdvancedInscriber.this.sideItemHandler.getStackInSlot(1).method_7960() && BEAdvancedInscriber.this.sideItemHandler.getStackInSlot(0).method_7960();
            }
            return slot == 1;
        }

        public boolean allowInsert(InternalInventory inv, int slot, class_1799 stack) {
            if (slot == 1) {
                return false;
            }
            class_1799 bot = BEAdvancedInscriber.this.botItemHandler.getStackInSlot(0);
            class_1799 middle = BEAdvancedInscriber.this.sideItemHandler.getStackInSlot(0);
            class_1799 top = BEAdvancedInscriber.this.topItemHandler.getStackInSlot(0);
            if (inv == BEAdvancedInscriber.this.botItemHandler) {
                bot = stack;
            }
            if (inv == BEAdvancedInscriber.this.sideItemHandler) {
                middle = stack;
            }
            if (inv == BEAdvancedInscriber.this.topItemHandler) {
                top = stack;
            }
            for (InscriberRecipe recipe : InscriberRecipes.getRecipes((class_1937)BEAdvancedInscriber.this.method_10997())) {
                if (!middle.method_7960() && !recipe.getMiddleInput().method_8093(middle)) continue;
                if (bot.method_7960() && top.method_7960()) {
                    return true;
                }
                if (!(bot.method_7960() ? recipe.getTopOptional().method_8093(top) || recipe.getBottomOptional().method_8093(top) : (top.method_7960() ? recipe.getBottomOptional().method_8093(bot) || recipe.getTopOptional().method_8093(bot) : recipe.getTopOptional().method_8093(top) && recipe.getBottomOptional().method_8093(bot) || recipe.getBottomOptional().method_8093(top) && recipe.getTopOptional().method_8093(bot)))) continue;
                return true;
            }
            return false;
        }
    }
}

