/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.ae2netanalyser.common.items;

import appeng.api.implementations.menuobjects.IMenuItem;
import appeng.api.implementations.menuobjects.ItemMenuHost;
import appeng.api.networking.GridFlags;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.me.InWorldGridNode;
import appeng.me.helpers.IGridConnectedBlockEntity;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuLocator;
import appeng.menu.locator.MenuLocators;
import com.glodblock.github.ae2netanalyser.AEAnalyzer;
import com.glodblock.github.ae2netanalyser.common.AEAItems;
import com.glodblock.github.ae2netanalyser.common.inventory.AnalyserInventory;
import com.glodblock.github.ae2netanalyser.common.me.AnalyserMode;
import com.glodblock.github.ae2netanalyser.common.me.NetworkData;
import com.glodblock.github.ae2netanalyser.common.me.netdata.FlagType;
import com.glodblock.github.ae2netanalyser.common.me.netdata.LinkFlag;
import com.glodblock.github.ae2netanalyser.common.me.netdata.NodeFlag;
import com.glodblock.github.ae2netanalyser.common.me.netdata.State;
import com.glodblock.github.ae2netanalyser.common.me.tracker.PlayerTracker;
import com.glodblock.github.ae2netanalyser.container.ContainerAnalyser;
import com.glodblock.github.ae2netanalyser.network.AEANetworkHandler;
import com.glodblock.github.ae2netanalyser.network.packets.SNetworkDataUpdate;
import com.glodblock.github.glodium.client.render.ColorData;
import com.glodblock.github.glodium.network.packet.IMessage;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ItemNetworkAnalyser
extends class_1792
implements IMenuItem {
    public static final Reference2ObjectMap<Enum<?>, ColorData> defaultColors = new Reference2ObjectOpenHashMap();

    public ItemNetworkAnalyser() {
        super(new class_1792.class_1793().method_7889(1));
    }

    public AnalyserConfig getConfig(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        Reference2ObjectOpenHashMap colors = new Reference2ObjectOpenHashMap();
        float nodeSize = 0.4f;
        AnalyserMode mode = AnalyserMode.FULL;
        colors.putAll(defaultColors);
        if (tag != null) {
            class_2499 colorTag = tag.method_10554("color_config", 10);
            try {
                for (class_2520 t : colorTag) {
                    class_2487 data = (class_2487)t;
                    FlagType type = FlagType.valueOf(data.method_10558("type"));
                    String name = data.method_10558("name");
                    ColorData colorData = new ColorData(data.method_10550("color"));
                    switch (type) {
                        case LINK: {
                            colors.put((Object)LinkFlag.valueOf(name), (Object)colorData);
                            break;
                        }
                        case NODE: {
                            colors.put((Object)NodeFlag.valueOf(name), (Object)colorData);
                        }
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (tag.method_10545("node_size")) {
                nodeSize = tag.method_10583("node_size");
            }
            if (tag.method_10545("mode")) {
                mode = AnalyserMode.valueOf(tag.method_10558("mode"));
            }
        }
        return new AnalyserConfig(mode, nodeSize, (Reference2ObjectMap<Enum<?>, ColorData>)colors);
    }

    public void saveConfig(AnalyserConfig config, class_1799 stack) {
        class_2487 tag = stack.method_7948();
        tag.method_10548("node_size", config.nodeSize);
        tag.method_10582("mode", config.mode.name());
        class_2499 colorList = new class_2499();
        for (Map.Entry entry : config.colors.entrySet()) {
            Enum type = (Enum)entry.getKey();
            ColorData color = (ColorData)entry.getValue();
            class_2487 colorRecord = new class_2487();
            if (type.getClass() == LinkFlag.class) {
                colorRecord.method_10582("type", FlagType.LINK.name());
                colorRecord.method_10582("name", type.name());
                colorRecord.method_10569("color", color.toARGB());
            }
            if (type.getClass() == NodeFlag.class) {
                colorRecord.method_10582("type", FlagType.NODE.name());
                colorRecord.method_10582("name", type.name());
                colorRecord.method_10569("color", color.toARGB());
            }
            if (colorRecord.method_33133()) continue;
            colorList.add((Object)colorRecord);
        }
        if (!colorList.isEmpty()) {
            tag.method_10566("color_config", (class_2520)colorList);
        }
    }

    @Nullable
    public class_4208 getPos(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        if (tag != null && tag.method_10545("pos")) {
            return class_4208.field_25066.decode((DynamicOps)class_2509.field_11560, (Object)tag.method_10580("pos")).resultOrPartial(class_156.method_29188((String)"Network Position", arg_0 -> ((Logger)AEAnalyzer.LOGGER).error(arg_0))).map(Pair::getFirst).orElse(null);
        }
        return null;
    }

    public void savePos(class_1799 stack, class_4208 pos) {
        class_4208.field_25066.encodeStart((DynamicOps)class_2509.field_11560, (Object)pos).result().ifPresent(tag -> stack.method_7948().method_10566("pos", tag));
    }

    @NotNull
    public class_1271<class_1799> method_7836(@NotNull class_1937 level, @NotNull class_1657 p, @NotNull class_1268 hand) {
        if (!level.method_8608() && !p.method_5715()) {
            MenuOpener.open(ContainerAnalyser.TYPE, (class_1657)p, (MenuLocator)MenuLocators.forHand((class_1657)p, (class_1268)hand));
        }
        return new class_1271(class_1269.method_29236((boolean)level.method_8608()), (Object)p.method_5998(hand));
    }

    @NotNull
    public class_1269 method_7884(@NotNull class_1838 context) {
        class_3222 player;
        class_1799 tool;
        class_1657 class_16572;
        if (!context.method_8045().field_9236 && (class_16572 = context.method_8036()) instanceof class_3222 && (tool = (player = (class_3222)class_16572).method_6047()).method_7909() == AEAItems.ANALYSER) {
            AEAItems.ANALYSER.savePos(tool, class_4208.method_19443((class_5321)context.method_8045().method_27983(), (class_2338)context.method_8037()));
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public void method_7888(@NotNull class_1799 stack, @NotNull class_1937 world, @NotNull class_1297 entity, int slot, boolean selected) {
        IInWorldGridNodeHost host;
        class_4208 pos;
        class_3222 player;
        if (!world.field_9236 && entity instanceof class_3222 && stack == (player = (class_3222)entity).method_6047() && player.method_6047().method_7909() == AEAItems.ANALYSER && (pos = AEAItems.ANALYSER.getPos(player.method_6047())) != null && pos.method_19442().equals(world.method_27983()) && PlayerTracker.needUpdate((class_1657)player, pos) && (host = GridHelper.getNodeHost((class_1937)world, (class_2338)pos.method_19446())) != null) {
            IGridNode node = host.getGridNode(null);
            if (node == null && host instanceof IGridConnectedBlockEntity) {
                IGridConnectedBlockEntity gct = (IGridConnectedBlockEntity)host;
                node = gct.getGridNode();
            }
            if (node != null) {
                ObjectOpenHashSet connections = new ObjectOpenHashSet();
                Set<NetworkData.ANode> nodes = this.extractNodes(node.getGrid(), (Set<IGridConnection>)connections, world);
                ObjectOpenHashSet links = new ObjectOpenHashSet();
                for (IGridConnection c : connections) {
                    NetworkData.ANode a = this.wrapGridNode(c.a());
                    NetworkData.ANode b = this.wrapGridNode(c.b());
                    if (a == null || b == null || Objects.equals(a, b)) continue;
                    State<LinkFlag> state = new State<LinkFlag>(LinkFlag.NORMAL);
                    if (c.a().hasFlag(GridFlags.DENSE_CAPACITY) && c.b().hasFlag(GridFlags.DENSE_CAPACITY)) {
                        state.set(LinkFlag.DENSE);
                    }
                    if (c.a().hasFlag(GridFlags.CANNOT_CARRY_COMPRESSED) && c.b().hasFlag(GridFlags.CANNOT_CARRY_COMPRESSED)) {
                        state.set(LinkFlag.COMPRESSED);
                    }
                    links.add((Object)new NetworkData.ALink(a, b, (short)c.getUsedChannels(), state));
                }
                AEANetworkHandler.INSTANCE.sendTo((IMessage)new SNetworkDataUpdate(new NetworkData(nodes.toArray(new NetworkData.ANode[0]), (NetworkData.ALink[])links.toArray((Object[])new NetworkData.ALink[0]))), player);
            }
        }
    }

    private Set<NetworkData.ANode> extractNodes(IGrid grid, Set<IGridConnection> connections, class_1937 world) {
        if (grid != null) {
            ObjectOpenHashSet nodes = new ObjectOpenHashSet();
            for (IGridNode node : grid.getNodes()) {
                NetworkData.ANode a;
                class_5321 dim = node.getLevel().method_27983();
                if (!dim.equals(world.method_27983()) || (a = this.wrapGridNode(node)) == null) continue;
                connections.addAll(node.getConnections());
                nodes.add((Object)this.wrapGridNode(node));
            }
            return nodes;
        }
        return Set.of();
    }

    @Nullable
    private NetworkData.ANode wrapGridNode(IGridNode node) {
        if (node instanceof InWorldGridNode) {
            InWorldGridNode worldNode = (InWorldGridNode)node;
            class_2338 pos = worldNode.getLocation();
            State<NodeFlag> state = new State<NodeFlag>(NodeFlag.NORMAL);
            if (!node.meetsChannelRequirements()) {
                state.set(NodeFlag.MISSING);
            }
            if (node.hasFlag(GridFlags.DENSE_CAPACITY)) {
                state.set(NodeFlag.DENSE);
            }
            return new NetworkData.ANode(pos, state);
        }
        return null;
    }

    @Nullable
    public ItemMenuHost getMenuHost(class_1657 player, int inventorySlot, class_1799 stack, @Nullable class_2338 pos) {
        return new AnalyserInventory(player, inventorySlot, stack);
    }

    static {
        defaultColors.put((Object)NodeFlag.NORMAL, (Object)new ColorData(0.8f, 0.0f, 0.0f, 1.0f));
        defaultColors.put((Object)NodeFlag.DENSE, (Object)new ColorData(0.8f, 1.0f, 1.0f, 0.0f));
        defaultColors.put((Object)NodeFlag.MISSING, (Object)new ColorData(0.8f, 1.0f, 0.0f, 0.0f));
        defaultColors.put((Object)LinkFlag.NORMAL, (Object)new ColorData(0.8f, 0.0f, 0.0f, 1.0f));
        defaultColors.put((Object)LinkFlag.DENSE, (Object)new ColorData(0.8f, 1.0f, 1.0f, 0.0f));
        defaultColors.put((Object)LinkFlag.COMPRESSED, (Object)new ColorData(0.8f, 1.0f, 0.0f, 1.0f));
    }

    public record AnalyserConfig(AnalyserMode mode, float nodeSize, Reference2ObjectMap<Enum<?>, ColorData> colors) {
        public void writeToBytes(class_2540 buf) {
            buf.writeByte(this.mode.ordinal());
            buf.writeFloat(this.nodeSize);
            buf.writeByte(this.colors.size());
            for (Map.Entry entry : this.colors.entrySet()) {
                Enum type = (Enum)entry.getKey();
                ColorData color = (ColorData)entry.getValue();
                if (type.getClass() == LinkFlag.class) {
                    buf.writeByte(FlagType.LINK.ordinal());
                    buf.writeByte(type.ordinal());
                    buf.writeInt(color.toARGB());
                }
                if (type.getClass() != NodeFlag.class) continue;
                buf.writeByte(FlagType.NODE.ordinal());
                buf.writeByte(type.ordinal());
                buf.writeInt(color.toARGB());
            }
        }

        public static AnalyserConfig readFromBytes(class_2540 buf) {
            AnalyserMode mode = AnalyserMode.byIndex(buf.readByte());
            float node_size = buf.readFloat();
            Reference2ObjectOpenHashMap colors = new Reference2ObjectOpenHashMap();
            int size = buf.readByte();
            block4: for (int i = 0; i < size; ++i) {
                FlagType type = FlagType.byIndex(buf.readByte());
                byte name = buf.readByte();
                ColorData color = new ColorData(buf.readInt());
                switch (type) {
                    case LINK: {
                        colors.put((Object)LinkFlag.byIndex(name), (Object)color);
                        continue block4;
                    }
                    case NODE: {
                        colors.put((Object)NodeFlag.byIndex(name), (Object)color);
                    }
                }
            }
            return new AnalyserConfig(mode, node_size, (Reference2ObjectMap<Enum<?>, ColorData>)colors);
        }
    }
}

