/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.ae2netanalyser.client.render;

import com.glodblock.github.ae2netanalyser.client.render.NetworkDataHandler;
import com.glodblock.github.ae2netanalyser.common.AEAItems;
import com.glodblock.github.ae2netanalyser.common.me.AnalyserMode;
import com.glodblock.github.ae2netanalyser.common.me.NetworkData;
import com.glodblock.github.ae2netanalyser.common.me.netdata.LinkFlag;
import com.glodblock.github.ae2netanalyser.util.ClientUtil;
import com.glodblock.github.ae2netanalyser.util.Util;
import com.glodblock.github.glodium.client.render.ColorData;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.EnumSet;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4184;
import net.minecraft.class_4208;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4668;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class NetworkRender
extends class_1921 {
    public static final NetworkRender INSTANCE = new NetworkRender();
    private static final Set<AnalyserMode> renderNodeModes = EnumSet.of(AnalyserMode.NODES, AnalyserMode.FULL, AnalyserMode.NONUM);
    private static final Set<AnalyserMode> renderLinkModes = EnumSet.of(AnalyserMode.CHANNELS, AnalyserMode.FULL, AnalyserMode.NONUM, AnalyserMode.P2P);
    private static class_1799 currentAnalyser;
    private static final ColorData WHITE;
    private final class_4668.class_4685 STO = new class_4668.class_4685("sto", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    private final class_1921 CUBE_RENDER = NetworkRender.method_24049((String)"aea_cube", (class_293)class_290.field_1576, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)false, (boolean)false, (class_1921.class_4688)class_1921.class_4688.method_23598().method_23615(this.STO).method_23604(field_21346).method_23603(field_21345).method_34578(field_29442).method_23608(field_21384).method_23616(field_21349).method_34577(field_21378).method_23617(true));

    public static void hook() {
        WorldRenderEvents.BEFORE_DEBUG_RENDER.register(listener -> {
            class_4587 ps = listener.matrixStack();
            class_4597 buffer = listener.consumers();
            class_4184 camera = listener.camera();
            class_746 player = class_310.method_1551().field_1724;
            if (player != null && player.method_6047().method_7909() == AEAItems.ANALYSER && buffer instanceof class_4597.class_4598) {
                class_4208 pos;
                class_4597.class_4598 source = (class_4597.class_4598)buffer;
                if (currentAnalyser != player.method_6047()) {
                    currentAnalyser = player.method_6047();
                    NetworkDataHandler.updateConfig(AEAItems.ANALYSER.getConfig(currentAnalyser));
                }
                if ((pos = AEAItems.ANALYSER.getPos(currentAnalyser)) != null && pos.method_19442().equals(player.method_37908().method_27983())) {
                    INSTANCE.tick(ps, source, camera);
                }
            }
        });
    }

    public void renderNodes(@NotNull NetworkData data, class_4587 stack, class_4597 multiBuf, class_243 offset) {
        for (NetworkData.ANode node : data.nodes) {
            ColorData color = NetworkDataHandler.getColorByConfig(node.state().get());
            this.drawCube(NetworkDataHandler.getNodeSize(), color, node.pos(), offset, stack, multiBuf);
        }
    }

    public void renderLinks(@NotNull NetworkData data, class_4587 stack, class_4597 multiBuf, class_243 offset, boolean p2pOnly) {
        for (NetworkData.ALink link : data.links) {
            LinkFlag flag = link.state().get();
            if (p2pOnly && flag != LinkFlag.COMPRESSED) continue;
            ColorData color = NetworkDataHandler.getColorByConfig(flag);
            this.drawLink(flag == LinkFlag.DENSE, color, link.a().pos(), link.b().pos(), offset, stack, multiBuf);
        }
    }

    public void drawInWorldText(String text, ColorData color, class_243 pos, class_243 offset, class_4184 camera, class_4587 stack, class_4597 multiBuf) {
        float scale = 0.027f;
        class_327 fontRender = class_310.method_1551().field_1772;
        class_243 c = pos.method_1019(offset);
        float stringMiddle = (float)fontRender.method_1727(text) / 2.0f;
        stack.method_22903();
        stack.method_22904(c.field_1352, c.field_1351, c.field_1350);
        stack.method_22907(camera.method_23767());
        stack.method_22905(-scale, -scale, scale);
        Matrix4f mat = stack.method_23760().method_23761();
        fontRender.method_27521(text, -stringMiddle, 0.0f, color.toARGB(), false, mat, multiBuf, class_327.class_6415.field_33994, 0, 0xF000F0);
        stack.method_22909();
    }

    public void drawCube(float size, ColorData color, class_2338 pos, class_243 offset, class_4587 stack, class_4597 multiBuf) {
        float half = size / 2.0f;
        class_4588 buf = multiBuf.getBuffer(this.CUBE_RENDER);
        class_243 c = pos.method_46558();
        class_238 box = new class_238(c.field_1352 - (double)half, c.field_1351 - (double)half, c.field_1350 - (double)half, c.field_1352 + (double)half, c.field_1351 + (double)half, c.field_1350 + (double)half);
        box = box.method_997(offset);
        class_243 topRight = new class_243(box.field_1320, box.field_1325, box.field_1324);
        class_243 bottomRight = new class_243(box.field_1320, box.field_1322, box.field_1324);
        class_243 bottomLeft = new class_243(box.field_1323, box.field_1322, box.field_1324);
        class_243 topLeft = new class_243(box.field_1323, box.field_1325, box.field_1324);
        class_243 topRight2 = new class_243(box.field_1320, box.field_1325, box.field_1321);
        class_243 bottomRight2 = new class_243(box.field_1320, box.field_1322, box.field_1321);
        class_243 bottomLeft2 = new class_243(box.field_1323, box.field_1322, box.field_1321);
        class_243 topLeft2 = new class_243(box.field_1323, box.field_1325, box.field_1321);
        this.drawSide(topRight, topLeft, bottomRight, bottomLeft, color, buf, stack);
        this.drawSide(topRight2, topRight, bottomRight2, bottomRight, color, buf, stack);
        this.drawSide(topLeft2, topRight2, bottomLeft2, bottomRight2, color, buf, stack);
        this.drawSide(topLeft, topLeft2, bottomLeft, bottomLeft2, color, buf, stack);
        this.drawSide(topLeft2, topRight2, topLeft, topRight, color, buf, stack);
        this.drawSide(bottomLeft2, bottomRight2, bottomLeft, bottomRight, color, buf, stack);
    }

    public void drawLink(boolean isDense, ColorData color, class_2338 from, class_2338 to, class_243 offset, class_4587 stack, class_4597 multiBuf) {
        class_4588 buf = multiBuf.getBuffer(this.CUBE_RENDER);
        class_243 a = from.method_46558().method_1019(offset);
        class_243 b = to.method_46558().method_1019(offset);
        double wide = isDense ? 0.1 : 0.025;
        class_243 law = ClientUtil.getLawVec(a, b).method_1021(wide);
        class_243 law2 = ClientUtil.getLawVec2(a, b).method_1021(wide);
        class_243 topRight = a.method_1019(law2);
        class_243 bottomRight = a.method_1020(law);
        class_243 bottomLeft = a.method_1020(law2);
        class_243 topLeft = a.method_1019(law);
        class_243 topRight2 = b.method_1019(law2);
        class_243 bottomRight2 = b.method_1020(law);
        class_243 bottomLeft2 = b.method_1020(law2);
        class_243 topLeft2 = b.method_1019(law);
        this.drawSide(topRight, topLeft, bottomRight, bottomLeft, color, buf, stack);
        this.drawSide(topRight2, topRight, bottomRight2, bottomRight, color, buf, stack);
        this.drawSide(topLeft2, topRight2, bottomLeft2, bottomRight2, color, buf, stack);
        this.drawSide(topLeft, topLeft2, bottomLeft, bottomLeft2, color, buf, stack);
        this.drawSide(topLeft2, topRight2, topLeft, topRight, color, buf, stack);
        this.drawSide(bottomLeft2, bottomRight2, bottomLeft, bottomRight, color, buf, stack);
    }

    private void drawSide(class_243 tr, class_243 tl, class_243 br, class_243 bl, ColorData color, class_4588 buf, class_4587 pose) {
        Matrix4f mat = pose.method_23760().method_23761();
        buf.method_22918(mat, (float)tr.field_1352, (float)tr.field_1351, (float)tr.field_1350).method_22915(color.getRf(), color.getGf(), color.getBf(), color.getAf()).method_1344();
        buf.method_22918(mat, (float)br.field_1352, (float)br.field_1351, (float)br.field_1350).method_22915(color.getRf(), color.getGf(), color.getBf(), color.getAf()).method_1344();
        buf.method_22918(mat, (float)bl.field_1352, (float)bl.field_1351, (float)bl.field_1350).method_22915(color.getRf(), color.getGf(), color.getBf(), color.getAf()).method_1344();
        buf.method_22918(mat, (float)tl.field_1352, (float)tl.field_1351, (float)tl.field_1350).method_22915(color.getRf(), color.getGf(), color.getBf(), color.getAf()).method_1344();
    }

    public void tick(class_4587 stack, class_4597.class_4598 multiBuf, class_4184 camera) {
        if (NetworkDataHandler.pullData() == null) {
            return;
        }
        if (camera.method_19332()) {
            class_243 offset = camera.method_19326().method_22882();
            AnalyserMode mode = NetworkDataHandler.getMode();
            RenderSystem.disableDepthTest();
            RenderSystem.enableBlend();
            stack.method_22903();
            if (renderNodeModes.contains((Object)mode)) {
                this.renderNodes(NetworkDataHandler.pullData(), stack, (class_4597)multiBuf, offset);
            }
            if (renderLinkModes.contains((Object)mode)) {
                this.renderLinks(NetworkDataHandler.pullData(), stack, (class_4597)multiBuf, offset, mode == AnalyserMode.P2P);
            }
            multiBuf.method_22993();
            RenderSystem.disableBlend();
            if (mode == AnalyserMode.FULL && !Util.isInfChannel()) {
                for (NetworkData.ALink link : NetworkDataHandler.pullData().links) {
                    if (link.channel() <= 0) continue;
                    this.drawInWorldText(String.valueOf(link.channel()), WHITE, ClientUtil.getCenter(link.a().pos(), link.b().pos()), offset, camera, stack, (class_4597)multiBuf);
                }
            }
            multiBuf.method_22993();
            stack.method_22909();
            RenderSystem.enableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
        }
    }

    public NetworkRender() {
        super("", class_290.field_29337, class_293.class_5596.field_27377, 0, false, false, () -> {}, () -> {});
    }

    static {
        WHITE = new ColorData(1.0f, 1.0f, 1.0f);
    }
}

