/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.ae2netanalyser.client.gui.elements;

import appeng.client.gui.AEBaseScreen;
import com.glodblock.github.ae2netanalyser.client.gui.elements.DrawableArea;
import com.glodblock.github.ae2netanalyser.client.gui.textures.Blitters;
import com.glodblock.github.glodium.util.GlodUtil;
import net.minecraft.class_332;

public class DraggableArea
extends DrawableArea {
    private double offset = 0.0;
    private boolean active = false;
    private float value;

    public DraggableArea(int x, int y, int width, int height, AEBaseScreen<?> parent) {
        super(x, y, width, height, parent, () -> {});
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float value) {
        this.value = (float)GlodUtil.clamp((double)value, (double)0.0, (double)1.0);
    }

    @Override
    public boolean click(double x, double y) {
        if (this.isMouseOver(x, y)) {
            this.active = true;
            this.offset = x;
            return true;
        }
        return false;
    }

    @Override
    public void release(double x, double y) {
        this.active = false;
    }

    public void drag(double x, double y) {
        if (this.active) {
            double move = (x - this.offset) / (double)this.w;
            this.offset = x;
            this.value = (float)GlodUtil.clamp((double)((double)this.value + move), (double)0.0, (double)1.0);
        }
    }

    @Override
    public void draw(class_332 guiGraphics) {
        int x = this.x + this.screen.getGuiLeft();
        int y = this.y + this.screen.getGuiTop();
        Blitters.SLIDER.dest((int)((float)x + this.value * (float)this.w), y).blit(guiGraphics);
    }

    @Override
    public boolean isMouseOver(double x, double y) {
        int offsetX = (int)(this.value * (float)this.w);
        return x >= (double)(this.x + this.screen.getGuiLeft() + offsetX) && x < (double)(this.x + this.screen.getGuiLeft() + this.w + offsetX) && y >= (double)(this.y + this.screen.getGuiTop()) && y < (double)(this.y + this.screen.getGuiTop() + this.h);
    }
}

