/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.ae2netanalyser.client.gui;

import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.style.ScreenStyle;
import appeng.menu.AEBaseMenu;
import com.glodblock.github.ae2netanalyser.client.gui.elements.ClickableArea;
import com.glodblock.github.ae2netanalyser.client.gui.elements.ColorArea;
import com.glodblock.github.ae2netanalyser.client.gui.elements.DraggableArea;
import com.glodblock.github.ae2netanalyser.client.gui.elements.DrawableArea;
import com.glodblock.github.ae2netanalyser.client.gui.textures.Blitters;
import com.glodblock.github.ae2netanalyser.client.render.NetworkDataHandler;
import com.glodblock.github.ae2netanalyser.common.items.ItemNetworkAnalyser;
import com.glodblock.github.ae2netanalyser.common.me.AnalyserMode;
import com.glodblock.github.ae2netanalyser.common.me.NetworkData;
import com.glodblock.github.ae2netanalyser.common.me.netdata.LinkFlag;
import com.glodblock.github.ae2netanalyser.common.me.netdata.NodeFlag;
import com.glodblock.github.ae2netanalyser.container.ContainerAnalyser;
import com.glodblock.github.ae2netanalyser.network.AEANetworkHandler;
import com.glodblock.github.ae2netanalyser.network.packets.CAnalyserConfigSave;
import com.glodblock.github.ae2netanalyser.util.Util;
import com.glodblock.github.glodium.client.render.ColorData;
import com.glodblock.github.glodium.network.packet.CGenericPacket;
import com.glodblock.github.glodium.network.packet.IMessage;
import com.glodblock.github.glodium.util.GlodUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_5348;

public class GuiAnalyser
extends AEBaseScreen<ContainerAnalyser> {
    private float size = 0.4f;
    private AnalyserMode mode = AnalyserMode.FULL;
    private final Reference2ObjectMap<Enum<?>, ColorData> colors = new Reference2ObjectOpenHashMap();
    private final Reference2ObjectMap<Enum<?>, ColorArea> colorBtns = new Reference2ObjectOpenHashMap();
    private final ArrayList<ClickableArea> clickables = new ArrayList();
    private final ColorWindow colorWindow;
    private final DraggableArea colorRed;
    private final DraggableArea colorGreen;
    private final DraggableArea colorBlue;
    private final ColorArea colorShow;
    private static final List<Enum<?>> COLOR_ORDER = List.of(LinkFlag.NORMAL, LinkFlag.DENSE, LinkFlag.COMPRESSED, NodeFlag.NORMAL, NodeFlag.DENSE, NodeFlag.MISSING);

    public GuiAnalyser(ContainerAnalyser menu, class_1661 playerInventory, class_2561 title, ScreenStyle style) {
        super((AEBaseMenu)menu, playerInventory, title, style);
        this.colors.putAll(ItemNetworkAnalyser.defaultColors);
        this.clickables.add(new ClickableArea(39, 21, 6, 11, this, () -> this.changeMode(-1)));
        this.clickables.add(new ClickableArea(107, 21, 6, 11, this, () -> this.changeMode(1)));
        this.clickables.add(new ClickableArea(39, 49, 6, 11, this, () -> this.changeSize(-0.1f)));
        this.clickables.add(new ClickableArea(107, 49, 6, 11, this, () -> this.changeSize(0.1f)));
        this.clickables.add(new ClickableArea(146, 142, 65, 14, this, this::loadDefault));
        for (int i = 0; i < COLOR_ORDER.size(); ++i) {
            Enum<?> mode = COLOR_ORDER.get(i);
            ColorArea btn = new ColorArea(198, 22 + i * 21, 25, 9, this, () -> this.beginColorConfig(mode));
            this.clickables.add(btn);
            this.colorBtns.put(mode, (Object)btn);
        }
        this.colorWindow = new ColorWindow(73, 48, 110, 80, this);
        this.colorRed = new DraggableArea(81, 57, 90, 7, this);
        this.colorWindow.addElement(this.colorRed);
        this.colorGreen = new DraggableArea(81, 72, 90, 7, this);
        this.colorWindow.addElement(this.colorGreen);
        this.colorBlue = new DraggableArea(81, 87, 90, 7, this);
        this.colorWindow.addElement(this.colorBlue);
        this.colorShow = new ColorArea(114, 106, 27, 7, this, () -> {});
        this.colorWindow.addElement(this.colorShow);
        this.colorWindow.addElement(new ClickableArea(90, 103, 13, 13, this, () -> this.closeColorConfig(true)));
        this.colorWindow.addElement(new ClickableArea(152, 103, 13, 13, this, () -> this.closeColorConfig(false)));
        AEANetworkHandler.INSTANCE.sendToServer((IMessage)new CGenericPacket("update"));
    }

    public void loadConfig(ItemNetworkAnalyser.AnalyserConfig config) {
        this.mode = config.mode();
        this.size = config.nodeSize();
        this.colors.clear();
        this.colors.putAll(config.colors());
        for (Map.Entry entry : this.colors.entrySet()) {
            ColorArea btn = (ColorArea)this.colorBtns.get(entry.getKey());
            btn.setColor((ColorData)entry.getValue());
        }
    }

    public void loadDefault() {
        this.colors.clear();
        this.colors.putAll(ItemNetworkAnalyser.defaultColors);
        for (Map.Entry entry : this.colors.entrySet()) {
            ColorArea btn = (ColorArea)this.colorBtns.get(entry.getKey());
            btn.setColor((ColorData)entry.getValue());
        }
    }

    public void closeColorConfig(boolean save) {
        if (save) {
            ColorArea colorBtn = (ColorArea)this.colorBtns.get(this.colorWindow.configType);
            ColorData newData = this.colorShow.getColor();
            colorBtn.setColor(newData);
            this.colors.put(this.colorWindow.configType, (Object)newData);
        }
        this.colorWindow.isOn = false;
    }

    private void beginColorConfig(Enum<?> type) {
        this.colorWindow.isOn = true;
        this.colorWindow.configType = type;
        ColorData color = ((ColorArea)this.colorBtns.get(type)).getColor();
        this.colorRed.setValue(color.getRf());
        this.colorGreen.setValue(color.getGf());
        this.colorBlue.setValue(color.getBf());
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        RenderSystem.disableDepthTest();
        for (ClickableArea c : this.clickables) {
            if (!(c instanceof DrawableArea)) continue;
            DrawableArea d = (DrawableArea)c;
            d.draw(guiGraphics);
        }
        if (this.colorWindow.isOn) {
            this.colorShow.setColor(new ColorData(0.8f, this.colorRed.getValue(), this.colorGreen.getValue(), this.colorBlue.getValue()));
            this.colorWindow.draw(guiGraphics);
        }
        RenderSystem.enableDepthTest();
    }

    public boolean method_25402(double xCoord, double yCoord, int btn) {
        if (this.colorWindow.isOn) {
            return this.colorWindow.click(xCoord, yCoord);
        }
        for (ClickableArea c : this.clickables) {
            if (!c.click(xCoord, yCoord)) continue;
            return true;
        }
        return super.method_25402(xCoord, yCoord, btn);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.colorWindow.isOn) {
            this.colorWindow.release(mouseX, mouseY);
            return true;
        }
        this.clickables.forEach(c -> c.release(mouseX, mouseY));
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
        if (this.colorWindow.isOn) {
            this.colorWindow.drag(mouseX, mouseY);
            return true;
        }
        return super.method_25403(mouseX, mouseY, mouseButton, dragX, dragY);
    }

    public void drawFG(class_332 guiGraphics, int offsetX, int offsetY, int mouseX, int mouseY) {
        this.drawCenteredText(guiGraphics, this.mode.getTranslatedName(), 76, 27, -1);
        this.drawCenteredText(guiGraphics, (class_2561)class_2561.method_43471((String)"gui.ae2netanalyser.network_analyser.mode"), 24, 26, -1);
        this.drawCenteredText(guiGraphics, String.valueOf((int)(this.size * 10.0f)), 76, 55, -1);
        this.drawCenteredText(guiGraphics, (class_2561)class_2561.method_43471((String)"gui.ae2netanalyser.network_analyser.node_size"), 24, 54, -1);
        this.drawCenteredText(guiGraphics, (class_2561)class_2561.method_43471((String)"gui.ae2netanalyser.network_analyser.reset"), 179, 149, -1);
        for (int i = 0; i < COLOR_ORDER.size(); ++i) {
            Enum<?> m = COLOR_ORDER.get(i);
            if (m.getClass() == NodeFlag.class) {
                guiGraphics.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)("gui.ae2netanalyser.network_analyser.NODE." + m.name())), 134, 23 + 21 * i, -1, false);
            }
            if (m.getClass() != LinkFlag.class) continue;
            guiGraphics.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)("gui.ae2netanalyser.network_analyser.LINK." + m.name())), 134, 23 + 21 * i, -1, false);
        }
        guiGraphics.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)("gui.ae2netanalyser.network_analyser.channel." + Util.getChannelMode().name())), 16, 72, -1, false);
        guiGraphics.method_51439(this.field_22793, (class_2561)class_2561.method_43469((String)"gui.ae2netanalyser.network_analyser.state.normal_nodes", (Object[])new Object[]{this.countNode(NodeFlag.NORMAL)}), 16, 86, -16711936, false);
        guiGraphics.method_51439(this.field_22793, (class_2561)class_2561.method_43469((String)"gui.ae2netanalyser.network_analyser.state.dense_nodes", (Object[])new Object[]{this.countNode(NodeFlag.DENSE)}), 16, 100, -16711681, false);
        guiGraphics.method_51439(this.field_22793, (class_2561)class_2561.method_43469((String)"gui.ae2netanalyser.network_analyser.state.missing_nodes", (Object[])new Object[]{this.countNode(NodeFlag.MISSING)}), 16, 114, -65536, false);
    }

    private int countNode(NodeFlag type) {
        NetworkData data = NetworkDataHandler.pullData();
        if (data != null) {
            return data.countNode(type);
        }
        return 0;
    }

    private void drawCenteredText(class_332 guiGraphics, String text, int centerX, int centerY, int color) {
        this.drawCenteredText(guiGraphics, (class_2561)class_2561.method_43470((String)text), centerX, centerY, color);
    }

    private void drawCenteredText(class_332 guiGraphics, class_2561 text, int centerX, int centerY, int color) {
        int width = this.field_22793.method_27525((class_5348)text);
        Objects.requireNonNull(this.field_22793);
        int height = 9;
        guiGraphics.method_51439(this.field_22793, text, centerX - width / 2, centerY - height / 2, color, false);
    }

    private void changeMode(int offset) {
        this.mode = AnalyserMode.byIndex((this.mode.ordinal() + offset + AnalyserMode.values().length) % AnalyserMode.values().length);
    }

    private void changeSize(float offset) {
        this.size += offset;
        this.size = (float)GlodUtil.clamp((double)this.size, (double)0.1, (double)0.9);
    }

    public void method_25419() {
        AEANetworkHandler.INSTANCE.sendToServer((IMessage)new CAnalyserConfigSave(new ItemNetworkAnalyser.AnalyserConfig(this.mode, this.size, this.colors)));
        super.method_25419();
    }

    private static class ColorWindow
    extends ClickableArea {
        final List<ClickableArea> elements = new ArrayList<ClickableArea>();
        Enum<?> configType;
        boolean isOn = false;

        public ColorWindow(int x, int y, int width, int height, AEBaseScreen<?> parent) {
            super(x, y, width, height, parent, () -> {});
        }

        public void draw(class_332 guiGraphics) {
            if (this.isOn) {
                Blitters.COLOR_SUB_MENU.dest(this.x + this.screen.getGuiLeft(), this.y + this.screen.getGuiTop()).blit(guiGraphics);
                for (ClickableArea c : this.elements) {
                    if (!(c instanceof DrawableArea)) continue;
                    DrawableArea d = (DrawableArea)c;
                    d.draw(guiGraphics);
                }
            }
        }

        public void addElement(ClickableArea c) {
            this.elements.add(c);
        }

        @Override
        public boolean click(double x, double y) {
            if (this.isMouseOver(x, y)) {
                for (ClickableArea c : this.elements) {
                    if (!c.click(x, y)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public void release(double x, double y) {
            for (ClickableArea c : this.elements) {
                c.release(x, y);
            }
        }

        public void drag(double x, double y) {
            for (ClickableArea c : this.elements) {
                if (!(c instanceof DraggableArea)) continue;
                DraggableArea d = (DraggableArea)c;
                d.drag(x, y);
            }
        }
    }
}

