/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashSet;
import java.util.stream.Collectors;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraft.data.AdvancementProvider;
import net.minecraft.data.BiomeProvider;
import net.minecraft.data.BlockListReport;
import net.minecraft.data.BlockStateProvider;
import net.minecraft.data.BlockTagsProvider;
import net.minecraft.data.CommandsReport;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.EntityTypeTagsProvider;
import net.minecraft.data.FluidTagsProvider;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.ItemTagsProvider;
import net.minecraft.data.LootTableProvider;
import net.minecraft.data.NBTToSNBTConverter;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.RegistryDumpReport;
import net.minecraft.data.SNBTToNBTConverter;
import net.minecraft.data.StructureUpdater;
import net.minecraftforge.fml.DatagenModLoader;

public class Main {
    public static void main(String[] p_main_0_) throws IOException {
        OptionParser optionparser = new OptionParser();
        AbstractOptionSpec optionspec = optionparser.accepts("help", "Show the help menu").forHelp();
        OptionSpecBuilder optionspec1 = optionparser.accepts("server", "Include server generators");
        OptionSpecBuilder optionspec2 = optionparser.accepts("client", "Include client generators");
        OptionSpecBuilder optionspec3 = optionparser.accepts("dev", "Include development tools");
        OptionSpecBuilder optionspec4 = optionparser.accepts("reports", "Include data reports");
        OptionSpecBuilder optionspec5 = optionparser.accepts("validate", "Validate inputs");
        OptionSpecBuilder optionspec6 = optionparser.accepts("all", "Include all generators");
        ArgumentAcceptingOptionSpec optionspec7 = optionparser.accepts("output", "Output folder").withRequiredArg().defaultsTo((Object)"generated", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec optionspec8 = optionparser.accepts("input", "Input folder").withRequiredArg();
        ArgumentAcceptingOptionSpec existing = optionparser.accepts("existing", "Existing resource packs that generated resources can reference").withRequiredArg();
        ArgumentAcceptingOptionSpec existingMod = optionparser.accepts("existing-mod", "Existing mods that generated resources can reference the resource packs of").withRequiredArg();
        ArgumentAcceptingOptionSpec gameDir = optionparser.accepts("gameDir").withRequiredArg().ofType(File.class).defaultsTo((Object)new File("."), (Object[])new File[0]).required();
        ArgumentAcceptingOptionSpec mod = optionparser.accepts("mod", "A modid to dump").withRequiredArg().withValuesSeparatedBy(",");
        OptionSpecBuilder flat = optionparser.accepts("flat", "Do not append modid prefix to output directory when generating for multiple mods");
        ArgumentAcceptingOptionSpec assetIndex = optionparser.accepts("assetIndex").withRequiredArg();
        ArgumentAcceptingOptionSpec assetsDir = optionparser.accepts("assetsDir").withRequiredArg().ofType(File.class);
        OptionSet optionset = optionparser.parse(p_main_0_);
        if (!(optionset.has((OptionSpec)optionspec) || !optionset.hasOptions() || optionset.specs().size() == 1 && optionset.has((OptionSpec)gameDir))) {
            Path path = Paths.get((String)optionspec7.value(optionset), new String[0]);
            boolean flag = optionset.has((OptionSpec)optionspec6);
            boolean flag1 = flag || optionset.has((OptionSpec)optionspec2);
            boolean flag2 = flag || optionset.has((OptionSpec)optionspec1);
            boolean flag3 = flag || optionset.has((OptionSpec)optionspec3);
            boolean flag4 = flag || optionset.has((OptionSpec)optionspec4);
            boolean flag5 = flag || optionset.has((OptionSpec)optionspec5);
            Collection inputs = optionset.valuesOf((OptionSpec)optionspec8).stream().map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
            Collection existingPacks = optionset.valuesOf((OptionSpec)existing).stream().map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
            HashSet existingMods = new HashSet(optionset.valuesOf((OptionSpec)existingMod));
            HashSet mods = new HashSet(optionset.valuesOf((OptionSpec)mod));
            boolean isFlat = mods.isEmpty() || optionset.has((OptionSpec)flat);
            DatagenModLoader.begin(mods, (Path)path, (Collection)inputs, (Collection)existingPacks, existingMods, (boolean)flag2, (boolean)flag1, (boolean)flag3, (boolean)flag4, (boolean)flag5, (boolean)isFlat, (String)((String)optionset.valueOf((OptionSpec)assetIndex)), (File)((File)optionset.valueOf((OptionSpec)assetsDir)));
            if (mods.contains("minecraft") || mods.isEmpty()) {
                Main.func_200264_a(isFlat ? path : path.resolve("minecraft"), inputs, flag1, flag2, flag3, flag4, flag5).func_200392_c();
            }
        } else {
            optionparser.printHelpOn((OutputStream)System.out);
        }
    }

    public static DataGenerator func_200264_a(Path p_200264_0_, Collection<Path> p_200264_1_, boolean p_200264_2_, boolean p_200264_3_, boolean p_200264_4_, boolean p_200264_5_, boolean p_200264_6_) {
        DataGenerator datagenerator = new DataGenerator(p_200264_0_, p_200264_1_);
        if (p_200264_2_ || p_200264_3_) {
            datagenerator.func_200390_a((IDataProvider)new SNBTToNBTConverter(datagenerator).func_225369_a((SNBTToNBTConverter.ITransformer)new StructureUpdater()));
        }
        if (p_200264_2_) {
            datagenerator.func_200390_a((IDataProvider)new BlockStateProvider(datagenerator));
        }
        if (p_200264_3_) {
            datagenerator.func_200390_a(new FluidTagsProvider(datagenerator));
            BlockTagsProvider blocktagsprovider = new BlockTagsProvider(datagenerator);
            datagenerator.func_200390_a(blocktagsprovider);
            datagenerator.func_200390_a(new ItemTagsProvider(datagenerator, blocktagsprovider));
            datagenerator.func_200390_a(new EntityTypeTagsProvider(datagenerator));
            datagenerator.func_200390_a(new RecipeProvider(datagenerator));
            datagenerator.func_200390_a(new AdvancementProvider(datagenerator));
            datagenerator.func_200390_a(new LootTableProvider(datagenerator));
        }
        if (p_200264_4_) {
            datagenerator.func_200390_a((IDataProvider)new NBTToSNBTConverter(datagenerator));
        }
        if (p_200264_5_) {
            datagenerator.func_200390_a((IDataProvider)new BlockListReport(datagenerator));
            datagenerator.func_200390_a((IDataProvider)new RegistryDumpReport(datagenerator));
            datagenerator.func_200390_a((IDataProvider)new CommandsReport(datagenerator));
            datagenerator.func_200390_a((IDataProvider)new BiomeProvider(datagenerator));
        }
        return datagenerator;
    }
}

