/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.arguments;

import com.google.common.collect.Maps;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ITagCollection;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.TranslationTextComponent;

public class BlockStateParser {
    public static final SimpleCommandExceptionType field_199831_a = new SimpleCommandExceptionType((Message)new TranslationTextComponent("argument.block.tag.disallowed"));
    public static final DynamicCommandExceptionType field_197259_a = new DynamicCommandExceptionType(p_208687_0_ -> new TranslationTextComponent("argument.block.id.invalid", p_208687_0_));
    public static final Dynamic2CommandExceptionType field_197260_b = new Dynamic2CommandExceptionType((p_208685_0_, p_208685_1_) -> new TranslationTextComponent("argument.block.property.unknown", p_208685_0_, p_208685_1_));
    public static final Dynamic2CommandExceptionType field_197261_c = new Dynamic2CommandExceptionType((p_208690_0_, p_208690_1_) -> new TranslationTextComponent("argument.block.property.duplicate", p_208690_1_, p_208690_0_));
    public static final Dynamic3CommandExceptionType field_197262_d = new Dynamic3CommandExceptionType((p_208684_0_, p_208684_1_, p_208684_2_) -> new TranslationTextComponent("argument.block.property.invalid", p_208684_0_, p_208684_2_, p_208684_1_));
    public static final Dynamic2CommandExceptionType field_197263_e = new Dynamic2CommandExceptionType((p_208689_0_, p_208689_1_) -> new TranslationTextComponent("argument.block.property.novalue", p_208689_0_, p_208689_1_));
    public static final SimpleCommandExceptionType field_197264_f = new SimpleCommandExceptionType((Message)new TranslationTextComponent("argument.block.property.unclosed"));
    private static final BiFunction<SuggestionsBuilder, ITagCollection<Block>, CompletableFuture<Suggestions>> field_197265_g = (p_239308_0_, p_239308_1_) -> p_239308_0_.buildFuture();
    private final StringReader field_197266_h;
    private final boolean field_199832_j;
    private final Map<Property<?>, Comparable<?>> field_197267_i = Maps.newHashMap();
    private final Map<String, String> field_200141_l = Maps.newHashMap();
    private ResourceLocation field_197268_j = new ResourceLocation("");
    private StateContainer<Block, BlockState> field_197269_k;
    private BlockState field_197270_l;
    @Nullable
    private CompoundNBT field_197271_m;
    private ResourceLocation field_199833_p = new ResourceLocation("");
    private int field_201954_r;
    private BiFunction<SuggestionsBuilder, ITagCollection<Block>, CompletableFuture<Suggestions>> field_197272_n = field_197265_g;

    public BlockStateParser(StringReader p_i48214_1_, boolean p_i48214_2_) {
        this.field_197266_h = p_i48214_1_;
        this.field_199832_j = p_i48214_2_;
    }

    public Map<Property<?>, Comparable<?>> func_197254_a() {
        return this.field_197267_i;
    }

    @Nullable
    public BlockState func_197249_b() {
        return this.field_197270_l;
    }

    @Nullable
    public CompoundNBT func_197241_c() {
        return this.field_197271_m;
    }

    @Nullable
    public ResourceLocation func_199829_d() {
        return this.field_199833_p;
    }

    public BlockStateParser func_197243_a(boolean p_197243_1_) throws CommandSyntaxException {
        this.field_197272_n = this::func_197250_h;
        if (this.field_197266_h.canRead() && this.field_197266_h.peek() == '#') {
            this.func_199827_f();
            this.field_197272_n = this::func_212599_i;
            if (this.field_197266_h.canRead() && this.field_197266_h.peek() == '[') {
                this.func_200137_h();
                this.field_197272_n = this::func_197244_d;
            }
        } else {
            this.func_197258_d();
            this.field_197272_n = this::func_197255_g;
            if (this.field_197266_h.canRead() && this.field_197266_h.peek() == '[') {
                this.func_197257_e();
                this.field_197272_n = this::func_197244_d;
            }
        }
        if (p_197243_1_ && this.field_197266_h.canRead() && this.field_197266_h.peek() == '{') {
            this.field_197272_n = field_197265_g;
            this.func_197240_f();
        }
        return this;
    }

    private CompletableFuture<Suggestions> func_197252_b(SuggestionsBuilder p_197252_1_, ITagCollection<Block> p_197252_2_) {
        if (p_197252_1_.getRemaining().isEmpty()) {
            p_197252_1_.suggest(String.valueOf(']'));
        }
        return this.func_197256_c(p_197252_1_, p_197252_2_);
    }

    private CompletableFuture<Suggestions> func_200136_c(SuggestionsBuilder p_200136_1_, ITagCollection<Block> p_200136_2_) {
        if (p_200136_1_.getRemaining().isEmpty()) {
            p_200136_1_.suggest(String.valueOf(']'));
        }
        return this.func_200134_e(p_200136_1_, p_200136_2_);
    }

    private CompletableFuture<Suggestions> func_197256_c(SuggestionsBuilder p_197256_1_, ITagCollection<Block> p_197256_2_) {
        String s = p_197256_1_.getRemaining().toLowerCase(Locale.ROOT);
        for (Property property : this.field_197270_l.func_235904_r_()) {
            if (this.field_197267_i.containsKey(property) || !property.func_177701_a().startsWith(s)) continue;
            p_197256_1_.suggest(property.func_177701_a() + '=');
        }
        return p_197256_1_.buildFuture();
    }

    private CompletableFuture<Suggestions> func_200134_e(SuggestionsBuilder p_200134_1_, ITagCollection<Block> p_200134_2_) {
        ITag<Block> itag;
        String s = p_200134_1_.getRemaining().toLowerCase(Locale.ROOT);
        if (this.field_199833_p != null && !this.field_199833_p.func_110623_a().isEmpty() && (itag = p_200134_2_.func_199910_a(this.field_199833_p)) != null) {
            for (Block block : itag.func_230236_b_()) {
                for (Property property : block.func_176194_O().func_177623_d()) {
                    if (this.field_200141_l.containsKey(property.func_177701_a()) || !property.func_177701_a().startsWith(s)) continue;
                    p_200134_1_.suggest(property.func_177701_a() + '=');
                }
            }
        }
        return p_200134_1_.buildFuture();
    }

    private CompletableFuture<Suggestions> func_197244_d(SuggestionsBuilder p_197244_1_, ITagCollection<Block> p_197244_2_) {
        if (p_197244_1_.getRemaining().isEmpty() && this.func_212598_k(p_197244_2_)) {
            p_197244_1_.suggest(String.valueOf('{'));
        }
        return p_197244_1_.buildFuture();
    }

    private boolean func_212598_k(ITagCollection<Block> p_212598_1_) {
        ITag<Block> itag;
        if (this.field_197270_l != null) {
            return this.field_197270_l.hasTileEntity();
        }
        if (this.field_199833_p != null && (itag = p_212598_1_.func_199910_a(this.field_199833_p)) != null) {
            for (Block block : itag.func_230236_b_()) {
                if (!block.func_235695_q_()) continue;
                return true;
            }
        }
        return false;
    }

    private CompletableFuture<Suggestions> func_197246_e(SuggestionsBuilder p_197246_1_, ITagCollection<Block> p_197246_2_) {
        if (p_197246_1_.getRemaining().isEmpty()) {
            p_197246_1_.suggest(String.valueOf('='));
        }
        return p_197246_1_.buildFuture();
    }

    private CompletableFuture<Suggestions> func_197248_f(SuggestionsBuilder p_197248_1_, ITagCollection<Block> p_197248_2_) {
        if (p_197248_1_.getRemaining().isEmpty()) {
            p_197248_1_.suggest(String.valueOf(']'));
        }
        if (p_197248_1_.getRemaining().isEmpty() && this.field_197267_i.size() < this.field_197270_l.func_235904_r_().size()) {
            p_197248_1_.suggest(String.valueOf(','));
        }
        return p_197248_1_.buildFuture();
    }

    private static <T extends Comparable<T>> SuggestionsBuilder func_201037_a(SuggestionsBuilder p_201037_0_, Property<T> p_201037_1_) {
        for (Comparable t : p_201037_1_.func_177700_c()) {
            if (t instanceof Integer) {
                p_201037_0_.suggest(((Integer)t).intValue());
                continue;
            }
            p_201037_0_.suggest(p_201037_1_.func_177702_a(t));
        }
        return p_201037_0_;
    }

    private CompletableFuture<Suggestions> func_239295_a_(SuggestionsBuilder p_239295_1_, ITagCollection<Block> p_239295_2_, String p_239295_3_) {
        ITag<Block> itag;
        boolean flag = false;
        if (this.field_199833_p != null && !this.field_199833_p.func_110623_a().isEmpty() && (itag = p_239295_2_.func_199910_a(this.field_199833_p)) != null) {
            block0: for (Block block : itag.func_230236_b_()) {
                Property property = block.func_176194_O().func_185920_a(p_239295_3_);
                if (property != null) {
                    BlockStateParser.func_201037_a(p_239295_1_, property);
                }
                if (flag) continue;
                for (Property property1 : block.func_176194_O().func_177623_d()) {
                    if (this.field_200141_l.containsKey(property1.func_177701_a())) continue;
                    flag = true;
                    continue block0;
                }
            }
        }
        if (flag) {
            p_239295_1_.suggest(String.valueOf(','));
        }
        p_239295_1_.suggest(String.valueOf(']'));
        return p_239295_1_.buildFuture();
    }

    private CompletableFuture<Suggestions> func_212599_i(SuggestionsBuilder p_212599_1_, ITagCollection<Block> p_212599_2_) {
        ITag<Block> itag;
        if (p_212599_1_.getRemaining().isEmpty() && (itag = p_212599_2_.func_199910_a(this.field_199833_p)) != null) {
            Block block;
            boolean flag = false;
            boolean flag1 = false;
            Iterator<Block> iterator = itag.func_230236_b_().iterator();
            while (!(!iterator.hasNext() || (flag |= !(block = iterator.next()).func_176194_O().func_177623_d().isEmpty()) && (flag1 |= block.func_235695_q_()))) {
            }
            if (flag) {
                p_212599_1_.suggest(String.valueOf('['));
            }
            if (flag1) {
                p_212599_1_.suggest(String.valueOf('{'));
            }
        }
        return this.func_201953_j(p_212599_1_, p_212599_2_);
    }

    private CompletableFuture<Suggestions> func_197255_g(SuggestionsBuilder p_197255_1_, ITagCollection<Block> p_197255_2_) {
        if (p_197255_1_.getRemaining().isEmpty()) {
            if (!this.field_197270_l.func_177230_c().func_176194_O().func_177623_d().isEmpty()) {
                p_197255_1_.suggest(String.valueOf('['));
            }
            if (this.field_197270_l.hasTileEntity()) {
                p_197255_1_.suggest(String.valueOf('{'));
            }
        }
        return p_197255_1_.buildFuture();
    }

    private CompletableFuture<Suggestions> func_201953_j(SuggestionsBuilder p_201953_1_, ITagCollection<Block> p_201953_2_) {
        return ISuggestionProvider.func_197014_a(p_201953_2_.func_199908_a(), (SuggestionsBuilder)p_201953_1_.createOffset(this.field_201954_r).add(p_201953_1_));
    }

    private CompletableFuture<Suggestions> func_197250_h(SuggestionsBuilder p_197250_1_, ITagCollection<Block> p_197250_2_) {
        if (this.field_199832_j) {
            ISuggestionProvider.func_197006_a(p_197250_2_.func_199908_a(), (SuggestionsBuilder)p_197250_1_, (String)String.valueOf('#'));
        }
        ISuggestionProvider.func_197014_a((Iterable)Registry.field_212618_g.func_148742_b(), (SuggestionsBuilder)p_197250_1_);
        return p_197250_1_.buildFuture();
    }

    public void func_197258_d() throws CommandSyntaxException {
        int i = this.field_197266_h.getCursor();
        this.field_197268_j = ResourceLocation.func_195826_a(this.field_197266_h);
        Block block = (Block)((Object)Registry.field_212618_g.func_241873_b(this.field_197268_j).orElseThrow(() -> {
            this.field_197266_h.setCursor(i);
            return field_197259_a.createWithContext((ImmutableStringReader)this.field_197266_h, (Object)this.field_197268_j.toString());
        }));
        this.field_197269_k = block.func_176194_O();
        this.field_197270_l = block.func_176223_P();
    }

    public void func_199827_f() throws CommandSyntaxException {
        if (!this.field_199832_j) {
            throw field_199831_a.create();
        }
        this.field_197272_n = this::func_201953_j;
        this.field_197266_h.expect('#');
        this.field_201954_r = this.field_197266_h.getCursor();
        this.field_199833_p = ResourceLocation.func_195826_a(this.field_197266_h);
    }

    public void func_197257_e() throws CommandSyntaxException {
        this.field_197266_h.skip();
        this.field_197272_n = this::func_197252_b;
        this.field_197266_h.skipWhitespace();
        while (this.field_197266_h.canRead() && this.field_197266_h.peek() != ']') {
            this.field_197266_h.skipWhitespace();
            int i = this.field_197266_h.getCursor();
            String s = this.field_197266_h.readString();
            Property property = this.field_197269_k.func_185920_a(s);
            if (property == null) {
                this.field_197266_h.setCursor(i);
                throw field_197260_b.createWithContext((ImmutableStringReader)this.field_197266_h, (Object)this.field_197268_j.toString(), (Object)s);
            }
            if (this.field_197267_i.containsKey(property)) {
                this.field_197266_h.setCursor(i);
                throw field_197261_c.createWithContext((ImmutableStringReader)this.field_197266_h, (Object)this.field_197268_j.toString(), (Object)s);
            }
            this.field_197266_h.skipWhitespace();
            this.field_197272_n = this::func_197246_e;
            if (!this.field_197266_h.canRead() || this.field_197266_h.peek() != '=') {
                throw field_197263_e.createWithContext((ImmutableStringReader)this.field_197266_h, (Object)this.field_197268_j.toString(), (Object)s);
            }
            this.field_197266_h.skip();
            this.field_197266_h.skipWhitespace();
            this.field_197272_n = (p_197251_1_, p_197251_2_) -> BlockStateParser.func_201037_a(p_197251_1_, property).buildFuture();
            int j = this.field_197266_h.getCursor();
            this.func_197253_a(property, this.field_197266_h.readString(), j);
            this.field_197272_n = this::func_197248_f;
            this.field_197266_h.skipWhitespace();
            if (!this.field_197266_h.canRead()) continue;
            if (this.field_197266_h.peek() == ',') {
                this.field_197266_h.skip();
                this.field_197272_n = this::func_197256_c;
                continue;
            }
            if (this.field_197266_h.peek() == ']') break;
            throw field_197264_f.createWithContext((ImmutableStringReader)this.field_197266_h);
        }
        if (this.field_197266_h.canRead()) {
            this.field_197266_h.skip();
            return;
        }
        throw field_197264_f.createWithContext((ImmutableStringReader)this.field_197266_h);
    }

    public void func_200137_h() throws CommandSyntaxException {
        this.field_197266_h.skip();
        this.field_197272_n = this::func_200136_c;
        int i = -1;
        this.field_197266_h.skipWhitespace();
        while (this.field_197266_h.canRead() && this.field_197266_h.peek() != ']') {
            this.field_197266_h.skipWhitespace();
            int j = this.field_197266_h.getCursor();
            String s = this.field_197266_h.readString();
            if (this.field_200141_l.containsKey(s)) {
                this.field_197266_h.setCursor(j);
                throw field_197261_c.createWithContext((ImmutableStringReader)this.field_197266_h, (Object)this.field_197268_j.toString(), (Object)s);
            }
            this.field_197266_h.skipWhitespace();
            if (!this.field_197266_h.canRead() || this.field_197266_h.peek() != '=') {
                this.field_197266_h.setCursor(j);
                throw field_197263_e.createWithContext((ImmutableStringReader)this.field_197266_h, (Object)this.field_197268_j.toString(), (Object)s);
            }
            this.field_197266_h.skip();
            this.field_197266_h.skipWhitespace();
            this.field_197272_n = (p_200138_2_, p_200138_3_) -> this.func_239295_a_((SuggestionsBuilder)p_200138_2_, (ITagCollection<Block>)p_200138_3_, s);
            i = this.field_197266_h.getCursor();
            String s1 = this.field_197266_h.readString();
            this.field_200141_l.put(s, s1);
            this.field_197266_h.skipWhitespace();
            if (!this.field_197266_h.canRead()) continue;
            i = -1;
            if (this.field_197266_h.peek() == ',') {
                this.field_197266_h.skip();
                this.field_197272_n = this::func_200134_e;
                continue;
            }
            if (this.field_197266_h.peek() == ']') break;
            throw field_197264_f.createWithContext((ImmutableStringReader)this.field_197266_h);
        }
        if (this.field_197266_h.canRead()) {
            this.field_197266_h.skip();
            return;
        }
        if (i >= 0) {
            this.field_197266_h.setCursor(i);
        }
        throw field_197264_f.createWithContext((ImmutableStringReader)this.field_197266_h);
    }

    public void func_197240_f() throws CommandSyntaxException {
        this.field_197271_m = new JsonToNBT(this.field_197266_h).func_193593_f();
    }

    private <T extends Comparable<T>> void func_197253_a(Property<T> p_197253_1_, String p_197253_2_, int p_197253_3_) throws CommandSyntaxException {
        Optional optional = p_197253_1_.func_185929_b(p_197253_2_);
        if (!optional.isPresent()) {
            this.field_197266_h.setCursor(p_197253_3_);
            throw field_197262_d.createWithContext((ImmutableStringReader)this.field_197266_h, (Object)this.field_197268_j.toString(), (Object)p_197253_1_.func_177701_a(), (Object)p_197253_2_);
        }
        this.field_197270_l = (BlockState)((Object)this.field_197270_l.func_206870_a(p_197253_1_, (Comparable)optional.get()));
        this.field_197267_i.put(p_197253_1_, (Comparable<?>)optional.get());
    }

    public static String func_197247_a(BlockState p_197247_0_) {
        StringBuilder stringbuilder = new StringBuilder(Registry.field_212618_g.func_177774_c((Object)p_197247_0_.func_177230_c()).toString());
        if (!p_197247_0_.func_235904_r_().isEmpty()) {
            stringbuilder.append('[');
            boolean flag = false;
            for (Map.Entry entry : p_197247_0_.func_206871_b().entrySet()) {
                if (flag) {
                    stringbuilder.append(',');
                }
                BlockStateParser.func_211375_a(stringbuilder, (Property)entry.getKey(), (Comparable)entry.getValue());
                flag = true;
            }
            stringbuilder.append(']');
        }
        return stringbuilder.toString();
    }

    private static <T extends Comparable<T>> void func_211375_a(StringBuilder p_211375_0_, Property<T> p_211375_1_, Comparable<?> p_211375_2_) {
        p_211375_0_.append(p_211375_1_.func_177701_a());
        p_211375_0_.append('=');
        p_211375_0_.append(p_211375_1_.func_177702_a(p_211375_2_));
    }

    public CompletableFuture<Suggestions> func_197245_a(SuggestionsBuilder p_197245_1_, ITagCollection<Block> p_197245_2_) {
        return this.field_197272_n.apply(p_197245_1_.createOffset(this.field_197266_h.getCursor()), p_197245_2_);
    }

    public Map<String, String> func_200139_j() {
        return this.field_200141_l;
    }
}

