/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.spawner;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.pathfinding.PathType;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.DefaultBiomeMagnifier;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.MobDensityTracker;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class WorldEntitySpawner {
    private static final Logger field_209383_a = LogManager.getLogger();
    private static final int field_234960_b_ = (int)Math.pow(17.0, 2.0);
    private static final EntityClassification[] field_234961_c_ = (EntityClassification[])Stream.of(EntityClassification.values()).filter(entityClassification -> entityClassification != EntityClassification.MISC).toArray(EntityClassification[]::new);

    public static EntityDensityManager func_234964_a_(int n, Iterable<Entity> iterable, IInitialDensityAdder iInitialDensityAdder) {
        MobDensityTracker mobDensityTracker = new MobDensityTracker();
        Object2IntOpenHashMap \u26032 = new Object2IntOpenHashMap();
        for (Entity entity : iterable) {
            if (entity instanceof MobEntity && (((MobEntity)(\u2603 = (MobEntity)entity)).func_104002_bU() || ((MobEntity)\u2603).func_213392_I()) || (\u2603 = entity.func_200600_R().func_220339_d()) == EntityClassification.MISC) continue;
            BlockPos blockPos = entity.func_233580_cy_();
            long \u26033 = ChunkPos.func_77272_a(blockPos.func_177958_n() >> 4, blockPos.func_177952_p() >> 4);
            iInitialDensityAdder.query(\u26033, arg_0 -> WorldEntitySpawner.func_234971_a_(blockPos, entity, mobDensityTracker, \u26032, (EntityClassification)\u2603, arg_0));
        }
        return new EntityDensityManager(n, \u26032, mobDensityTracker);
    }

    private static Biome func_234980_b_(BlockPos blockPos, IChunk iChunk) {
        return DefaultBiomeMagnifier.INSTANCE.func_225532_a_(0L, blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p(), iChunk.func_225549_i_());
    }

    public static void func_234979_a_(ServerWorld serverWorld2, Chunk chunk, EntityDensityManager entityDensityManager, boolean bl, boolean bl2, boolean bl3) {
        ServerWorld serverWorld2;
        serverWorld2.func_217381_Z().func_76320_a("spawner");
        for (EntityClassification entityClassification : field_234961_c_) {
            if (!bl && entityClassification.func_75599_d() || !bl2 && !entityClassification.func_75599_d() || !bl3 && entityClassification.func_82705_e() || !entityDensityManager.func_234991_a_(entityClassification)) continue;
            WorldEntitySpawner.func_234967_a_(entityClassification, serverWorld2, chunk, (entityType, blockPos, iChunk) -> entityDensityManager.func_234989_a_(entityType, blockPos, iChunk), (mobEntity, iChunk) -> entityDensityManager.func_234990_a_(mobEntity, iChunk));
        }
        serverWorld2.func_217381_Z().func_76319_b();
    }

    public static void func_234967_a_(EntityClassification entityClassification, ServerWorld serverWorld, Chunk chunk, IDensityCheck iDensityCheck, IOnSpawnDensityAdder iOnSpawnDensityAdder) {
        BlockPos blockPos = WorldEntitySpawner.func_222262_a(serverWorld, chunk);
        if (blockPos.func_177956_o() < 1) {
            return;
        }
        WorldEntitySpawner.func_234966_a_(entityClassification, serverWorld, chunk, blockPos, iDensityCheck, iOnSpawnDensityAdder);
    }

    public static void func_234966_a_(EntityClassification entityClassification, ServerWorld serverWorld2, IChunk iChunk, BlockPos blockPos, IDensityCheck iDensityCheck, IOnSpawnDensityAdder iOnSpawnDensityAdder) {
        StructureManager structureManager = serverWorld2.func_241112_a_();
        ChunkGenerator \u26032 = serverWorld2.func_72863_F().func_201711_g();
        int \u26033 = blockPos.func_177956_o();
        BlockState \u26034 = iChunk.func_180495_p(blockPos);
        if (\u26034.func_215686_e(iChunk, blockPos)) {
            return;
        }
        BlockPos.Mutable \u26035 = new BlockPos.Mutable();
        int \u26036 = 0;
        block0: for (int i = 0; i < 3; ++i) {
            \u2603 = blockPos.func_177958_n();
            \u2603 = blockPos.func_177952_p();
            \u2603 = 6;
            MobSpawnInfo.Spawners spawners = null;
            ILivingEntityData \u26037 = null;
            int \u26038 = MathHelper.func_76123_f(serverWorld2.field_73012_v.nextFloat() * 4.0f);
            int \u26039 = 0;
            for (int j = 0; j < \u26038; ++j) {
                ServerWorld serverWorld2;
                \u26035.func_181079_c(\u2603 += serverWorld2.field_73012_v.nextInt(6) - serverWorld2.field_73012_v.nextInt(6), \u26033, \u2603 += serverWorld2.field_73012_v.nextInt(6) - serverWorld2.field_73012_v.nextInt(6));
                double d = (double)\u2603 + 0.5;
                \u2603 = (double)\u2603 + 0.5;
                PlayerEntity \u260310 = serverWorld2.func_217366_a(d, \u26033, \u2603, -1.0, false);
                if (\u260310 == null || !WorldEntitySpawner.func_234978_a_(serverWorld2, iChunk, \u26035, \u2603 = \u260310.func_70092_e(d, \u26033, \u2603))) continue;
                if (spawners == null) {
                    spawners = WorldEntitySpawner.func_234977_a_(serverWorld2, structureManager, \u26032, entityClassification, serverWorld2.field_73012_v, \u26035);
                    if (spawners == null) continue block0;
                    \u26038 = spawners.field_242589_d + serverWorld2.field_73012_v.nextInt(1 + spawners.field_242590_e - spawners.field_242589_d);
                }
                if (!WorldEntitySpawner.func_234975_a_(serverWorld2, entityClassification, structureManager, \u26032, spawners, \u26035, \u2603) || !iDensityCheck.test(spawners.field_242588_c, \u26035, iChunk)) continue;
                MobEntity \u260311 = WorldEntitySpawner.func_234973_a_(serverWorld2, spawners.field_242588_c);
                if (\u260311 == null) {
                    return;
                }
                \u260311.func_70012_b(d, \u26033, \u2603, serverWorld2.field_73012_v.nextFloat() * 360.0f, 0.0f);
                if (!WorldEntitySpawner.func_234974_a_(serverWorld2, \u260311, \u2603)) continue;
                \u26037 = \u260311.func_213386_a(serverWorld2, serverWorld2.func_175649_E(\u260311.func_233580_cy_()), SpawnReason.NATURAL, \u26037, null);
                ++\u26039;
                serverWorld2.func_242417_l(\u260311);
                iOnSpawnDensityAdder.run(\u260311, iChunk);
                if (++\u26036 >= \u260311.func_70641_bl()) {
                    return;
                }
                if (\u260311.func_204209_c(\u26039)) continue block0;
            }
        }
    }

    private static boolean func_234978_a_(ServerWorld serverWorld, IChunk iChunk, BlockPos.Mutable mutable, double d) {
        if (d <= 576.0) {
            return false;
        }
        if (serverWorld.func_241135_u_().func_218137_a(new Vector3d((double)mutable.func_177958_n() + 0.5, mutable.func_177956_o(), (double)mutable.func_177952_p() + 0.5), 24.0)) {
            return false;
        }
        ChunkPos chunkPos = new ChunkPos(mutable);
        return Objects.equals(chunkPos, iChunk.func_76632_l()) || serverWorld.func_72863_F().func_222865_a(chunkPos);
    }

    private static boolean func_234975_a_(ServerWorld serverWorld, EntityClassification entityClassification, StructureManager structureManager, ChunkGenerator chunkGenerator, MobSpawnInfo.Spawners spawners, BlockPos.Mutable mutable, double d) {
        EntityType<?> entityType = spawners.field_242588_c;
        if (entityType.func_220339_d() == EntityClassification.MISC) {
            return false;
        }
        if (!entityType.func_225437_d() && d > (double)(entityType.func_220339_d().func_233671_f_() * entityType.func_220339_d().func_233671_f_())) {
            return false;
        }
        if (!entityType.func_200720_b() || !WorldEntitySpawner.func_234976_a_(serverWorld, structureManager, chunkGenerator, entityClassification, spawners, mutable)) {
            return false;
        }
        EntitySpawnPlacementRegistry.PlacementType \u26032 = EntitySpawnPlacementRegistry.func_209344_a(entityType);
        if (!WorldEntitySpawner.func_209382_a(\u26032, serverWorld, mutable, entityType)) {
            return false;
        }
        if (!EntitySpawnPlacementRegistry.func_223515_a(entityType, serverWorld, SpawnReason.NATURAL, mutable, serverWorld.field_73012_v)) {
            return false;
        }
        return serverWorld.func_226664_a_(entityType.func_220328_a((double)mutable.func_177958_n() + 0.5, mutable.func_177956_o(), (double)mutable.func_177952_p() + 0.5));
    }

    @Nullable
    private static MobEntity func_234973_a_(ServerWorld serverWorld, EntityType<?> entityType) {
        MobEntity \u26032;
        try {
            Object obj = entityType.func_200721_a(serverWorld);
            if (!(obj instanceof MobEntity)) {
                throw new IllegalStateException("Trying to spawn a non-mob: " + Registry.field_212629_r.func_177774_c(entityType));
            }
            \u26032 = (MobEntity)obj;
        }
        catch (Exception exception) {
            field_209383_a.warn("Failed to create mob", (Throwable)exception);
            return null;
        }
        return \u26032;
    }

    private static boolean func_234974_a_(ServerWorld serverWorld, MobEntity mobEntity, double d) {
        if (d > (double)(mobEntity.func_200600_R().func_220339_d().func_233671_f_() * mobEntity.func_200600_R().func_220339_d().func_233671_f_()) && mobEntity.func_213397_c(d)) {
            return false;
        }
        return mobEntity.func_213380_a(serverWorld, SpawnReason.NATURAL) && mobEntity.func_205019_a(serverWorld);
    }

    @Nullable
    private static MobSpawnInfo.Spawners func_234977_a_(ServerWorld serverWorld, StructureManager structureManager, ChunkGenerator chunkGenerator, EntityClassification entityClassification, Random random, BlockPos blockPos) {
        Biome biome = serverWorld.func_226691_t_(blockPos);
        if (entityClassification == EntityClassification.WATER_AMBIENT && biome.func_201856_r() == Biome.Category.RIVER && random.nextFloat() < 0.98f) {
            return null;
        }
        List<MobSpawnInfo.Spawners> \u26032 = WorldEntitySpawner.func_241463_a_(serverWorld, structureManager, chunkGenerator, entityClassification, blockPos, biome);
        if (\u26032.isEmpty()) {
            return null;
        }
        return WeightedRandom.func_76271_a(random, \u26032);
    }

    private static boolean func_234976_a_(ServerWorld serverWorld, StructureManager structureManager, ChunkGenerator chunkGenerator, EntityClassification entityClassification, MobSpawnInfo.Spawners spawners, BlockPos blockPos) {
        return WorldEntitySpawner.func_241463_a_(serverWorld, structureManager, chunkGenerator, entityClassification, blockPos, null).contains(spawners);
    }

    private static List<MobSpawnInfo.Spawners> func_241463_a_(ServerWorld serverWorld, StructureManager structureManager, ChunkGenerator chunkGenerator, EntityClassification entityClassification, BlockPos blockPos, @Nullable Biome biome) {
        if (entityClassification == EntityClassification.MONSTER && serverWorld.func_180495_p(blockPos.func_177977_b()).func_177230_c() == Blocks.field_196653_dH && structureManager.func_235010_a_(blockPos, false, Structure.field_236378_n_).func_75069_d()) {
            return Structure.field_236378_n_.func_202279_e();
        }
        return chunkGenerator.func_230353_a_(biome != null ? biome : serverWorld.func_226691_t_(blockPos), structureManager, entityClassification, blockPos);
    }

    private static BlockPos func_222262_a(World world, Chunk chunk) {
        ChunkPos chunkPos = chunk.func_76632_l();
        int \u26032 = chunkPos.func_180334_c() + world.field_73012_v.nextInt(16);
        int \u26033 = chunkPos.func_180333_d() + world.field_73012_v.nextInt(16);
        int \u26034 = chunk.func_201576_a(Heightmap.Type.WORLD_SURFACE, \u26032, \u26033) + 1;
        int \u26035 = world.field_73012_v.nextInt(\u26034 + 1);
        return new BlockPos(\u26032, \u26035, \u26033);
    }

    public static boolean func_234968_a_(IBlockReader iBlockReader, BlockPos blockPos, BlockState blockState, FluidState fluidState, EntityType<?> entityType) {
        if (blockState.func_235785_r_(iBlockReader, blockPos)) {
            return false;
        }
        if (blockState.func_185897_m()) {
            return false;
        }
        if (!fluidState.func_206888_e()) {
            return false;
        }
        if (blockState.func_235714_a_(BlockTags.field_232884_az_)) {
            return false;
        }
        return !entityType.func_233597_a_(blockState);
    }

    public static boolean func_209382_a(EntitySpawnPlacementRegistry.PlacementType placementType, IWorldReader iWorldReader, BlockPos blockPos, @Nullable EntityType<?> entityType) {
        if (placementType == EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS) {
            return true;
        }
        if (entityType == null || !iWorldReader.func_175723_af().func_177746_a(blockPos)) {
            return false;
        }
        BlockState blockState = iWorldReader.func_180495_p(blockPos);
        FluidState \u26032 = iWorldReader.func_204610_c(blockPos);
        BlockPos \u26033 = blockPos.func_177984_a();
        BlockPos \u26034 = blockPos.func_177977_b();
        switch (placementType) {
            case IN_WATER: {
                return \u26032.func_206884_a(FluidTags.field_206959_a) && iWorldReader.func_204610_c(\u26034).func_206884_a(FluidTags.field_206959_a) && !iWorldReader.func_180495_p(\u26033).func_215686_e(iWorldReader, \u26033);
            }
            case IN_LAVA: {
                return \u26032.func_206884_a(FluidTags.field_206960_b);
            }
        }
        \u2603 = iWorldReader.func_180495_p(\u26034);
        if (!\u2603.func_215688_a(iWorldReader, \u26034, entityType)) {
            return false;
        }
        return WorldEntitySpawner.func_234968_a_(iWorldReader, blockPos, blockState, \u26032, entityType) && WorldEntitySpawner.func_234968_a_(iWorldReader, \u26033, iWorldReader.func_180495_p(\u26033), iWorldReader.func_204610_c(\u26033), entityType);
    }

    public static void func_77191_a(IServerWorld iServerWorld, Biome biome, int n, int n2, Random random2) {
        MobSpawnInfo mobSpawnInfo = biome.func_242433_b();
        List<MobSpawnInfo.Spawners> \u26032 = mobSpawnInfo.func_242559_a(EntityClassification.CREATURE);
        if (\u26032.isEmpty()) {
            return;
        }
        int \u26033 = n << 4;
        int \u26034 = n2 << 4;
        while (random2.nextFloat() < mobSpawnInfo.func_242557_a()) {
            MobSpawnInfo.Spawners spawners = WeightedRandom.func_76271_a(random2, \u26032);
            int \u26035 = spawners.field_242589_d + random2.nextInt(1 + spawners.field_242590_e - spawners.field_242589_d);
            ILivingEntityData \u26036 = null;
            int \u26037 = \u26033 + random2.nextInt(16);
            int \u26038 = \u26034 + random2.nextInt(16);
            int \u26039 = \u26037;
            int \u260310 = \u26038;
            for (int i = 0; i < \u26035; ++i) {
                boolean bl = false;
                for (int j = 0; !bl && j < 4; ++j) {
                    Random random2;
                    BlockPos blockPos = WorldEntitySpawner.func_208498_a(iServerWorld, spawners.field_242588_c, \u26037, \u26038);
                    if (spawners.field_242588_c.func_200720_b() && WorldEntitySpawner.func_209382_a(EntitySpawnPlacementRegistry.func_209344_a(spawners.field_242588_c), iServerWorld, blockPos, spawners.field_242588_c)) {
                        float f = spawners.field_242588_c.func_220333_h();
                        double \u260311 = MathHelper.func_151237_a(\u26037, (double)\u26033 + (double)f, (double)\u26033 + 16.0 - (double)f);
                        double \u260312 = MathHelper.func_151237_a(\u26038, (double)\u26034 + (double)f, (double)\u26034 + 16.0 - (double)f);
                        if (!iServerWorld.func_226664_a_(spawners.field_242588_c.func_220328_a(\u260311, blockPos.func_177956_o(), \u260312)) || !EntitySpawnPlacementRegistry.func_223515_a(spawners.field_242588_c, iServerWorld, SpawnReason.CHUNK_GENERATION, new BlockPos(\u260311, (double)blockPos.func_177956_o(), \u260312), iServerWorld.func_201674_k())) continue;
                        try {
                            Object obj = spawners.field_242588_c.func_200721_a(iServerWorld.func_201672_e());
                        }
                        catch (Exception exception) {
                            field_209383_a.warn("Failed to create mob", (Throwable)exception);
                            continue;
                        }
                        ((Entity)obj).func_70012_b(\u260311, blockPos.func_177956_o(), \u260312, random2.nextFloat() * 360.0f, 0.0f);
                        if (obj instanceof MobEntity && (\u2603 = (MobEntity)obj).func_213380_a(iServerWorld, SpawnReason.CHUNK_GENERATION) && \u2603.func_205019_a(iServerWorld)) {
                            \u26036 = \u2603.func_213386_a(iServerWorld, iServerWorld.func_175649_E(\u2603.func_233580_cy_()), SpawnReason.CHUNK_GENERATION, \u26036, null);
                            iServerWorld.func_242417_l(\u2603);
                            bl = true;
                        }
                    }
                    \u26037 += random2.nextInt(5) - random2.nextInt(5);
                    \u26038 += random2.nextInt(5) - random2.nextInt(5);
                    while (\u26037 < \u26033 || \u26037 >= \u26033 + 16 || \u26038 < \u26034 || \u26038 >= \u26034 + 16) {
                        \u26037 = \u26039 + random2.nextInt(5) - random2.nextInt(5);
                        \u26038 = \u260310 + random2.nextInt(5) - random2.nextInt(5);
                    }
                }
            }
        }
    }

    private static BlockPos func_208498_a(IWorldReader iWorldReader, EntityType<?> entityType, int n, int n2) {
        \u2603 = iWorldReader.func_201676_a(EntitySpawnPlacementRegistry.func_209342_b(entityType), n, n2);
        BlockPos.Mutable mutable = new BlockPos.Mutable(n, \u2603, n2);
        if (iWorldReader.func_230315_m_().func_236037_d_()) {
            do {
                mutable.func_189536_c(Direction.DOWN);
            } while (!iWorldReader.func_180495_p(mutable).func_196958_f());
            do {
                mutable.func_189536_c(Direction.DOWN);
            } while (iWorldReader.func_180495_p(mutable).func_196958_f() && mutable.func_177956_o() > 0);
        }
        if (EntitySpawnPlacementRegistry.func_209344_a(entityType) == EntitySpawnPlacementRegistry.PlacementType.ON_GROUND && iWorldReader.func_180495_p((BlockPos)(\u2603 = mutable.func_177977_b())).func_196957_g(iWorldReader, (BlockPos)\u2603, PathType.LAND)) {
            return \u2603;
        }
        return mutable.func_185334_h();
    }

    private static /* synthetic */ void func_234971_a_(BlockPos blockPos, Entity entity, MobDensityTracker mobDensityTracker, Object2IntOpenHashMap object2IntOpenHashMap, EntityClassification entityClassification, Chunk chunk) {
        MobSpawnInfo.SpawnCosts spawnCosts = WorldEntitySpawner.func_234980_b_(blockPos, chunk).func_242433_b().func_242558_a(entity.func_200600_R());
        if (spawnCosts != null) {
            mobDensityTracker.func_234998_a_(entity.func_233580_cy_(), spawnCosts.func_242585_b());
        }
        object2IntOpenHashMap.addTo((Object)entityClassification, 1);
    }

    @FunctionalInterface
    public static interface IInitialDensityAdder {
        public void query(long var1, Consumer<Chunk> var3);
    }

    @FunctionalInterface
    public static interface IOnSpawnDensityAdder {
        public void run(MobEntity var1, IChunk var2);
    }

    @FunctionalInterface
    public static interface IDensityCheck {
        public boolean test(EntityType<?> var1, BlockPos var2, IChunk var3);
    }

    public static class EntityDensityManager {
        private final int field_234981_a_;
        private final Object2IntOpenHashMap<EntityClassification> field_234982_b_;
        private final MobDensityTracker field_234983_c_;
        private final Object2IntMap<EntityClassification> field_234984_d_;
        @Nullable
        private BlockPos field_234985_e_;
        @Nullable
        private EntityType<?> field_234986_f_;
        private double field_234987_g_;

        private EntityDensityManager(int n, Object2IntOpenHashMap<EntityClassification> object2IntOpenHashMap, MobDensityTracker mobDensityTracker) {
            this.field_234981_a_ = n;
            this.field_234982_b_ = object2IntOpenHashMap;
            this.field_234983_c_ = mobDensityTracker;
            this.field_234984_d_ = Object2IntMaps.unmodifiable(object2IntOpenHashMap);
        }

        private boolean func_234989_a_(EntityType<?> entityType, BlockPos blockPos, IChunk iChunk) {
            this.field_234985_e_ = blockPos;
            this.field_234986_f_ = entityType;
            MobSpawnInfo.SpawnCosts spawnCosts = WorldEntitySpawner.func_234980_b_(blockPos, iChunk).func_242433_b().func_242558_a(entityType);
            if (spawnCosts == null) {
                this.field_234987_g_ = 0.0;
                return true;
            }
            this.field_234987_g_ = \u2603 = spawnCosts.func_242585_b();
            double \u26032 = this.field_234983_c_.func_234999_b_(blockPos, \u2603);
            return \u26032 <= spawnCosts.func_242582_a();
        }

        private void func_234990_a_(MobEntity mobEntity, IChunk iChunk) {
            EntityType<?> entityType = mobEntity.func_200600_R();
            BlockPos \u26032 = mobEntity.func_233580_cy_();
            double \u26033 = \u26032.equals(this.field_234985_e_) && entityType == this.field_234986_f_ ? this.field_234987_g_ : ((\u2603 = WorldEntitySpawner.func_234980_b_(\u26032, iChunk).func_242433_b().func_242558_a(entityType)) != null ? \u2603.func_242585_b() : 0.0);
            this.field_234983_c_.func_234998_a_(\u26032, \u26033);
            this.field_234982_b_.addTo((Object)entityType.func_220339_d(), 1);
        }

        public int func_234988_a_() {
            return this.field_234981_a_;
        }

        public Object2IntMap<EntityClassification> func_234995_b_() {
            return this.field_234984_d_;
        }

        private boolean func_234991_a_(EntityClassification entityClassification) {
            int n = entityClassification.func_75601_b() * this.field_234981_a_ / field_234960_b_;
            return this.field_234982_b_.getInt((Object)entityClassification) < n;
        }
    }
}

