/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.village;

import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.ISpecialSpawner;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VillageSiege
implements ISpecialSpawner {
    private static final Logger field_242320_a = LogManager.getLogger();
    private boolean field_75535_b;
    private State field_75536_c = State.SIEGE_DONE;
    private int field_75533_d;
    private int field_75534_e;
    private int field_75532_g;
    private int field_75538_h;
    private int field_75539_i;

    @Override
    public int func_230253_a_(ServerWorld serverWorld, boolean bl, boolean bl2) {
        if (serverWorld.func_72935_r() || !bl) {
            this.field_75536_c = State.SIEGE_DONE;
            this.field_75535_b = false;
            return 0;
        }
        float f = serverWorld.func_242415_f(0.0f);
        if ((double)f == 0.5) {
            State state = this.field_75536_c = serverWorld.field_73012_v.nextInt(10) == 0 ? State.SIEGE_TONIGHT : State.SIEGE_DONE;
        }
        if (this.field_75536_c == State.SIEGE_DONE) {
            return 0;
        }
        if (!this.field_75535_b) {
            if (this.func_75529_b(serverWorld)) {
                this.field_75535_b = true;
            } else {
                return 0;
            }
        }
        if (this.field_75534_e > 0) {
            --this.field_75534_e;
            return 0;
        }
        this.field_75534_e = 2;
        if (this.field_75533_d > 0) {
            this.func_75530_c(serverWorld);
            --this.field_75533_d;
        } else {
            this.field_75536_c = State.SIEGE_DONE;
        }
        return 1;
    }

    private boolean func_75529_b(ServerWorld serverWorld) {
        for (PlayerEntity playerEntity : serverWorld.func_217369_A()) {
            BlockPos blockPos;
            if (playerEntity.func_175149_v() || !serverWorld.func_217483_b_(blockPos = playerEntity.func_233580_cy_()) || serverWorld.func_226691_t_(blockPos).func_201856_r() == Biome.Category.MUSHROOM) continue;
            for (int i = 0; i < 10; ++i) {
                float f = serverWorld.field_73012_v.nextFloat() * ((float)Math.PI * 2);
                this.field_75532_g = blockPos.func_177958_n() + MathHelper.func_76141_d(MathHelper.func_76134_b(f) * 32.0f);
                this.field_75538_h = blockPos.func_177956_o();
                this.field_75539_i = blockPos.func_177952_p() + MathHelper.func_76141_d(MathHelper.func_76126_a(f) * 32.0f);
                if (this.func_225476_a(serverWorld, new BlockPos(this.field_75532_g, this.field_75538_h, this.field_75539_i)) == null) continue;
                this.field_75534_e = 0;
                this.field_75533_d = 20;
                break;
            }
            return true;
        }
        return false;
    }

    private void func_75530_c(ServerWorld serverWorld) {
        Vector3d vector3d = this.func_225476_a(serverWorld, new BlockPos(this.field_75532_g, this.field_75538_h, this.field_75539_i));
        if (vector3d == null) {
            return;
        }
        try {
            ZombieEntity zombieEntity = new ZombieEntity(serverWorld);
            zombieEntity.func_213386_a(serverWorld, serverWorld.func_175649_E(zombieEntity.func_233580_cy_()), SpawnReason.EVENT, null, null);
        }
        catch (Exception exception) {
            field_242320_a.warn("Failed to create zombie for village siege at {}", (Object)vector3d, (Object)exception);
            return;
        }
        zombieEntity.func_70012_b(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c, serverWorld.field_73012_v.nextFloat() * 360.0f, 0.0f);
        serverWorld.func_242417_l(zombieEntity);
    }

    @Nullable
    private Vector3d func_225476_a(ServerWorld serverWorld, BlockPos blockPos) {
        for (int i = 0; i < 10; ++i) {
            \u2603 = blockPos.func_177958_n() + serverWorld.field_73012_v.nextInt(16) - 8;
            BlockPos blockPos2 = new BlockPos(\u2603, \u2603 = serverWorld.func_201676_a(Heightmap.Type.WORLD_SURFACE, \u2603, \u2603 = blockPos.func_177952_p() + serverWorld.field_73012_v.nextInt(16) - 8), \u2603);
            if (!serverWorld.func_217483_b_(blockPos2) || !MonsterEntity.func_223325_c(EntityType.field_200725_aD, serverWorld, SpawnReason.EVENT, blockPos2, serverWorld.field_73012_v)) continue;
            return Vector3d.func_237492_c_(blockPos2);
        }
        return null;
    }

    static enum State {
        SIEGE_CAN_ACTIVATE,
        SIEGE_TONIGHT,
        SIEGE_DONE;

    }
}

