/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.registry;

import com.google.common.collect.Maps;
import com.mojang.serialization.Lifecycle;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.SimpleRegistry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeRegistry;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.carver.ConfiguredCarvers;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPatternRegistry;
import net.minecraft.world.gen.feature.structure.StructureFeatures;
import net.minecraft.world.gen.feature.template.ProcessorLists;
import net.minecraft.world.gen.feature.template.StructureProcessorList;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilders;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorldGenRegistries {
    protected static final Logger field_243649_a = LogManager.getLogger();
    private static final Map<ResourceLocation, Supplier<?>> field_243659_k = Maps.newLinkedHashMap();
    private static final MutableRegistry<MutableRegistry<?>> field_243660_l = new SimpleRegistry(RegistryKey.func_240904_a_(new ResourceLocation("root")), Lifecycle.experimental());
    public static final Registry<? extends Registry<?>> field_243650_b = field_243660_l;
    public static final Registry<ConfiguredSurfaceBuilder<?>> field_243651_c = WorldGenRegistries.func_243667_a(Registry.field_243550_as, () -> ConfiguredSurfaceBuilders.field_244184_p);
    public static final Registry<ConfiguredCarver<?>> field_243652_d = WorldGenRegistries.func_243667_a(Registry.field_243551_at, () -> ConfiguredCarvers.field_243767_a);
    public static final Registry<ConfiguredFeature<?, ?>> field_243653_e = WorldGenRegistries.func_243667_a(Registry.field_243552_au, () -> Features.field_243862_bH);
    public static final Registry<StructureFeature<?, ?>> field_243654_f = WorldGenRegistries.func_243667_a(Registry.field_243553_av, () -> StructureFeatures.field_244136_b);
    public static final Registry<StructureProcessorList> field_243655_g = WorldGenRegistries.func_243667_a(Registry.field_243554_aw, () -> ProcessorLists.field_244102_b);
    public static final Registry<JigsawPattern> field_243656_h = WorldGenRegistries.func_243667_a(Registry.field_243555_ax, JigsawPatternRegistry::func_244093_a);
    public static final Registry<Biome> field_243657_i = WorldGenRegistries.func_243667_a(Registry.field_239720_u_, () -> BiomeRegistry.field_244200_a);
    public static final Registry<DimensionSettings> field_243658_j = WorldGenRegistries.func_243667_a(Registry.field_243549_ar, DimensionSettings::func_242746_i);

    private static <T> Registry<T> func_243667_a(RegistryKey<? extends Registry<T>> registryKey, Supplier<T> supplier) {
        return WorldGenRegistries.func_243665_a(registryKey, Lifecycle.stable(), supplier);
    }

    private static <T> Registry<T> func_243665_a(RegistryKey<? extends Registry<T>> registryKey, Lifecycle lifecycle, Supplier<T> supplier) {
        return WorldGenRegistries.func_243666_a(registryKey, new SimpleRegistry(registryKey, lifecycle), supplier, lifecycle);
    }

    private static <T, R extends MutableRegistry<T>> R func_243666_a(RegistryKey<? extends Registry<T>> registryKey, R r, Supplier<T> supplier, Lifecycle lifecycle) {
        ResourceLocation resourceLocation = registryKey.func_240901_a_();
        field_243659_k.put(resourceLocation, supplier);
        MutableRegistry<MutableRegistry<?>> \u26032 = field_243660_l;
        return \u26032.func_218381_a(registryKey, r, lifecycle);
    }

    public static <T> T func_243663_a(Registry<? super T> registry, String string, T t) {
        return WorldGenRegistries.func_243664_a(registry, new ResourceLocation(string), t);
    }

    public static <V, T extends V> T func_243664_a(Registry<V> registry, ResourceLocation resourceLocation, T t) {
        return ((MutableRegistry)registry).func_218381_a(RegistryKey.func_240903_a_(registry.func_243578_f(), resourceLocation), t, Lifecycle.stable());
    }

    public static <V, T extends V> T func_243662_a(Registry<V> registry, int n, RegistryKey<V> registryKey, T t) {
        return ((MutableRegistry)registry).func_218382_a(n, registryKey, t, Lifecycle.stable());
    }

    public static void func_243661_a() {
    }

    static {
        field_243659_k.forEach((resourceLocation, supplier) -> {
            if (supplier.get() == null) {
                field_243649_a.error("Unable to bootstrap registry '{}'", resourceLocation);
            }
        });
        Registry.func_239738_a_(field_243660_l);
    }
}

