/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.registry;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.UnboundedMapCodec;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.SimpleRegistry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.util.registry.WorldSettingsImport;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class DynamicRegistries {
    private static final Logger field_243598_a = LogManager.getLogger();
    private static final Map<RegistryKey<? extends Registry<?>>, CodecHolder<?>> field_243599_b = (Map)Util.func_199748_a(() -> {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        DynamicRegistries.func_243602_a(builder, Registry.field_239698_ad_, DimensionType.field_235997_a_, DimensionType.field_235997_a_);
        DynamicRegistries.func_243602_a(builder, Registry.field_239720_u_, Biome.field_242418_b, Biome.field_242419_c);
        DynamicRegistries.func_243601_a(builder, Registry.field_243550_as, ConfiguredSurfaceBuilder.field_237168_a_);
        DynamicRegistries.func_243601_a(builder, Registry.field_243551_at, ConfiguredCarver.field_236235_a_);
        DynamicRegistries.func_243601_a(builder, Registry.field_243552_au, ConfiguredFeature.field_242763_a);
        DynamicRegistries.func_243601_a(builder, Registry.field_243553_av, StructureFeature.field_236267_a_);
        DynamicRegistries.func_243601_a(builder, Registry.field_243554_aw, IStructureProcessorType.field_242921_l);
        DynamicRegistries.func_243601_a(builder, Registry.field_243555_ax, JigsawPattern.field_236852_a_);
        DynamicRegistries.func_243601_a(builder, Registry.field_243549_ar, DimensionSettings.field_236097_a_);
        return builder.build();
    });
    private static final Impl field_243600_c = Util.func_199748_a(() -> {
        Impl impl = new Impl();
        DimensionType.func_236027_a_(impl);
        field_243599_b.keySet().stream().filter(registryKey -> !registryKey.equals(Registry.field_239698_ad_)).forEach(registryKey -> DynamicRegistries.func_243609_a(impl, registryKey));
        return impl;
    });

    public abstract <E> Optional<MutableRegistry<E>> func_230521_a_(RegistryKey<? extends Registry<E>> var1);

    public <E> MutableRegistry<E> func_243612_b(RegistryKey<? extends Registry<E>> registryKey) {
        return this.func_230521_a_(registryKey).orElseThrow(() -> new IllegalStateException("Missing registry: " + registryKey));
    }

    public Registry<DimensionType> func_230520_a_() {
        return this.func_243612_b(Registry.field_239698_ad_);
    }

    private static <E> void func_243601_a(ImmutableMap.Builder<RegistryKey<? extends Registry<?>>, CodecHolder<?>> builder, RegistryKey<? extends Registry<E>> registryKey, Codec<E> codec) {
        builder.put(registryKey, new CodecHolder<E>(registryKey, codec, null));
    }

    private static <E> void func_243602_a(ImmutableMap.Builder<RegistryKey<? extends Registry<?>>, CodecHolder<?>> builder, RegistryKey<? extends Registry<E>> registryKey, Codec<E> codec, Codec<E> codec2) {
        builder.put(registryKey, new CodecHolder<E>(registryKey, codec, codec2));
    }

    public static Impl func_239770_b_() {
        Impl impl = new Impl();
        WorldSettingsImport.IResourceAccess.RegistryAccess \u26032 = new WorldSettingsImport.IResourceAccess.RegistryAccess();
        for (CodecHolder<?> codecHolder : field_243599_b.values()) {
            DynamicRegistries.func_243607_a(impl, \u26032, codecHolder);
        }
        WorldSettingsImport.func_244336_a(JsonOps.INSTANCE, \u26032, impl);
        return impl;
    }

    private static <E> void func_243607_a(Impl impl, WorldSettingsImport.IResourceAccess.RegistryAccess registryAccess, CodecHolder<E> codecHolder) {
        RegistryKey<Registry<E>> registryKey = codecHolder.func_243622_a();
        boolean \u26032 = !registryKey.equals(Registry.field_243549_ar) && !registryKey.equals(Registry.field_239698_ad_);
        MutableRegistry<E> \u26033 = field_243600_c.func_243612_b(registryKey);
        MutableRegistry<E> \u26034 = impl.func_243612_b(registryKey);
        for (Map.Entry entry : \u26033.func_239659_c_()) {
            Object t = entry.getValue();
            if (\u26032) {
                registryAccess.func_244352_a(field_243600_c, entry.getKey(), codecHolder.func_243623_b(), \u26033.func_148757_b(t), t, \u26033.func_241876_d(t));
                continue;
            }
            \u26034.func_218382_a(\u26033.func_148757_b(t), entry.getKey(), t, \u26033.func_241876_d(t));
        }
    }

    private static <R extends Registry<?>> void func_243609_a(Impl impl, RegistryKey<R> registryKey) {
        Registry<Registry<?>> registry = WorldGenRegistries.field_243650_b;
        Registry<?> \u26032 = registry.func_230516_a_(registryKey);
        if (\u26032 == null) {
            throw new IllegalStateException("Missing builtin registry: " + registryKey);
        }
        DynamicRegistries.func_243606_a(impl, \u26032);
    }

    private static <E> void func_243606_a(Impl impl, Registry<E> registry) {
        MutableRegistry<E> mutableRegistry = impl.func_230521_a_(registry.func_243578_f()).orElseThrow(() -> new IllegalStateException("Missing registry: " + registry.func_243578_f()));
        for (Map.Entry<RegistryKey<E>, E> entry : registry.func_239659_c_()) {
            E e = entry.getValue();
            mutableRegistry.func_218382_a(registry.func_148757_b(e), entry.getKey(), e, registry.func_241876_d(e));
        }
    }

    public static void func_243608_a(Impl impl, WorldSettingsImport<?> worldSettingsImport) {
        for (CodecHolder<?> codecHolder : field_243599_b.values()) {
            DynamicRegistries.func_243610_a(worldSettingsImport, impl, codecHolder);
        }
    }

    private static <E> void func_243610_a(WorldSettingsImport<?> worldSettingsImport, Impl impl, CodecHolder<E> codecHolder) {
        RegistryKey registryKey = codecHolder.func_243622_a();
        SimpleRegistry \u26032 = Optional.ofNullable(impl.field_243627_b.get(registryKey)).map(simpleRegistry -> simpleRegistry).orElseThrow(() -> new IllegalStateException("Missing registry: " + registryKey));
        DataResult<SimpleRegistry<E>> \u26033 = worldSettingsImport.func_241797_a_(\u26032, codecHolder.func_243622_a(), codecHolder.func_243623_b());
        \u26033.error().ifPresent(partialResult -> field_243598_a.error("Error loading registry data: {}", (Object)partialResult.message()));
    }

    public static final class Impl
    extends DynamicRegistries {
        public static final Codec<Impl> field_243626_a = Impl.func_243637_d();
        private final Map<? extends RegistryKey<? extends Registry<?>>, ? extends SimpleRegistry<?>> field_243627_b;

        private static <E> Codec<Impl> func_243637_d() {
            Codec codec = ResourceLocation.field_240908_a_.xmap(RegistryKey::func_240904_a_, RegistryKey::func_240901_a_);
            \u2603 = codec.partialDispatch("type", simpleRegistry -> DataResult.success(simpleRegistry.func_243578_f()), registryKey -> Impl.func_243636_c(registryKey).map(codec -> SimpleRegistry.func_243539_a(registryKey, Lifecycle.experimental(), codec)));
            UnboundedMapCodec \u26032 = Codec.unboundedMap((Codec)codec, (Codec)\u2603);
            return Impl.func_243628_a(\u26032);
        }

        private static <K extends RegistryKey<? extends Registry<?>>, V extends SimpleRegistry<?>> Codec<Impl> func_243628_a(UnboundedMapCodec<K, V> unboundedMapCodec) {
            return unboundedMapCodec.xmap(Impl::new, impl -> (ImmutableMap)impl.field_243627_b.entrySet().stream().filter(entry -> ((CodecHolder)field_243599_b.get(entry.getKey())).func_243625_d()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue)));
        }

        private static <E> DataResult<? extends Codec<E>> func_243636_c(RegistryKey<? extends Registry<E>> registryKey) {
            return Optional.ofNullable(field_243599_b.get(registryKey)).map(codecHolder -> codecHolder.func_243624_c()).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown or not serializable registry: " + registryKey)));
        }

        public Impl() {
            this(field_243599_b.keySet().stream().collect(Collectors.toMap(Function.identity(), Impl::func_243638_d)));
        }

        private Impl(Map<? extends RegistryKey<? extends Registry<?>>, ? extends SimpleRegistry<?>> map) {
            this.field_243627_b = map;
        }

        private static <E> SimpleRegistry<?> func_243638_d(RegistryKey<? extends Registry<?>> registryKey) {
            return new SimpleRegistry(registryKey, Lifecycle.stable());
        }

        @Override
        public <E> Optional<MutableRegistry<E>> func_230521_a_(RegistryKey<? extends Registry<E>> registryKey) {
            return Optional.ofNullable(this.field_243627_b.get(registryKey)).map(simpleRegistry -> simpleRegistry);
        }
    }

    static final class CodecHolder<E> {
        private final RegistryKey<? extends Registry<E>> field_243619_a;
        private final Codec<E> field_243620_b;
        @Nullable
        private final Codec<E> field_243621_c;

        public CodecHolder(RegistryKey<? extends Registry<E>> registryKey, Codec<E> codec, @Nullable Codec<E> codec2) {
            this.field_243619_a = registryKey;
            this.field_243620_b = codec;
            this.field_243621_c = codec2;
        }

        public RegistryKey<? extends Registry<E>> func_243622_a() {
            return this.field_243619_a;
        }

        public Codec<E> func_243623_b() {
            return this.field_243620_b;
        }

        @Nullable
        public Codec<E> func_243624_c() {
            return this.field_243621_c;
        }

        public boolean func_243625_d() {
            return this.field_243621_c != null;
        }
    }
}

