/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.ArbitraryBitLengthIntArray;
import net.minecraft.util.IntIdentityHashBiMap;
import net.minecraft.util.datafix.TypeReferences;
import net.minecraft.util.datafix.fixes.BlockStateFlatteningMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChunkPaletteFormat
extends DataFix {
    private static final Logger field_199145_a = LogManager.getLogger();
    private static final BitSet field_199146_b = new BitSet(256);
    private static final BitSet field_199147_c = new BitSet(256);
    private static final Dynamic<?> field_199148_d = BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:pumpkin'}");
    private static final Dynamic<?> field_199149_e = BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:podzol',Properties:{snowy:'true'}}");
    private static final Dynamic<?> field_199150_f = BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:grass_block',Properties:{snowy:'true'}}");
    private static final Dynamic<?> field_199151_g = BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:mycelium',Properties:{snowy:'true'}}");
    private static final Dynamic<?> field_199152_h = BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:sunflower',Properties:{half:'upper'}}");
    private static final Dynamic<?> field_199153_i = BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:lilac',Properties:{half:'upper'}}");
    private static final Dynamic<?> field_199154_j = BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:tall_grass',Properties:{half:'upper'}}");
    private static final Dynamic<?> field_199155_k = BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:large_fern',Properties:{half:'upper'}}");
    private static final Dynamic<?> field_199156_l = BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:rose_bush',Properties:{half:'upper'}}");
    private static final Dynamic<?> field_199157_m = BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:peony',Properties:{half:'upper'}}");
    private static final Map<String, Dynamic<?>> field_199158_n = (Map)DataFixUtils.make((Object)Maps.newHashMap(), hashMap -> {
        hashMap.put("minecraft:air0", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:flower_pot'}"));
        hashMap.put("minecraft:red_flower0", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:potted_poppy'}"));
        hashMap.put("minecraft:red_flower1", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:potted_blue_orchid'}"));
        hashMap.put("minecraft:red_flower2", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:potted_allium'}"));
        hashMap.put("minecraft:red_flower3", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:potted_azure_bluet'}"));
        hashMap.put("minecraft:red_flower4", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:potted_red_tulip'}"));
        hashMap.put("minecraft:red_flower5", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:potted_orange_tulip'}"));
        hashMap.put("minecraft:red_flower6", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:potted_white_tulip'}"));
        hashMap.put("minecraft:red_flower7", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:potted_pink_tulip'}"));
        hashMap.put("minecraft:red_flower8", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:potted_oxeye_daisy'}"));
        hashMap.put("minecraft:yellow_flower0", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:potted_dandelion'}"));
        hashMap.put("minecraft:sapling0", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:potted_oak_sapling'}"));
        hashMap.put("minecraft:sapling1", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:potted_spruce_sapling'}"));
        hashMap.put("minecraft:sapling2", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:potted_birch_sapling'}"));
        hashMap.put("minecraft:sapling3", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:potted_jungle_sapling'}"));
        hashMap.put("minecraft:sapling4", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:potted_acacia_sapling'}"));
        hashMap.put("minecraft:sapling5", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:potted_dark_oak_sapling'}"));
        hashMap.put("minecraft:red_mushroom0", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:potted_red_mushroom'}"));
        hashMap.put("minecraft:brown_mushroom0", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:potted_brown_mushroom'}"));
        hashMap.put("minecraft:deadbush0", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:potted_dead_bush'}"));
        hashMap.put("minecraft:tallgrass2", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:potted_fern'}"));
        hashMap.put("minecraft:cactus0", BlockStateFlatteningMap.func_210049_b(2240));
    });
    private static final Map<String, Dynamic<?>> field_199159_o = (Map)DataFixUtils.make((Object)Maps.newHashMap(), hashMap -> {
        ChunkPaletteFormat.func_209300_a(hashMap, 0, "skeleton", "skull");
        ChunkPaletteFormat.func_209300_a(hashMap, 1, "wither_skeleton", "skull");
        ChunkPaletteFormat.func_209300_a(hashMap, 2, "zombie", "head");
        ChunkPaletteFormat.func_209300_a(hashMap, 3, "player", "head");
        ChunkPaletteFormat.func_209300_a(hashMap, 4, "creeper", "head");
        ChunkPaletteFormat.func_209300_a(hashMap, 5, "dragon", "head");
    });
    private static final Map<String, Dynamic<?>> field_199160_p = (Map)DataFixUtils.make((Object)Maps.newHashMap(), hashMap -> {
        ChunkPaletteFormat.func_209301_a(hashMap, "oak_door", 1024);
        ChunkPaletteFormat.func_209301_a(hashMap, "iron_door", 1136);
        ChunkPaletteFormat.func_209301_a(hashMap, "spruce_door", 3088);
        ChunkPaletteFormat.func_209301_a(hashMap, "birch_door", 3104);
        ChunkPaletteFormat.func_209301_a(hashMap, "jungle_door", 3120);
        ChunkPaletteFormat.func_209301_a(hashMap, "acacia_door", 3136);
        ChunkPaletteFormat.func_209301_a(hashMap, "dark_oak_door", 3152);
    });
    private static final Map<String, Dynamic<?>> field_199161_q = (Map)DataFixUtils.make((Object)Maps.newHashMap(), hashMap -> {
        for (int i = 0; i < 26; ++i) {
            hashMap.put("true" + i, BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:note_block',Properties:{powered:'true',note:'" + i + "'}}"));
            hashMap.put("false" + i, BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:note_block',Properties:{powered:'false',note:'" + i + "'}}"));
        }
    });
    private static final Int2ObjectMap<String> field_199162_r = (Int2ObjectMap)DataFixUtils.make((Object)new Int2ObjectOpenHashMap(), int2ObjectOpenHashMap -> {
        int2ObjectOpenHashMap.put(0, (Object)"white");
        int2ObjectOpenHashMap.put(1, (Object)"orange");
        int2ObjectOpenHashMap.put(2, (Object)"magenta");
        int2ObjectOpenHashMap.put(3, (Object)"light_blue");
        int2ObjectOpenHashMap.put(4, (Object)"yellow");
        int2ObjectOpenHashMap.put(5, (Object)"lime");
        int2ObjectOpenHashMap.put(6, (Object)"pink");
        int2ObjectOpenHashMap.put(7, (Object)"gray");
        int2ObjectOpenHashMap.put(8, (Object)"light_gray");
        int2ObjectOpenHashMap.put(9, (Object)"cyan");
        int2ObjectOpenHashMap.put(10, (Object)"purple");
        int2ObjectOpenHashMap.put(11, (Object)"blue");
        int2ObjectOpenHashMap.put(12, (Object)"brown");
        int2ObjectOpenHashMap.put(13, (Object)"green");
        int2ObjectOpenHashMap.put(14, (Object)"red");
        int2ObjectOpenHashMap.put(15, (Object)"black");
    });
    private static final Map<String, Dynamic<?>> field_199163_s = (Map)DataFixUtils.make((Object)Maps.newHashMap(), hashMap -> {
        for (Int2ObjectMap.Entry entry : field_199162_r.int2ObjectEntrySet()) {
            if (Objects.equals(entry.getValue(), "red")) continue;
            ChunkPaletteFormat.func_209307_a(hashMap, entry.getIntKey(), (String)entry.getValue());
        }
    });
    private static final Map<String, Dynamic<?>> field_199164_t = (Map)DataFixUtils.make((Object)Maps.newHashMap(), hashMap -> {
        for (Int2ObjectMap.Entry entry : field_199162_r.int2ObjectEntrySet()) {
            if (Objects.equals(entry.getValue(), "white")) continue;
            ChunkPaletteFormat.func_209297_b(hashMap, 15 - entry.getIntKey(), (String)entry.getValue());
        }
    });
    private static final Dynamic<?> field_199165_u;

    public ChunkPaletteFormat(Schema schema, boolean bl) {
        super(schema, bl);
    }

    private static void func_209300_a(Map<String, Dynamic<?>> map, int n, String string, String string2) {
        map.put(n + "north", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "_wall_" + string2 + "',Properties:{facing:'north'}}"));
        map.put(n + "east", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "_wall_" + string2 + "',Properties:{facing:'east'}}"));
        map.put(n + "south", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "_wall_" + string2 + "',Properties:{facing:'south'}}"));
        map.put(n + "west", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "_wall_" + string2 + "',Properties:{facing:'west'}}"));
        for (int i = 0; i < 16; ++i) {
            map.put(n + "" + i, BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "_" + string2 + "',Properties:{rotation:'" + i + "'}}"));
        }
    }

    private static void func_209301_a(Map<String, Dynamic<?>> map, String string, int n) {
        map.put("minecraft:" + string + "eastlowerleftfalsefalse", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "',Properties:{facing:'east',half:'lower',hinge:'left',open:'false',powered:'false'}}"));
        map.put("minecraft:" + string + "eastlowerleftfalsetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "',Properties:{facing:'east',half:'lower',hinge:'left',open:'false',powered:'true'}}"));
        map.put("minecraft:" + string + "eastlowerlefttruefalse", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "',Properties:{facing:'east',half:'lower',hinge:'left',open:'true',powered:'false'}}"));
        map.put("minecraft:" + string + "eastlowerlefttruetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "',Properties:{facing:'east',half:'lower',hinge:'left',open:'true',powered:'true'}}"));
        map.put("minecraft:" + string + "eastlowerrightfalsefalse", BlockStateFlatteningMap.func_210049_b(n));
        map.put("minecraft:" + string + "eastlowerrightfalsetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "',Properties:{facing:'east',half:'lower',hinge:'right',open:'false',powered:'true'}}"));
        map.put("minecraft:" + string + "eastlowerrighttruefalse", BlockStateFlatteningMap.func_210049_b(n + 4));
        map.put("minecraft:" + string + "eastlowerrighttruetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "',Properties:{facing:'east',half:'lower',hinge:'right',open:'true',powered:'true'}}"));
        map.put("minecraft:" + string + "eastupperleftfalsefalse", BlockStateFlatteningMap.func_210049_b(n + 8));
        map.put("minecraft:" + string + "eastupperleftfalsetrue", BlockStateFlatteningMap.func_210049_b(n + 10));
        map.put("minecraft:" + string + "eastupperlefttruefalse", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "',Properties:{facing:'east',half:'upper',hinge:'left',open:'true',powered:'false'}}"));
        map.put("minecraft:" + string + "eastupperlefttruetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "',Properties:{facing:'east',half:'upper',hinge:'left',open:'true',powered:'true'}}"));
        map.put("minecraft:" + string + "eastupperrightfalsefalse", BlockStateFlatteningMap.func_210049_b(n + 9));
        map.put("minecraft:" + string + "eastupperrightfalsetrue", BlockStateFlatteningMap.func_210049_b(n + 11));
        map.put("minecraft:" + string + "eastupperrighttruefalse", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "',Properties:{facing:'east',half:'upper',hinge:'right',open:'true',powered:'false'}}"));
        map.put("minecraft:" + string + "eastupperrighttruetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "',Properties:{facing:'east',half:'upper',hinge:'right',open:'true',powered:'true'}}"));
        map.put("minecraft:" + string + "northlowerleftfalsefalse", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "',Properties:{facing:'north',half:'lower',hinge:'left',open:'false',powered:'false'}}"));
        map.put("minecraft:" + string + "northlowerleftfalsetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "',Properties:{facing:'north',half:'lower',hinge:'left',open:'false',powered:'true'}}"));
        map.put("minecraft:" + string + "northlowerlefttruefalse", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "',Properties:{facing:'north',half:'lower',hinge:'left',open:'true',powered:'false'}}"));
        map.put("minecraft:" + string + "northlowerlefttruetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "',Properties:{facing:'north',half:'lower',hinge:'left',open:'true',powered:'true'}}"));
        map.put("minecraft:" + string + "northlowerrightfalsefalse", BlockStateFlatteningMap.func_210049_b(n + 3));
        map.put("minecraft:" + string + "northlowerrightfalsetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "',Properties:{facing:'north',half:'lower',hinge:'right',open:'false',powered:'true'}}"));
        map.put("minecraft:" + string + "northlowerrighttruefalse", BlockStateFlatteningMap.func_210049_b(n + 7));
        map.put("minecraft:" + string + "northlowerrighttruetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "',Properties:{facing:'north',half:'lower',hinge:'right',open:'true',powered:'true'}}"));
        map.put("minecraft:" + string + "northupperleftfalsefalse", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "',Properties:{facing:'north',half:'upper',hinge:'left',open:'false',powered:'false'}}"));
        map.put("minecraft:" + string + "northupperleftfalsetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "',Properties:{facing:'north',half:'upper',hinge:'left',open:'false',powered:'true'}}"));
        map.put("minecraft:" + string + "northupperlefttruefalse", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "',Properties:{facing:'north',half:'upper',hinge:'left',open:'true',powered:'false'}}"));
        map.put("minecraft:" + string + "northupperlefttruetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "',Properties:{facing:'north',half:'upper',hinge:'left',open:'true',powered:'true'}}"));
        map.put("minecraft:" + string + "northupperrightfalsefalse", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "',Properties:{facing:'north',half:'upper',hinge:'right',open:'false',powered:'false'}}"));
        map.put("minecraft:" + string + "northupperrightfalsetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "',Properties:{facing:'north',half:'upper',hinge:'right',open:'false',powered:'true'}}"));
        map.put("minecraft:" + string + "northupperrighttruefalse", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "',Properties:{facing:'north',half:'upper',hinge:'right',open:'true',powered:'false'}}"));
        map.put("minecraft:" + string + "northupperrighttruetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "',Properties:{facing:'north',half:'upper',hinge:'right',open:'true',powered:'true'}}"));
        map.put("minecraft:" + string + "southlowerleftfalsefalse", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "',Properties:{facing:'south',half:'lower',hinge:'left',open:'false',powered:'false'}}"));
        map.put("minecraft:" + string + "southlowerleftfalsetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "',Properties:{facing:'south',half:'lower',hinge:'left',open:'false',powered:'true'}}"));
        map.put("minecraft:" + string + "southlowerlefttruefalse", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "',Properties:{facing:'south',half:'lower',hinge:'left',open:'true',powered:'false'}}"));
        map.put("minecraft:" + string + "southlowerlefttruetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "',Properties:{facing:'south',half:'lower',hinge:'left',open:'true',powered:'true'}}"));
        map.put("minecraft:" + string + "southlowerrightfalsefalse", BlockStateFlatteningMap.func_210049_b(n + 1));
        map.put("minecraft:" + string + "southlowerrightfalsetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "',Properties:{facing:'south',half:'lower',hinge:'right',open:'false',powered:'true'}}"));
        map.put("minecraft:" + string + "southlowerrighttruefalse", BlockStateFlatteningMap.func_210049_b(n + 5));
        map.put("minecraft:" + string + "southlowerrighttruetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "',Properties:{facing:'south',half:'lower',hinge:'right',open:'true',powered:'true'}}"));
        map.put("minecraft:" + string + "southupperleftfalsefalse", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "',Properties:{facing:'south',half:'upper',hinge:'left',open:'false',powered:'false'}}"));
        map.put("minecraft:" + string + "southupperleftfalsetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "',Properties:{facing:'south',half:'upper',hinge:'left',open:'false',powered:'true'}}"));
        map.put("minecraft:" + string + "southupperlefttruefalse", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "',Properties:{facing:'south',half:'upper',hinge:'left',open:'true',powered:'false'}}"));
        map.put("minecraft:" + string + "southupperlefttruetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "',Properties:{facing:'south',half:'upper',hinge:'left',open:'true',powered:'true'}}"));
        map.put("minecraft:" + string + "southupperrightfalsefalse", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "',Properties:{facing:'south',half:'upper',hinge:'right',open:'false',powered:'false'}}"));
        map.put("minecraft:" + string + "southupperrightfalsetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "',Properties:{facing:'south',half:'upper',hinge:'right',open:'false',powered:'true'}}"));
        map.put("minecraft:" + string + "southupperrighttruefalse", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "',Properties:{facing:'south',half:'upper',hinge:'right',open:'true',powered:'false'}}"));
        map.put("minecraft:" + string + "southupperrighttruetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "',Properties:{facing:'south',half:'upper',hinge:'right',open:'true',powered:'true'}}"));
        map.put("minecraft:" + string + "westlowerleftfalsefalse", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "',Properties:{facing:'west',half:'lower',hinge:'left',open:'false',powered:'false'}}"));
        map.put("minecraft:" + string + "westlowerleftfalsetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "',Properties:{facing:'west',half:'lower',hinge:'left',open:'false',powered:'true'}}"));
        map.put("minecraft:" + string + "westlowerlefttruefalse", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "',Properties:{facing:'west',half:'lower',hinge:'left',open:'true',powered:'false'}}"));
        map.put("minecraft:" + string + "westlowerlefttruetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "',Properties:{facing:'west',half:'lower',hinge:'left',open:'true',powered:'true'}}"));
        map.put("minecraft:" + string + "westlowerrightfalsefalse", BlockStateFlatteningMap.func_210049_b(n + 2));
        map.put("minecraft:" + string + "westlowerrightfalsetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "',Properties:{facing:'west',half:'lower',hinge:'right',open:'false',powered:'true'}}"));
        map.put("minecraft:" + string + "westlowerrighttruefalse", BlockStateFlatteningMap.func_210049_b(n + 6));
        map.put("minecraft:" + string + "westlowerrighttruetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "',Properties:{facing:'west',half:'lower',hinge:'right',open:'true',powered:'true'}}"));
        map.put("minecraft:" + string + "westupperleftfalsefalse", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "',Properties:{facing:'west',half:'upper',hinge:'left',open:'false',powered:'false'}}"));
        map.put("minecraft:" + string + "westupperleftfalsetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "',Properties:{facing:'west',half:'upper',hinge:'left',open:'false',powered:'true'}}"));
        map.put("minecraft:" + string + "westupperlefttruefalse", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "',Properties:{facing:'west',half:'upper',hinge:'left',open:'true',powered:'false'}}"));
        map.put("minecraft:" + string + "westupperlefttruetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "',Properties:{facing:'west',half:'upper',hinge:'left',open:'true',powered:'true'}}"));
        map.put("minecraft:" + string + "westupperrightfalsefalse", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "',Properties:{facing:'west',half:'upper',hinge:'right',open:'false',powered:'false'}}"));
        map.put("minecraft:" + string + "westupperrightfalsetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "',Properties:{facing:'west',half:'upper',hinge:'right',open:'false',powered:'true'}}"));
        map.put("minecraft:" + string + "westupperrighttruefalse", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "',Properties:{facing:'west',half:'upper',hinge:'right',open:'true',powered:'false'}}"));
        map.put("minecraft:" + string + "westupperrighttruetrue", BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "',Properties:{facing:'west',half:'upper',hinge:'right',open:'true',powered:'true'}}"));
    }

    private static void func_209307_a(Map<String, Dynamic<?>> map, int n, String string) {
        map.put("southfalsefoot" + n, BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "_bed',Properties:{facing:'south',occupied:'false',part:'foot'}}"));
        map.put("westfalsefoot" + n, BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "_bed',Properties:{facing:'west',occupied:'false',part:'foot'}}"));
        map.put("northfalsefoot" + n, BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "_bed',Properties:{facing:'north',occupied:'false',part:'foot'}}"));
        map.put("eastfalsefoot" + n, BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "_bed',Properties:{facing:'east',occupied:'false',part:'foot'}}"));
        map.put("southfalsehead" + n, BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "_bed',Properties:{facing:'south',occupied:'false',part:'head'}}"));
        map.put("westfalsehead" + n, BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "_bed',Properties:{facing:'west',occupied:'false',part:'head'}}"));
        map.put("northfalsehead" + n, BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "_bed',Properties:{facing:'north',occupied:'false',part:'head'}}"));
        map.put("eastfalsehead" + n, BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "_bed',Properties:{facing:'east',occupied:'false',part:'head'}}"));
        map.put("southtruehead" + n, BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "_bed',Properties:{facing:'south',occupied:'true',part:'head'}}"));
        map.put("westtruehead" + n, BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "_bed',Properties:{facing:'west',occupied:'true',part:'head'}}"));
        map.put("northtruehead" + n, BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "_bed',Properties:{facing:'north',occupied:'true',part:'head'}}"));
        map.put("easttruehead" + n, BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "_bed',Properties:{facing:'east',occupied:'true',part:'head'}}"));
    }

    private static void func_209297_b(Map<String, Dynamic<?>> map2, int n, String string) {
        Map<String, Dynamic<?>> map2;
        for (int i = 0; i < 16; ++i) {
            map2.put("" + i + "_" + n, BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "_banner',Properties:{rotation:'" + i + "'}}"));
        }
        map2.put("north_" + n, BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "_wall_banner',Properties:{facing:'north'}}"));
        map2.put("south_" + n, BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "_wall_banner',Properties:{facing:'south'}}"));
        map2.put("west_" + n, BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "_wall_banner',Properties:{facing:'west'}}"));
        map2.put("east_" + n, BlockStateFlatteningMap.func_210048_b("{Name:'minecraft:" + string + "_wall_banner',Properties:{facing:'east'}}"));
    }

    public static String func_209726_a(Dynamic<?> dynamic) {
        return dynamic.get("Name").asString("");
    }

    public static String func_209719_a(Dynamic<?> dynamic, String string) {
        return dynamic.get("Properties").get(string).asString("");
    }

    public static int func_209724_a(IntIdentityHashBiMap<Dynamic<?>> intIdentityHashBiMap, Dynamic<?> dynamic) {
        int n = intIdentityHashBiMap.func_148757_b(dynamic);
        if (n == -1) {
            n = intIdentityHashBiMap.func_186808_c(dynamic);
        }
        return n;
    }

    private Dynamic<?> func_209712_b(Dynamic<?> dynamic) {
        Optional optional = dynamic.get("Level").result();
        if (optional.isPresent() && ((Dynamic)optional.get()).get("Sections").asStreamOpt().result().isPresent()) {
            return dynamic.set("Level", new UpgradeChunk((Dynamic)optional.get()).func_210058_a());
        }
        return dynamic;
    }

    public TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(TypeReferences.field_211287_c);
        \u2603 = this.getOutputSchema().getType(TypeReferences.field_211287_c);
        return this.writeFixAndRead("ChunkPalettedStorageFix", type, \u2603, this::func_209712_b);
    }

    public static int func_210957_a(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        int n = 0;
        if (bl3) {
            n = bl2 ? (n |= 2) : (bl ? (n |= 0x80) : (n |= 1));
        } else if (bl4) {
            n = bl ? (n |= 0x20) : (bl2 ? (n |= 8) : (n |= 0x10));
        } else if (bl2) {
            n |= 4;
        } else if (bl) {
            n |= 0x40;
        }
        return n;
    }

    static {
        field_199147_c.set(2);
        field_199147_c.set(3);
        field_199147_c.set(110);
        field_199147_c.set(140);
        field_199147_c.set(144);
        field_199147_c.set(25);
        field_199147_c.set(86);
        field_199147_c.set(26);
        field_199147_c.set(176);
        field_199147_c.set(177);
        field_199147_c.set(175);
        field_199147_c.set(64);
        field_199147_c.set(71);
        field_199147_c.set(193);
        field_199147_c.set(194);
        field_199147_c.set(195);
        field_199147_c.set(196);
        field_199147_c.set(197);
        field_199146_b.set(54);
        field_199146_b.set(146);
        field_199146_b.set(25);
        field_199146_b.set(26);
        field_199146_b.set(51);
        field_199146_b.set(53);
        field_199146_b.set(67);
        field_199146_b.set(108);
        field_199146_b.set(109);
        field_199146_b.set(114);
        field_199146_b.set(128);
        field_199146_b.set(134);
        field_199146_b.set(135);
        field_199146_b.set(136);
        field_199146_b.set(156);
        field_199146_b.set(163);
        field_199146_b.set(164);
        field_199146_b.set(180);
        field_199146_b.set(203);
        field_199146_b.set(55);
        field_199146_b.set(85);
        field_199146_b.set(113);
        field_199146_b.set(188);
        field_199146_b.set(189);
        field_199146_b.set(190);
        field_199146_b.set(191);
        field_199146_b.set(192);
        field_199146_b.set(93);
        field_199146_b.set(94);
        field_199146_b.set(101);
        field_199146_b.set(102);
        field_199146_b.set(160);
        field_199146_b.set(106);
        field_199146_b.set(107);
        field_199146_b.set(183);
        field_199146_b.set(184);
        field_199146_b.set(185);
        field_199146_b.set(186);
        field_199146_b.set(187);
        field_199146_b.set(132);
        field_199146_b.set(139);
        field_199146_b.set(199);
        field_199165_u = BlockStateFlatteningMap.func_210049_b(0);
    }

    public static enum Direction {
        DOWN(Offset.NEGATIVE, Axis.Y),
        UP(Offset.POSITIVE, Axis.Y),
        NORTH(Offset.NEGATIVE, Axis.Z),
        SOUTH(Offset.POSITIVE, Axis.Z),
        WEST(Offset.NEGATIVE, Axis.X),
        EAST(Offset.POSITIVE, Axis.X);

        private final Axis field_210941_g;
        private final Offset field_210942_h;

        private Direction(Offset offset, Axis axis) {
            this.field_210941_g = axis;
            this.field_210942_h = offset;
        }

        public Offset func_210939_a() {
            return this.field_210942_h;
        }

        public Axis func_210940_b() {
            return this.field_210941_g;
        }

        public static enum Offset {
            POSITIVE(1),
            NEGATIVE(-1);

            private final int field_210938_c;

            private Offset(int n2) {
                this.field_210938_c = n2;
            }

            public int func_210937_a() {
                return this.field_210938_c;
            }
        }

        public static enum Axis {
            X,
            Y,
            Z;

        }
    }

    static class NibbleArray {
        private final byte[] field_210935_a;

        public NibbleArray() {
            this.field_210935_a = new byte[2048];
        }

        public NibbleArray(byte[] byArray) {
            this.field_210935_a = byArray;
            if (byArray.length != 2048) {
                throw new IllegalArgumentException("ChunkNibbleArrays should be 2048 bytes not: " + byArray.length);
            }
        }

        public int func_210932_a(int n, int n2, int n3) {
            \u2603 = this.func_210934_b(n2 << 8 | n3 << 4 | n);
            if (this.func_210933_a(n2 << 8 | n3 << 4 | n)) {
                return this.field_210935_a[\u2603] & 0xF;
            }
            return this.field_210935_a[\u2603] >> 4 & 0xF;
        }

        private boolean func_210933_a(int n) {
            return (n & 1) == 0;
        }

        private int func_210934_b(int n) {
            return n >> 1;
        }
    }

    static final class UpgradeChunk {
        private int field_199227_a;
        private final Section[] field_199228_b = new Section[16];
        private final Dynamic<?> field_199229_c;
        private final int field_199230_d;
        private final int field_199231_e;
        private final Int2ObjectMap<Dynamic<?>> field_199232_f = new Int2ObjectLinkedOpenHashMap(16);

        public UpgradeChunk(Dynamic<?> dynamic) {
            this.field_199229_c = dynamic;
            this.field_199230_d = dynamic.get("xPos").asInt(0) << 4;
            this.field_199231_e = dynamic.get("zPos").asInt(0) << 4;
            dynamic.get("TileEntities").asStreamOpt().result().ifPresent(stream -> stream.forEach(dynamic -> {
                int n = dynamic.get("x").asInt(0) - this.field_199230_d & 0xF;
                \u2603 = dynamic.get("y").asInt(0);
                \u2603 = \u2603 << 8 | (\u2603 = dynamic.get("z").asInt(0) - this.field_199231_e & 0xF) << 4 | n;
                if (this.field_199232_f.put(\u2603, dynamic) != null) {
                    field_199145_a.warn("In chunk: {}x{} found a duplicate block entity at position: [{}, {}, {}]", (Object)this.field_199230_d, (Object)this.field_199231_e, (Object)n, (Object)\u2603, (Object)\u2603);
                }
            }));
            boolean bl = dynamic.get("convertedFromAlphaFormat").asBoolean(false);
            dynamic.get("Sections").asStreamOpt().result().ifPresent(stream -> stream.forEach(dynamic -> {
                Section section = new Section((Dynamic<?>)dynamic);
                this.field_199227_a = section.func_199207_b(this.field_199227_a);
                this.field_199228_b[section.field_199212_c] = section;
            }));
            for (Section section : this.field_199228_b) {
                if (section == null) continue;
                block14: for (Map.Entry entry2 : section.field_199215_f.entrySet()) {
                    int n = section.field_199212_c << 12;
                    switch ((Integer)entry2.getKey()) {
                        case 2: {
                            Dynamic<?> \u26032;
                            IntListIterator intListIterator = ((IntList)entry2.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                n2 = (Integer)intListIterator.next();
                                \u26032 = this.func_210064_a(n2 |= n);
                                if (!"minecraft:grass_block".equals(ChunkPaletteFormat.func_209726_a(\u26032)) || !"minecraft:snow".equals(\u26033 = ChunkPaletteFormat.func_209726_a(this.func_210064_a(UpgradeChunk.func_199223_a(n2, Direction.UP)))) && !"minecraft:snow_layer".equals(\u26033)) continue;
                                this.func_210060_a(n2, field_199150_f);
                            }
                            continue block14;
                        }
                        case 3: {
                            Dynamic<?> \u26032;
                            Map.Entry entry2;
                            IntListIterator intListIterator = ((IntList)entry2.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                int n2 = (Integer)intListIterator.next();
                                \u26032 = this.func_210064_a(n2 |= n);
                                if (!"minecraft:podzol".equals(ChunkPaletteFormat.func_209726_a(\u26032)) || !"minecraft:snow".equals(\u26033 = ChunkPaletteFormat.func_209726_a(this.func_210064_a(UpgradeChunk.func_199223_a(n2, Direction.UP)))) && !"minecraft:snow_layer".equals(\u26033)) continue;
                                this.func_210060_a(n2, field_199149_e);
                            }
                            continue block14;
                        }
                        case 110: {
                            Dynamic<?> \u26032;
                            IntListIterator intListIterator = ((IntList)entry2.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                n2 = (Integer)intListIterator.next();
                                \u26032 = this.func_210064_a(n2 |= n);
                                if (!"minecraft:mycelium".equals(ChunkPaletteFormat.func_209726_a(\u26032)) || !"minecraft:snow".equals(\u26033 = ChunkPaletteFormat.func_209726_a(this.func_210064_a(UpgradeChunk.func_199223_a(n2, Direction.UP)))) && !"minecraft:snow_layer".equals(\u26033)) continue;
                                this.func_210060_a(n2, field_199151_g);
                            }
                            continue block14;
                        }
                        case 25: {
                            Object \u26033;
                            Dynamic<?> \u26032;
                            IntListIterator intListIterator = ((IntList)entry2.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                n2 = (Integer)intListIterator.next();
                                \u26032 = this.func_210059_c(n2 |= n);
                                if (\u26032 == null) continue;
                                \u26033 = Boolean.toString(\u26032.get("powered").asBoolean(false)) + (byte)Math.min(Math.max(\u26032.get("note").asInt(0), 0), 24);
                                this.func_210060_a(n2, (Dynamic)field_199161_q.getOrDefault(\u26033, field_199161_q.get("false0")));
                            }
                            continue block14;
                        }
                        case 26: {
                            Object \u26034;
                            Object \u26033;
                            Dynamic<?> \u26032;
                            IntListIterator intListIterator = ((IntList)entry2.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                n2 = (Integer)intListIterator.next();
                                \u26032 = this.func_210066_b(n2 |= n);
                                \u26033 = this.func_210064_a(n2);
                                if (\u26032 == null || (\u2603 = \u26032.get("color").asInt(0)) == 14 || \u2603 < 0 || \u2603 >= 16) continue;
                                \u26034 = ChunkPaletteFormat.func_209719_a(\u26033, "facing") + ChunkPaletteFormat.func_209719_a(\u26033, "occupied") + ChunkPaletteFormat.func_209719_a(\u26033, "part") + \u2603;
                                if (!field_199163_s.containsKey(\u26034)) continue;
                                this.func_210060_a(n2, (Dynamic)field_199163_s.get(\u26034));
                            }
                            continue block14;
                        }
                        case 176: 
                        case 177: {
                            Object \u26034;
                            Object \u26033;
                            Dynamic<?> \u26032;
                            IntListIterator intListIterator = ((IntList)entry2.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                n2 = (Integer)intListIterator.next();
                                \u26032 = this.func_210066_b(n2 |= n);
                                \u26033 = this.func_210064_a(n2);
                                if (\u26032 == null || (\u2603 = \u26032.get("Base").asInt(0)) == 15 || \u2603 < 0 || \u2603 >= 16) continue;
                                \u26034 = ChunkPaletteFormat.func_209719_a(\u26033, (Integer)entry2.getKey() == 176 ? "rotation" : "facing") + "_" + \u2603;
                                if (!field_199164_t.containsKey(\u26034)) continue;
                                this.func_210060_a(n2, (Dynamic)field_199164_t.get(\u26034));
                            }
                            continue block14;
                        }
                        case 86: {
                            Object \u26033;
                            Dynamic<?> \u26032;
                            IntListIterator intListIterator = ((IntList)entry2.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                n2 = (Integer)intListIterator.next();
                                \u26032 = this.func_210064_a(n2 |= n);
                                if (!"minecraft:carved_pumpkin".equals(ChunkPaletteFormat.func_209726_a(\u26032)) || !"minecraft:grass_block".equals(\u26033 = ChunkPaletteFormat.func_209726_a(this.func_210064_a(UpgradeChunk.func_199223_a(n2, Direction.DOWN)))) && !"minecraft:dirt".equals(\u26033)) continue;
                                this.func_210060_a(n2, field_199148_d);
                            }
                            continue block14;
                        }
                        case 140: {
                            Object \u26033;
                            Dynamic<?> \u26032;
                            IntListIterator intListIterator = ((IntList)entry2.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                n2 = (Integer)intListIterator.next();
                                \u26032 = this.func_210059_c(n2 |= n);
                                if (\u26032 == null) continue;
                                \u26033 = \u26032.get("Item").asString("") + \u26032.get("Data").asInt(0);
                                this.func_210060_a(n2, (Dynamic)field_199158_n.getOrDefault(\u26033, field_199158_n.get("minecraft:air0")));
                            }
                            continue block14;
                        }
                        case 144: {
                            Object \u26034;
                            Object \u26033;
                            Dynamic<?> \u26032;
                            IntListIterator intListIterator = ((IntList)entry2.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                n2 = (Integer)intListIterator.next();
                                \u26032 = this.func_210066_b(n2 |= n);
                                if (\u26032 == null) continue;
                                \u26033 = String.valueOf(\u26032.get("SkullType").asInt(0));
                                String \u26035 = ChunkPaletteFormat.func_209719_a(this.func_210064_a(n2), "facing");
                                \u26034 = "up".equals(\u26035) || "down".equals(\u26035) ? \u26033 + String.valueOf(\u26032.get("Rot").asInt(0)) : \u26033 + \u26035;
                                \u26032.remove("SkullType");
                                \u26032.remove("facing");
                                \u26032.remove("Rot");
                                this.func_210060_a(n2, (Dynamic)field_199159_o.getOrDefault(\u26034, field_199159_o.get("0north")));
                            }
                            continue block14;
                        }
                        case 64: 
                        case 71: 
                        case 193: 
                        case 194: 
                        case 195: 
                        case 196: 
                        case 197: {
                            Object \u26034;
                            Object \u26033;
                            Dynamic<?> \u26032;
                            IntListIterator intListIterator = ((IntList)entry2.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                n2 = (Integer)intListIterator.next();
                                \u26032 = this.func_210064_a(n2 |= n);
                                if (!ChunkPaletteFormat.func_209726_a(\u26032).endsWith("_door") || !"lower".equals(ChunkPaletteFormat.func_209719_a(\u26033 = this.func_210064_a(n2), "half"))) continue;
                                \u2603 = UpgradeChunk.func_199223_a(n2, Direction.UP);
                                \u26034 = this.func_210064_a(\u2603);
                                String \u26036 = ChunkPaletteFormat.func_209726_a(\u26033);
                                if (!\u26036.equals(ChunkPaletteFormat.func_209726_a(\u26034))) continue;
                                String \u26037 = ChunkPaletteFormat.func_209719_a(\u26033, "facing");
                                String \u26038 = ChunkPaletteFormat.func_209719_a(\u26033, "open");
                                String \u26039 = bl ? "left" : ChunkPaletteFormat.func_209719_a(\u26034, "hinge");
                                String \u260310 = bl ? "false" : ChunkPaletteFormat.func_209719_a(\u26034, "powered");
                                this.func_210060_a(n2, (Dynamic)field_199160_p.get(\u26036 + \u26037 + "lower" + \u26039 + \u26038 + \u260310));
                                this.func_210060_a(\u2603, (Dynamic)field_199160_p.get(\u26036 + \u26037 + "upper" + \u26039 + \u26038 + \u260310));
                            }
                            continue block14;
                        }
                        case 175: {
                            Object \u26033;
                            Dynamic<?> \u26032;
                            IntListIterator intListIterator = ((IntList)entry2.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                n2 = (Integer)intListIterator.next();
                                \u26032 = this.func_210064_a(n2 |= n);
                                if (!"upper".equals(ChunkPaletteFormat.func_209719_a(\u26032, "half"))) continue;
                                \u26033 = this.func_210064_a(UpgradeChunk.func_199223_a(n2, Direction.DOWN));
                                String \u260311 = ChunkPaletteFormat.func_209726_a(\u26033);
                                if ("minecraft:sunflower".equals(\u260311)) {
                                    this.func_210060_a(n2, field_199152_h);
                                    continue;
                                }
                                if ("minecraft:lilac".equals(\u260311)) {
                                    this.func_210060_a(n2, field_199153_i);
                                    continue;
                                }
                                if ("minecraft:tall_grass".equals(\u260311)) {
                                    this.func_210060_a(n2, field_199154_j);
                                    continue;
                                }
                                if ("minecraft:large_fern".equals(\u260311)) {
                                    this.func_210060_a(n2, field_199155_k);
                                    continue;
                                }
                                if ("minecraft:rose_bush".equals(\u260311)) {
                                    this.func_210060_a(n2, field_199156_l);
                                    continue;
                                }
                                if (!"minecraft:peony".equals(\u260311)) continue;
                                this.func_210060_a(n2, field_199157_m);
                            }
                            break;
                        }
                    }
                }
            }
        }

        @Nullable
        private Dynamic<?> func_210066_b(int n) {
            return (Dynamic)this.field_199232_f.get(n);
        }

        @Nullable
        private Dynamic<?> func_210059_c(int n) {
            return (Dynamic)this.field_199232_f.remove(n);
        }

        public static int func_199223_a(int n3, Direction direction) {
            switch (direction.func_210940_b()) {
                case X: {
                    int n2 = (n3 & 0xF) + direction.func_210939_a().func_210937_a();
                    return n2 < 0 || n2 > 15 ? -1 : n3 & 0xFFFFFFF0 | n2;
                }
                case Y: {
                    int n3;
                    \u2603 = (n3 >> 8) + direction.func_210939_a().func_210937_a();
                    return \u2603 < 0 || \u2603 > 255 ? -1 : n3 & 0xFF | \u2603 << 8;
                }
                case Z: {
                    int n3;
                    \u2603 = (n3 >> 4 & 0xF) + direction.func_210939_a().func_210937_a();
                    return \u2603 < 0 || \u2603 > 15 ? -1 : n3 & 0xFFFFFF0F | \u2603 << 4;
                }
            }
            return -1;
        }

        private void func_210060_a(int n, Dynamic<?> dynamic) {
            if (n < 0 || n > 65535) {
                return;
            }
            Section section = this.func_199221_d(n);
            if (section == null) {
                return;
            }
            section.func_210053_a(n & 0xFFF, dynamic);
        }

        @Nullable
        private Section func_199221_d(int n) {
            \u2603 = n >> 12;
            return \u2603 < this.field_199228_b.length ? this.field_199228_b[\u2603] : null;
        }

        public Dynamic<?> func_210064_a(int n) {
            if (n < 0 || n > 65535) {
                return field_199165_u;
            }
            Section section = this.func_199221_d(n);
            if (section == null) {
                return field_199165_u;
            }
            return section.func_210056_a(n & 0xFFF);
        }

        public Dynamic<?> func_210058_a() {
            Dynamic dynamic = this.field_199229_c;
            dynamic = this.field_199232_f.isEmpty() ? dynamic.remove("TileEntities") : dynamic.set("TileEntities", dynamic.createList(this.field_199232_f.values().stream()));
            dynamic2 = dynamic.emptyMap();
            ArrayList \u26032 = Lists.newArrayList();
            for (Section section : this.field_199228_b) {
                if (section == null) continue;
                \u26032.add(section.func_210051_a());
                Dynamic dynamic2 = dynamic2.set(String.valueOf(section.field_199212_c), dynamic2.createIntList(Arrays.stream(section.field_199216_g.toIntArray())));
            }
            \u2603 = dynamic.emptyMap();
            \u2603 = \u2603.set("Sides", \u2603.createByte((byte)this.field_199227_a));
            \u2603 = \u2603.set("Indices", dynamic2);
            return dynamic.set("UpgradeData", \u2603).set("Sections", \u2603.createList(\u26032.stream()));
        }
    }

    static class Section {
        private final IntIdentityHashBiMap<Dynamic<?>> field_199210_a = new IntIdentityHashBiMap(32);
        private final List<Dynamic<?>> field_199211_b;
        private final Dynamic<?> field_199213_d;
        private final boolean field_199214_e;
        private final Int2ObjectMap<IntList> field_199215_f = new Int2ObjectLinkedOpenHashMap();
        private final IntList field_199216_g = new IntArrayList();
        public final int field_199212_c;
        private final Set<Dynamic<?>> field_199217_h = Sets.newIdentityHashSet();
        private final int[] field_199218_i = new int[4096];

        public Section(Dynamic<?> dynamic) {
            this.field_199211_b = Lists.newArrayList();
            this.field_199213_d = dynamic;
            this.field_199212_c = dynamic.get("Y").asInt(0);
            this.field_199214_e = dynamic.get("Blocks").result().isPresent();
        }

        public Dynamic<?> func_210056_a(int n) {
            if (n < 0 || n > 4095) {
                return field_199165_u;
            }
            Dynamic<?> dynamic = this.field_199210_a.func_148745_a(this.field_199218_i[n]);
            return dynamic == null ? field_199165_u : dynamic;
        }

        public void func_210053_a(int n, Dynamic<?> dynamic) {
            if (this.field_199217_h.add(dynamic)) {
                this.field_199211_b.add("%%FILTER_ME%%".equals(ChunkPaletteFormat.func_209726_a(dynamic)) ? field_199165_u : dynamic);
            }
            this.field_199218_i[n] = ChunkPaletteFormat.func_209724_a(this.field_199210_a, dynamic);
        }

        public int func_199207_b(int n2) {
            int n2;
            if (!this.field_199214_e) {
                return n2;
            }
            ByteBuffer byteBuffer2 = (ByteBuffer)this.field_199213_d.get("Blocks").asByteBufferOpt().result().get();
            NibbleArray \u26032 = this.field_199213_d.get("Data").asByteBufferOpt().map(byteBuffer -> new NibbleArray(DataFixUtils.toArray((ByteBuffer)byteBuffer))).result().orElseGet(NibbleArray::new);
            NibbleArray \u26033 = this.field_199213_d.get("Add").asByteBufferOpt().map(byteBuffer -> new NibbleArray(DataFixUtils.toArray((ByteBuffer)byteBuffer))).result().orElseGet(NibbleArray::new);
            this.field_199217_h.add(field_199165_u);
            ChunkPaletteFormat.func_209724_a(this.field_199210_a, field_199165_u);
            this.field_199211_b.add(field_199165_u);
            for (int i = 0; i < 4096; ++i) {
                \u2603 = i & 0xF;
                \u2603 = i >> 8 & 0xF;
                \u2603 = i >> 4 & 0xF;
                \u2603 = \u26033.func_210932_a(\u2603, \u2603, \u2603) << 12 | (byteBuffer2.get(i) & 0xFF) << 4 | \u26032.func_210932_a(\u2603, \u2603, \u2603);
                if (field_199147_c.get(\u2603 >> 4)) {
                    this.func_199205_a(\u2603 >> 4, i);
                }
                if (field_199146_b.get(\u2603 >> 4)) {
                    \u2603 = ChunkPaletteFormat.func_210957_a(\u2603 == 0, \u2603 == 15, \u2603 == 0, \u2603 == 15);
                    if (\u2603 == 0) {
                        this.field_199216_g.add(i);
                    } else {
                        n2 |= \u2603;
                    }
                }
                this.func_210053_a(i, BlockStateFlatteningMap.func_210049_b(\u2603));
            }
            return n2;
        }

        private void func_199205_a(int n, int n2) {
            IntList intList = (IntList)this.field_199215_f.get(n);
            if (intList == null) {
                intList = new IntArrayList();
                this.field_199215_f.put(n, (Object)intList);
            }
            intList.add(n2);
        }

        public Dynamic<?> func_210051_a() {
            Dynamic dynamic = this.field_199213_d;
            if (!this.field_199214_e) {
                return dynamic;
            }
            dynamic = dynamic.set("Palette", dynamic.createList(this.field_199211_b.stream()));
            int \u26032 = Math.max(4, DataFixUtils.ceillog2((int)this.field_199217_h.size()));
            ArbitraryBitLengthIntArray \u26033 = new ArbitraryBitLengthIntArray(\u26032, 4096);
            for (int i = 0; i < this.field_199218_i.length; ++i) {
                \u26033.func_233049_a_(i, this.field_199218_i[i]);
            }
            dynamic = dynamic.set("BlockStates", dynamic.createLongList(Arrays.stream(\u26033.func_233047_a_())));
            dynamic = dynamic.remove("Blocks");
            dynamic = dynamic.remove("Data");
            dynamic = dynamic.remove("Add");
            return dynamic;
        }
    }
}

