/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EnderPearlEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.EndPortalTileEntity;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.feature.EndGatewayConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.server.ServerWorld;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EndGatewayTileEntity
extends EndPortalTileEntity
implements ITickableTileEntity {
    private static final Logger field_195503_a = LogManager.getLogger();
    private long field_195504_f;
    private int field_195505_g;
    @Nullable
    private BlockPos field_195506_h;
    private boolean field_195507_i;

    public EndGatewayTileEntity() {
        super(TileEntityType.field_200991_v);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compoundNBT) {
        super.func_189515_b(compoundNBT);
        compoundNBT.func_74772_a("Age", this.field_195504_f);
        if (this.field_195506_h != null) {
            compoundNBT.func_218657_a("ExitPortal", NBTUtil.func_186859_a(this.field_195506_h));
        }
        if (this.field_195507_i) {
            compoundNBT.func_74757_a("ExactTeleport", this.field_195507_i);
        }
        return compoundNBT;
    }

    @Override
    public void func_230337_a_(BlockState blockState, CompoundNBT compoundNBT) {
        super.func_230337_a_(blockState, compoundNBT);
        this.field_195504_f = compoundNBT.func_74763_f("Age");
        if (compoundNBT.func_150297_b("ExitPortal", 10)) {
            this.field_195506_h = NBTUtil.func_186861_c(compoundNBT.func_74775_l("ExitPortal"));
        }
        this.field_195507_i = compoundNBT.func_74767_n("ExactTeleport");
    }

    @Override
    public double func_145833_n() {
        return 256.0;
    }

    @Override
    public void func_73660_a() {
        boolean bl = this.func_195499_c();
        \u2603 = this.func_195500_d();
        ++this.field_195504_f;
        if (\u2603) {
            --this.field_195505_g;
        } else if (!this.field_145850_b.field_72995_K) {
            List<Entity> list = this.field_145850_b.func_175647_a(Entity.class, new AxisAlignedBB(this.func_174877_v()), EndGatewayTileEntity::func_242690_a);
            if (!list.isEmpty()) {
                this.func_195496_a(list.get(this.field_145850_b.field_73012_v.nextInt(list.size())));
            }
            if (this.field_195504_f % 2400L == 0L) {
                this.func_195490_f();
            }
        }
        if (bl != this.func_195499_c() || \u2603 != this.func_195500_d()) {
            this.func_70296_d();
        }
    }

    public static boolean func_242690_a(Entity entity) {
        return EntityPredicates.field_180132_d.test(entity) && !entity.func_184208_bv().func_242280_ah();
    }

    public boolean func_195499_c() {
        return this.field_195504_f < 200L;
    }

    public boolean func_195500_d() {
        return this.field_195505_g > 0;
    }

    public float func_195497_a(float f) {
        return MathHelper.func_76131_a(((float)this.field_195504_f + f) / 200.0f, 0.0f, 1.0f);
    }

    public float func_195491_b(float f) {
        return 1.0f - MathHelper.func_76131_a(((float)this.field_195505_g - f) / 40.0f, 0.0f, 1.0f);
    }

    @Override
    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 8, this.func_189517_E_());
    }

    @Override
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void func_195490_f() {
        if (!this.field_145850_b.field_72995_K) {
            this.field_195505_g = 40;
            this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_195044_w().func_177230_c(), 1, 0);
            this.func_70296_d();
        }
    }

    @Override
    public boolean func_145842_c(int n, int n2) {
        if (n == 1) {
            this.field_195505_g = 40;
            return true;
        }
        return super.func_145842_c(n, n2);
    }

    public void func_195496_a(Entity entity) {
        if (!(this.field_145850_b instanceof ServerWorld) || this.func_195500_d()) {
            return;
        }
        this.field_195505_g = 100;
        if (this.field_195506_h == null && this.field_145850_b.func_234923_W_() == World.field_234920_i_) {
            this.func_227015_a_((ServerWorld)this.field_145850_b);
        }
        if (this.field_195506_h != null) {
            BlockPos blockPos = \u2603 = this.field_195507_i ? this.field_195506_h : this.func_195502_i();
            if (entity instanceof EnderPearlEntity) {
                \u2603 = ((EnderPearlEntity)entity).func_234616_v_();
                if (\u2603 instanceof ServerPlayerEntity) {
                    CriteriaTriggers.field_192124_d.func_192193_a((ServerPlayerEntity)\u2603, this.field_145850_b.func_180495_p(this.func_174877_v()));
                }
                if (\u2603 != null) {
                    \u2603 = \u2603;
                    entity.func_70106_y();
                } else {
                    \u2603 = entity;
                }
            } else {
                \u2603 = entity.func_184208_bv();
            }
            \u2603.func_242279_ag();
            \u2603.func_223102_j((double)\u2603.func_177958_n() + 0.5, \u2603.func_177956_o(), (double)\u2603.func_177952_p() + 0.5);
        }
        this.func_195490_f();
    }

    private BlockPos func_195502_i() {
        BlockPos blockPos = EndGatewayTileEntity.func_195494_a(this.field_145850_b, this.field_195506_h.func_177982_a(0, 2, 0), 5, false);
        field_195503_a.debug("Best exit position for portal at {} is {}", (Object)this.field_195506_h, (Object)blockPos);
        return blockPos.func_177984_a();
    }

    private void func_227015_a_(ServerWorld serverWorld) {
        Vector3d vector3d = new Vector3d(this.func_174877_v().func_177958_n(), 0.0, this.func_174877_v().func_177952_p()).func_72432_b();
        \u2603 = vector3d.func_186678_a(1024.0);
        int \u26032 = 16;
        while (EndGatewayTileEntity.func_195495_a(serverWorld, \u2603).func_76625_h() > 0 && \u26032-- > 0) {
            field_195503_a.debug("Skipping backwards past nonempty chunk at {}", (Object)\u2603);
            \u2603 = \u2603.func_178787_e(vector3d.func_186678_a(-16.0));
        }
        \u26032 = 16;
        while (EndGatewayTileEntity.func_195495_a(serverWorld, \u2603).func_76625_h() == 0 && \u26032-- > 0) {
            field_195503_a.debug("Skipping forward past empty chunk at {}", (Object)\u2603);
            \u2603 = \u2603.func_178787_e(vector3d.func_186678_a(16.0));
        }
        field_195503_a.debug("Found chunk at {}", (Object)\u2603);
        Chunk \u26033 = EndGatewayTileEntity.func_195495_a(serverWorld, \u2603);
        this.field_195506_h = EndGatewayTileEntity.func_195498_a(\u26033);
        if (this.field_195506_h == null) {
            this.field_195506_h = new BlockPos(\u2603.field_72450_a + 0.5, 75.0, \u2603.field_72449_c + 0.5);
            field_195503_a.debug("Failed to find suitable block, settling on {}", (Object)this.field_195506_h);
            Features.field_243945_e.func_242765_a(serverWorld, serverWorld.func_72863_F().func_201711_g(), new Random(this.field_195506_h.func_218275_a()), this.field_195506_h);
        } else {
            field_195503_a.debug("Found block at {}", (Object)this.field_195506_h);
        }
        this.field_195506_h = EndGatewayTileEntity.func_195494_a(serverWorld, this.field_195506_h, 16, true);
        field_195503_a.debug("Creating portal at {}", (Object)this.field_195506_h);
        this.field_195506_h = this.field_195506_h.func_177981_b(10);
        this.func_227016_a_(serverWorld, this.field_195506_h);
        this.func_70296_d();
    }

    private static BlockPos func_195494_a(IBlockReader iBlockReader, BlockPos blockPos, int n, boolean bl) {
        Vector3i \u26033 = null;
        for (int i = -n; i <= n; ++i) {
            block1: for (\u2603 = -n; \u2603 <= n; ++\u2603) {
                if (i == 0 && \u2603 == 0 && !bl) continue;
                for (\u2603 = 255; \u2603 > (\u26033 == null ? 0 : \u26033.func_177956_o()); --\u2603) {
                    BlockPos blockPos2 = new BlockPos(blockPos.func_177958_n() + i, \u2603, blockPos.func_177952_p() + \u2603);
                    BlockState \u26032 = iBlockReader.func_180495_p(blockPos2);
                    if (!\u26032.func_235785_r_(iBlockReader, blockPos2) || !bl && \u26032.func_203425_a(Blocks.field_150357_h)) continue;
                    \u26033 = blockPos2;
                    continue block1;
                }
            }
        }
        return \u26033 == null ? blockPos : \u26033;
    }

    private static Chunk func_195495_a(World world, Vector3d vector3d) {
        return world.func_212866_a_(MathHelper.func_76128_c(vector3d.field_72450_a / 16.0), MathHelper.func_76128_c(vector3d.field_72449_c / 16.0));
    }

    @Nullable
    private static BlockPos func_195498_a(Chunk chunk) {
        ChunkPos chunkPos = chunk.func_76632_l();
        BlockPos \u26032 = new BlockPos(chunkPos.func_180334_c(), 30, chunkPos.func_180333_d());
        int \u26033 = chunk.func_76625_h() + 16 - 1;
        BlockPos \u26034 = new BlockPos(chunkPos.func_180332_e(), \u26033, chunkPos.func_180330_f());
        BlockPos \u26035 = null;
        double \u26036 = 0.0;
        for (BlockPos blockPos : BlockPos.func_218278_a(\u26032, \u26034)) {
            BlockState blockState = chunk.func_180495_p(blockPos);
            BlockPos \u26037 = blockPos.func_177984_a();
            BlockPos \u26038 = blockPos.func_177981_b(2);
            if (!blockState.func_203425_a(Blocks.field_150377_bs) || chunk.func_180495_p(\u26037).func_235785_r_(chunk, \u26037) || chunk.func_180495_p(\u26038).func_235785_r_(chunk, \u26038)) continue;
            double \u26039 = blockPos.func_218140_a(0.0, 0.0, 0.0, true);
            if (\u26035 != null && !(\u26039 < \u26036)) continue;
            \u26035 = blockPos;
            \u26036 = \u26039;
        }
        return \u26035;
    }

    private void func_227016_a_(ServerWorld serverWorld, BlockPos blockPos) {
        Feature.field_202299_as.func_225566_b_(EndGatewayConfig.func_214702_a(this.func_174877_v(), false)).func_242765_a(serverWorld, serverWorld.func_72863_F().func_201711_g(), new Random(), blockPos);
    }

    @Override
    public boolean func_184313_a(Direction direction) {
        return Block.func_176225_a(this.func_195044_w(), this.field_145850_b, this.func_174877_v(), direction);
    }

    public int func_195493_h() {
        int n = 0;
        for (Direction direction : Direction.values()) {
            n += this.func_184313_a(direction) ? 1 : 0;
        }
        return n;
    }

    public void func_195489_b(BlockPos blockPos, boolean bl) {
        this.field_195507_i = bl;
        this.field_195506_h = blockPos;
    }
}

